/*
 * Decompiled with CFR 0.152.
 */
package org.jaxrx.resource;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.jaxrx.JaxRx;
import org.jaxrx.core.JaxRxConstants;
import org.jaxrx.core.JaxRxException;
import org.jaxrx.core.QueryParameter;
import org.jaxrx.core.ResourcePath;
import org.jaxrx.core.SchemaChecker;
import org.jaxrx.core.Systems;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class AResource {
    protected static final String APPLICATION_QUERY_XML = "application/query+xml";

    AResource() {
    }

    private StreamingOutput createOutput(JaxRx impl, ResourcePath path) {
        String qu = path.getValue(QueryParameter.COMMAND);
        if (qu != null) {
            return impl.command(qu, path);
        }
        qu = path.getValue(QueryParameter.RUN);
        if (qu != null) {
            return impl.run(qu, path);
        }
        qu = path.getValue(QueryParameter.QUERY);
        if (qu != null) {
            return impl.query(qu, path);
        }
        return impl.get(path);
    }

    Response createResponse(JaxRx impl, ResourcePath path) {
        StreamingOutput out = this.createOutput(impl, path);
        boolean wrap = path.getValue(QueryParameter.WRAP) == null || path.getValue(QueryParameter.WRAP).equals("yes");
        String type = wrap ? "application/xml" : "text/plain";
        String op = path.getValue(QueryParameter.OUTPUT);
        if (op != null) {
            Scanner sc = new Scanner(op);
            sc.useDelimiter(",");
            while (sc.hasNext()) {
                String[] sp = sc.next().split("=", 2);
                if (sp.length == 1) continue;
                if (sp[0].equals("method")) {
                    String[][] stringArray = JaxRxConstants.METHODS;
                    int n = JaxRxConstants.METHODS.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String[] m = stringArray[n2];
                        if (sp[1].equals(m[0])) {
                            type = m[1];
                        }
                        ++n2;
                    }
                    continue;
                }
                if (!sp[0].equals("media-type")) continue;
                type = sp[1];
            }
        }
        MediaType mt = null;
        try {
            mt = MediaType.valueOf((String)type);
        }
        catch (IllegalArgumentException ex) {
            throw new JaxRxException(400, ex.getMessage());
        }
        return Response.ok((Object)out, (MediaType)mt).build();
    }

    protected Map<QueryParameter, String> getParameters(UriInfo uri, JaxRx jaxrx) {
        MultivaluedMap params = uri.getQueryParameters();
        Map<QueryParameter, String> newParam = this.createMap();
        Set<QueryParameter> impl = jaxrx.getParameters();
        for (String key : params.keySet()) {
            for (String s : (List)params.get((Object)key)) {
                this.addParameter(key, s, newParam, impl);
            }
        }
        return newParam;
    }

    protected Map<QueryParameter, String> getParameters(Document doc, JaxRx jaxrx) {
        String val;
        NamedNodeMap nnm;
        Map<QueryParameter, String> newParams = this.createMap();
        Set<QueryParameter> impl = jaxrx.getParameters();
        String root = doc.getDocumentElement().getNodeName();
        QueryParameter ep = QueryParameter.valueOf(root.toUpperCase());
        newParams.put(ep, doc.getElementsByTagName("text").item(0).getTextContent());
        NodeList props = doc.getElementsByTagName("parameter");
        int i = 0;
        while (i < props.getLength()) {
            nnm = props.item(i).getAttributes();
            this.addParameter(nnm.getNamedItem("name").getNodeValue(), nnm.getNamedItem("value").getNodeValue(), newParams, impl);
            ++i;
        }
        props = doc.getElementsByTagName("variable");
        i = 0;
        while (i < props.getLength()) {
            nnm = props.item(i).getAttributes();
            val = String.valueOf(nnm.getNamedItem("name").getNodeValue()) + '\u0002' + nnm.getNamedItem("value").getNodeValue();
            Node type = nnm.getNamedItem("type");
            if (type != null) {
                val = String.valueOf(val) + '\u0002' + type.getNodeValue();
            }
            this.addParameter("var", val, newParams, impl);
            ++i;
        }
        props = doc.getElementsByTagName("output");
        i = 0;
        while (i < props.getLength()) {
            nnm = props.item(i).getAttributes();
            val = String.valueOf(nnm.getNamedItem("name").getNodeValue()) + '=' + nnm.getNamedItem("value").getNodeValue();
            this.addParameter("output", val, newParams, impl);
            ++i;
        }
        return newParams;
    }

    private void addParameter(String key, String value, Map<QueryParameter, String> newParams, Set<QueryParameter> impl) {
        try {
            QueryParameter ep = QueryParameter.valueOf(key.toUpperCase());
            if (!impl.contains((Object)ep)) {
                throw new JaxRxException(400, "Parameter '" + key + "' is not supported by the implementation.");
            }
            String old = newParams.get((Object)ep);
            if (ep != QueryParameter.OUTPUT && ep != QueryParameter.VAR && old != null) {
                return;
            }
            char del = ep == QueryParameter.OUTPUT ? (char)',' : '\u0001';
            newParams.put(ep, old == null ? value : String.valueOf(old) + del + value);
        }
        catch (IllegalArgumentException ex) {
            throw new JaxRxException(400, "Parameter '" + key + "' is unknown.");
        }
    }

    private Map<QueryParameter, String> createMap() {
        HashMap<QueryParameter, String> params = new HashMap<QueryParameter, String>();
        Properties props = System.getProperties();
        for (Map.Entry<Object, Object> set : props.entrySet()) {
            String up;
            String key = set.getKey().toString();
            if (key.equals(up = key.replace("org.jaxrx.parameter.", ""))) continue;
            try {
                params.put(QueryParameter.valueOf(up.toUpperCase()), set.getValue().toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return params;
    }

    public Response postQuery(String system, InputStream input, String resource, HttpHeaders httpHeaders) {
        JaxRx impl = Systems.getInstance(system);
        Document doc = new SchemaChecker("post").check(input);
        Map<QueryParameter, String> param = this.getParameters(doc, impl);
        ResourcePath path = new ResourcePath(resource, param, httpHeaders);
        return this.createResponse(impl, path);
    }

    public Response getResource(String system, UriInfo uri, String resource, HttpHeaders headers) {
        JaxRx impl = Systems.getInstance(system);
        Map<QueryParameter, String> param = this.getParameters(uri, impl);
        ResourcePath path = new ResourcePath(resource, param, headers);
        return this.createResponse(impl, path);
    }
}

