/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.init;

import com.evolveum.midpoint.common.configuration.api.MidpointConfiguration;
import com.evolveum.midpoint.init.ApplicationHomeSetup;
import com.evolveum.midpoint.util.ClassPathUtil;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang.NotImplementedException;

public class StartupConfiguration
implements MidpointConfiguration {
    private static final Trace LOGGER = TraceManager.getTrace(StartupConfiguration.class);
    private static final String USER_HOME = "user.home";
    private static final String MIDPOINT_HOME = "midpoint.home";
    private CompositeConfiguration config = null;
    private String configFilename = null;

    public StartupConfiguration() {
        this.configFilename = "config.xml";
    }

    public StartupConfiguration(String configFilename) {
        this.configFilename = configFilename;
    }

    public String getConfigFilename() {
        return this.configFilename;
    }

    public void setConfigFilename(String configFilename) {
        this.configFilename = configFilename;
    }

    public String getMidpointHome() {
        return System.getProperty(MIDPOINT_HOME);
    }

    public Configuration getConfiguration(String componentName) {
        String key;
        Iterator i;
        if (componentName == null) {
            throw new IllegalArgumentException("NULL argument");
        }
        Configuration sub = this.config.subset(componentName);
        if (this.getMidpointHome() != null) {
            sub.addProperty(MIDPOINT_HOME, (Object)this.getMidpointHome());
        } else {
            i = sub.getKeys();
            while (i.hasNext()) {
                key = (String)i.next();
                sub.setProperty(key, (Object)sub.getString(key).replace("${midpoint.home}/", ""));
                sub.setProperty(key, (Object)sub.getString(key).replace("${midpoint.home}", ""));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Configuration for {} :", (Object)componentName);
            i = sub.getKeys();
            while (i.hasNext()) {
                key = (String)i.next();
                LOGGER.debug("    {} = {}", (Object)key, (Object)sub.getString(key));
            }
        }
        return sub;
    }

    public void init() {
        this.welcome();
        if (System.getProperty(MIDPOINT_HOME) == null || System.getProperty(MIDPOINT_HOME).isEmpty()) {
            LOGGER.warn("*****************************************************************************************");
            LOGGER.warn("midpoint.home is not set ! Using default configuration, for more information see http://wiki.evolveum.com/display/midPoint/");
            LOGGER.warn("*****************************************************************************************");
            System.out.println("*******************************************************************************");
            System.out.println("midpoint.home is not set ! Using default configuration, for more information");
            System.out.println("                 see http://wiki.evolveum.com/display/midPoint/");
            System.out.println("*******************************************************************************");
            String userHome = System.getProperty(USER_HOME);
            if (!userHome.endsWith("/")) {
                userHome = String.valueOf(userHome) + "/";
            }
            userHome = String.valueOf(userHome) + "midpoint";
            System.setProperty(MIDPOINT_HOME, userHome);
            LOGGER.warn("Setting {} to '{}'.", new Object[]{MIDPOINT_HOME, userHome});
            System.out.println("Setting midpoint.home to '" + userHome + "'.");
        }
        this.loadConfiguration();
    }

    public void load() {
        this.loadConfiguration();
    }

    public void save() {
        throw new NotImplementedException();
    }

    private void loadConfiguration() {
        if (this.config != null) {
            this.config.clear();
        } else {
            this.config = new CompositeConfiguration();
        }
        if (System.getProperty(MIDPOINT_HOME) != null) {
            try {
                if (!System.getProperty(MIDPOINT_HOME).endsWith("/")) {
                    System.setProperty(MIDPOINT_HOME, String.valueOf(System.getProperty(MIDPOINT_HOME)) + "/");
                }
                String path = String.valueOf(System.getProperty(MIDPOINT_HOME)) + this.getConfigFilename();
                LOGGER.info("Loading midPoint configuration from file {}", (Object)path);
                File f = new File(path);
                if (!f.exists()) {
                    LOGGER.warn("Configuration file {} does not exists. Need to do extraction ...", (Object)path);
                    ApplicationHomeSetup ah = new ApplicationHomeSetup();
                    ah.init(MIDPOINT_HOME);
                    ClassPathUtil.extractFileFromClassPath((String)this.getConfigFilename(), (String)path);
                }
                this.setConfigFilename(path);
                this.config.addProperty(MIDPOINT_HOME, (Object)System.getProperty(MIDPOINT_HOME));
                this.config.addConfiguration((Configuration)new XMLConfiguration(this.getConfigFilename()));
            }
            catch (ConfigurationException e) {
                LOGGER.error("Unable to read configuration file [" + this.getConfigFilename() + "]:" + e.getMessage());
                System.out.println("Unable to read configuration file [" + this.getConfigFilename() + "]:" + e.getMessage());
            }
        } else {
            try {
                this.config.addConfiguration((Configuration)new XMLConfiguration(this.getConfigFilename()));
            }
            catch (ConfigurationException e) {
                LOGGER.error("Unable to read configuration file [" + this.getConfigFilename() + "]:" + e.getMessage());
                System.out.println("Unable to read configuration file [" + this.getConfigFilename() + "]:" + e.getMessage());
            }
        }
    }

    public String toString() {
        Iterator i = this.config.getKeys();
        StringBuilder sb = new StringBuilder();
        while (i.hasNext()) {
            String key = (String)i.next();
            sb.append(key);
            sb.append(" = ");
            sb.append(this.config.getString(key));
            sb.append("; ");
        }
        return sb.toString();
    }

    private void welcome() {
        try {
            PropertiesConfiguration info = new PropertiesConfiguration("midpoint.info");
            new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");
            LOGGER.info("+--------------------------------------------------------------------------------------------+");
            LOGGER.info("|             _    | |  _  \\     _     _| |_");
            LOGGER.info("|   ___ ____ (_) __| | |_) |___ (_)___|_   _|");
            LOGGER.info("|  |  _ ` _ `| |/ _  |  __/  _ \\| |  _` | |");
            LOGGER.info("|  | | | | | | | (_| | |  | (_) | | | | | |_");
            LOGGER.info("|  |_| |_| |_|_|\\____|_|  \\____/|_|_| |_|\\__|  from Evolveum.com");
            LOGGER.info("|");
            LOGGER.info("|  Licensed under Open source licence CCDL v1.0 see: http://www.opensource.org/licenses/cddl1");
            LOGGER.info("|  Version :  " + info.getString("midpoint.version"));
            LOGGER.info("|  Sources :  " + info.getString("midpoint.scm") + "  branch:  " + info.getString("midpoint.branch"));
            LOGGER.info("|  Bug reporting system : " + info.getString("midpoint.jira"));
            LOGGER.info("|  Product informations : http://wiki.evolveum.com/display/midPoint");
            LOGGER.info("+---------------------------------------------------------------------------------------------+");
        }
        catch (ConfigurationException configurationException) {}
    }
}

