/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.init;

import com.evolveum.midpoint.common.configuration.api.MidpointConfiguration;
import com.evolveum.midpoint.common.configuration.api.RuntimeConfiguration;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.repo.api.RepositoryServiceFactory;
import com.evolveum.midpoint.repo.api.RepositoryServiceFactoryException;
import com.evolveum.midpoint.repo.cache.RepositoryCache;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.LoggingUtils;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import org.apache.commons.configuration.Configuration;
import org.apache.cxf.common.util.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class RepositoryFactory
implements ApplicationContextAware,
RuntimeConfiguration {
    private static final String REPOSITORY_CONFIGURATION = "midpoint.repository";
    private static final String REPOSITORY_FACTORY_CLASS = "repositoryServiceFactoryClass";
    private static final String REPOSITORY_FACTORY_CACHE_CLASS = "com.evolveum.midpoint.repo.cache.RepositoryCacheFactory";
    private static final Trace LOGGER = TraceManager.getTrace(RepositoryFactory.class);
    private ApplicationContext applicationContext;
    @Autowired
    MidpointConfiguration midpointConfiguration;
    private RepositoryServiceFactory factory;
    private RepositoryServiceFactory cacheFactory;
    private RepositoryService repositoryService;
    private RepositoryService cacheRepositoryService;

    public void init() {
        Configuration config = this.midpointConfiguration.getConfiguration(REPOSITORY_CONFIGURATION);
        try {
            String className = this.getFactoryClassName(config);
            Class<RepositoryServiceFactory> clazz = Class.forName(className);
            this.factory = this.getFactory(clazz);
            this.factory.init(config);
        }
        catch (Exception ex) {
            LoggingUtils.logException((Trace)LOGGER, (String)"RepositoryServiceFactory implementation class {} failed to initialize.", (Throwable)ex, (Object[])new Object[]{config.getString(REPOSITORY_FACTORY_CLASS)});
            throw new SystemException("RepositoryServiceFactory implementation class " + config.getString(REPOSITORY_FACTORY_CLASS) + " failed to initialize: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private String getFactoryClassName(Configuration config) {
        String className = config.getString(REPOSITORY_FACTORY_CLASS);
        if (StringUtils.isEmpty((String)className)) {
            LOGGER.error("RepositoryServiceFactory implementation class name ({}) not found in configuration. Provided configuration:\n{}", new Object[]{REPOSITORY_FACTORY_CLASS, config});
            throw new SystemException("RepositoryServiceFactory implementation class name (repositoryServiceFactoryClass) not found in configuration. Provided configuration:\n" + config);
        }
        return className;
    }

    private RepositoryServiceFactory getFactory(Class<RepositoryServiceFactory> clazz) throws RepositoryServiceFactoryException {
        LOGGER.info("Getting factory '{}'", new Object[]{clazz.getName()});
        return (RepositoryServiceFactory)this.applicationContext.getBean(clazz);
    }

    public void destroy() {
        try {
            if (this.factory != null) {
                this.factory.destroy();
            }
        }
        catch (RepositoryServiceFactoryException ex) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Failed to destroy RepositoryServiceFactory", (Throwable)ex, (Object[])new Object[0]);
            throw new SystemException("Failed to destroy RepositoryServiceFactory", (Throwable)ex);
        }
    }

    public String getComponentId() {
        return REPOSITORY_CONFIGURATION;
    }

    public Configuration getCurrentConfiguration() {
        return this.midpointConfiguration.getConfiguration(REPOSITORY_CONFIGURATION);
    }

    public synchronized RepositoryService getRepositoryService() {
        if (this.repositoryService == null) {
            try {
                this.repositoryService = this.factory.getRepositoryService();
            }
            catch (RepositoryServiceFactoryException ex) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Failed to get repository service from factory", (Throwable)ex, (Object[])new Object[0]);
                throw new SystemException("Failed to get repository service from factory", (Throwable)ex);
            }
        }
        return this.repositoryService;
    }

    public synchronized RepositoryService getCacheRepositoryService() {
        if (this.cacheRepositoryService == null) {
            try {
                Class<RepositoryServiceFactory> clazz = Class.forName(REPOSITORY_FACTORY_CACHE_CLASS);
                this.cacheFactory = this.getFactory(clazz);
                RepositoryCache repositoryCache = (RepositoryCache)this.cacheFactory.getRepositoryService();
                repositoryCache.setRepository(this.getRepositoryService());
                this.cacheRepositoryService = repositoryCache;
            }
            catch (Exception ex) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Failed to get cache repository service. ExceptionClass = {}", (Throwable)ex, (Object[])new Object[]{ex.getClass().getName()});
                throw new SystemException("Failed to get cache repository service", (Throwable)ex);
            }
        }
        return this.cacheRepositoryService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

