/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.ucf.impl;

import com.evolveum.midpoint.provisioning.ucf.api.GenericFrameworkException;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.exception.CommunicationException;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.io.FileNotFoundException;
import java.net.ConnectException;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.Set;
import javax.naming.NameAlreadyBoundException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.SchemaViolationException;
import org.identityconnectors.framework.common.exceptions.AlreadyExistsException;
import org.identityconnectors.framework.common.exceptions.ConfigurationException;
import org.identityconnectors.framework.common.exceptions.ConnectionBrokenException;
import org.identityconnectors.framework.common.exceptions.ConnectionFailedException;
import org.identityconnectors.framework.common.exceptions.ConnectorIOException;
import org.identityconnectors.framework.common.exceptions.ConnectorSecurityException;
import org.identityconnectors.framework.common.exceptions.InvalidCredentialException;
import org.identityconnectors.framework.common.exceptions.OperationTimeoutException;
import org.identityconnectors.framework.common.exceptions.UnknownUidException;
import org.identityconnectors.framework.common.objects.Attribute;

class IcfUtil {
    private static final Trace LOGGER = TraceManager.getTrace(IcfUtil.class);

    IcfUtil() {
    }

    static Exception processIcfException(Exception ex, OperationResult parentResult) {
        if (ex == null) {
            throw new IllegalArgumentException("Null exception while processing ICF exception ");
        }
        LOGGER.error("ICF Exception {}: {}", new Object[]{ex.getClass().getName(), ex.getMessage(), ex});
        if (ex instanceof NullPointerException && ex.getMessage() != null) {
            SchemaException newEx = new SchemaException(IcfUtil.createMessageFromAllExceptions("Required attribute is missing", ex));
            parentResult.recordFatalError("Required attribute is missing: " + ex.getMessage(), (Throwable)newEx);
            return newEx;
        }
        if (ex instanceof IllegalArgumentException) {
            com.evolveum.midpoint.util.exception.ConfigurationException newEx = new com.evolveum.midpoint.util.exception.ConfigurationException(IcfUtil.createMessageFromInnermostException("Configuration error", ex));
            parentResult.recordFatalError("Configuration error: " + ex.getMessage(), (Throwable)newEx);
            return newEx;
        }
        if (ex.getClass().getPackage().equals(NullPointerException.class.getPackage())) {
            return ex;
        }
        if (ex.getClass().getPackage().equals(SchemaException.class.getPackage())) {
            return ex;
        }
        if (parentResult == null) {
            throw new IllegalArgumentException(IcfUtil.createMessageFromAllExceptions("Null parent result while processing ICF exception", ex));
        }
        Exception knownCause = IcfUtil.lookForKnownCause(ex, ex, parentResult);
        if (knownCause != null) {
            return knownCause;
        }
        if (ex instanceof IllegalArgumentException) {
            SchemaException newEx = new SchemaException(IcfUtil.createMessageFromAllExceptions("Schema violation (most likely)", ex));
            parentResult.recordFatalError("Schema violation: " + ex.getMessage(), (Throwable)newEx);
            return newEx;
        }
        if (ex instanceof ConfigurationException) {
            com.evolveum.midpoint.util.exception.ConfigurationException newEx = new com.evolveum.midpoint.util.exception.ConfigurationException(IcfUtil.createMessageFromInnermostException("Configuration error", ex));
            parentResult.recordFatalError("Configuration error: " + ex.getMessage(), (Throwable)newEx);
            return newEx;
        }
        if (ex instanceof AlreadyExistsException) {
            ObjectAlreadyExistsException newEx = new ObjectAlreadyExistsException(IcfUtil.createMessageFromAllExceptions(null, ex));
            parentResult.recordFatalError("Object already exists: " + ex.getMessage(), (Throwable)newEx);
            return newEx;
        }
        if (ex instanceof ConnectionBrokenException) {
            CommunicationException newEx = new CommunicationException(IcfUtil.createMessageFromAllExceptions("Connection broken", ex));
            parentResult.recordFatalError("Connection broken: " + ex.getMessage(), (Throwable)newEx);
            return newEx;
        }
        if (ex instanceof ConnectionFailedException) {
            CommunicationException newEx = new CommunicationException(IcfUtil.createMessageFromAllExceptions("Connection failed", ex));
            parentResult.recordFatalError("Connection failed: " + ex.getMessage(), (Throwable)newEx);
            return newEx;
        }
        if (ex instanceof ConnectorIOException) {
            CommunicationException newEx = new CommunicationException(IcfUtil.createMessageFromAllExceptions("IO error", ex));
            parentResult.recordFatalError("IO error: " + ex.getMessage(), (Throwable)newEx);
            return newEx;
        }
        if (ex instanceof InvalidCredentialException) {
            GenericFrameworkException newEx = new GenericFrameworkException(IcfUtil.createMessageFromAllExceptions("Invalid credentials", ex));
            parentResult.recordFatalError("Invalid credentials: " + ex.getMessage(), (Throwable)newEx);
            return newEx;
        }
        if (ex instanceof OperationTimeoutException) {
            CommunicationException newEx = new CommunicationException(IcfUtil.createMessageFromAllExceptions("Operation timed out", ex));
            parentResult.recordFatalError("Operation timed out: " + ex.getMessage(), (Throwable)newEx);
            return newEx;
        }
        if (ex instanceof UnknownUidException) {
            ObjectNotFoundException newEx = new ObjectNotFoundException(IcfUtil.createMessageFromAllExceptions(null, ex));
            parentResult.recordFatalError("Unknown UID: " + ex.getMessage(), (Throwable)newEx);
            return newEx;
        }
        if (ex instanceof ConnectorSecurityException) {
            SystemException newEx = new SystemException(IcfUtil.createMessageFromAllExceptions("Security violation", ex));
            parentResult.recordFatalError("Security violation: " + ex.getMessage(), (Throwable)newEx);
            return newEx;
        }
        GenericFrameworkException newEx = new GenericFrameworkException(IcfUtil.createMessageFromAllExceptions(null, ex));
        parentResult.recordFatalError((Throwable)newEx);
        return newEx;
    }

    private static Exception lookForKnownCause(Throwable ex, Throwable originalException, OperationResult parentResult) {
        if (ex instanceof FileNotFoundException) {
            GenericFrameworkException newEx = new GenericFrameworkException(IcfUtil.createMessageFromAllExceptions(null, ex));
            parentResult.recordFatalError("File not found: " + ex.getMessage(), (Throwable)newEx);
            return newEx;
        }
        if (ex instanceof NameAlreadyBoundException) {
            ObjectAlreadyExistsException newEx = new ObjectAlreadyExistsException(IcfUtil.createMessageFromAllExceptions(null, ex));
            parentResult.recordFatalError("Object already exists: " + ex.getMessage(), (Throwable)newEx);
            return newEx;
        }
        if (ex instanceof javax.naming.CommunicationException) {
            CommunicationException newEx = new CommunicationException(IcfUtil.createMessageFromAllExceptions("Communication error", ex));
            parentResult.recordFatalError("Communication error: " + ex.getMessage(), (Throwable)newEx);
            return newEx;
        }
        if (ex instanceof SchemaViolationException) {
            SchemaException newEx = new SchemaException(IcfUtil.createMessageFromAllExceptions("Schema violation", ex));
            parentResult.recordFatalError("Schema violation: " + ex.getMessage(), (Throwable)newEx);
            return newEx;
        }
        if (ex instanceof InvalidAttributeValueException) {
            SchemaException newEx = new SchemaException(IcfUtil.createMessageFromAllExceptions("Invalid attribute", ex));
            parentResult.recordFatalError("Invalid attribute: " + ex.getMessage(), (Throwable)newEx);
            return newEx;
        }
        if (ex instanceof ConnectException) {
            CommunicationException newEx = new CommunicationException(IcfUtil.createMessageFromAllExceptions("Connect error", ex));
            parentResult.recordFatalError("Connect error: " + ex.getMessage(), (Throwable)newEx);
            return newEx;
        }
        if (ex instanceof SQLSyntaxErrorException) {
            SchemaException newEx = new SchemaException(IcfUtil.createMessageFromAllExceptions("DB syntax error", ex));
            parentResult.recordFatalError("DB syntax error: " + ex.getMessage(), (Throwable)newEx);
            return newEx;
        }
        if (ex instanceof SQLException) {
            GenericFrameworkException newEx = new GenericFrameworkException(IcfUtil.createMessageFromAllExceptions("DB error", ex));
            parentResult.recordFatalError("DB error: " + ex.getMessage(), (Throwable)newEx);
            return newEx;
        }
        if (ex instanceof UnknownUidException) {
            ObjectNotFoundException newEx = new ObjectNotFoundException(IcfUtil.createMessageFromAllExceptions(null, ex));
            parentResult.recordFatalError("Object not found: " + ex.getMessage(), (Throwable)newEx);
            return newEx;
        }
        if (ex.getCause() == null) {
            return null;
        }
        return IcfUtil.lookForKnownCause(ex.getCause(), originalException, parentResult);
    }

    public static String dump(Set<Attribute> attributes) {
        StringBuilder sb = new StringBuilder();
        for (Attribute attr : attributes) {
            sb.append(attr.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String createMessageFromAllExceptions(String prefix, Throwable ex) {
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
            sb.append(": ");
        }
        IcfUtil.addAllExceptionsToMessage(sb, ex);
        return sb.toString();
    }

    private static void addAllExceptionsToMessage(StringBuilder sb, Throwable ex) {
        sb.append(ex.getClass().getName());
        sb.append("(");
        sb.append(ex.getMessage());
        sb.append(")");
        if (ex.getCause() != null) {
            sb.append("->");
            IcfUtil.addAllExceptionsToMessage(sb, ex.getCause());
        }
    }

    private static String createMessageFromInnermostException(String prefix, Throwable ex) {
        StringBuilder sb = new StringBuilder();
        if (prefix != null) {
            sb.append(prefix);
            sb.append(": ");
        }
        IcfUtil.addInnermostExceptionsToMessage(sb, ex);
        return sb.toString();
    }

    private static void addInnermostExceptionsToMessage(StringBuilder sb, Throwable ex) {
        if (ex.getCause() != null) {
            IcfUtil.addInnermostExceptionsToMessage(sb, ex.getCause());
        } else {
            sb.append(ex.getMessage());
        }
    }
}

