/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.ucf.api;

import com.evolveum.midpoint.provisioning.ucf.api.ExecuteScriptArgument;
import com.evolveum.midpoint.provisioning.ucf.api.Operation;
import com.evolveum.midpoint.schema.util.SchemaDebugUtil;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ScriptOrderType;
import java.util.ArrayList;
import java.util.List;

public class ExecuteScriptOperation
extends Operation {
    private static final int DEBUG_MAX_CODE_LENGTH = 32;
    private List<ExecuteScriptArgument> argument;
    private boolean connectorHost;
    private boolean resourceHost;
    private String textCode;
    private String language;
    private ScriptOrderType scriptOrder;

    public List<ExecuteScriptArgument> getArgument() {
        if (this.argument == null) {
            this.argument = new ArrayList<ExecuteScriptArgument>();
        }
        return this.argument;
    }

    public boolean isConnectorHost() {
        return this.connectorHost;
    }

    public void setConnectorHost(boolean connectorHost) {
        this.connectorHost = connectorHost;
    }

    public boolean isResourceHost() {
        return this.resourceHost;
    }

    public void setResourceHost(boolean resourceHost) {
        this.resourceHost = resourceHost;
    }

    public String getTextCode() {
        return this.textCode;
    }

    public void setTextCode(String textCode) {
        this.textCode = textCode;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public ScriptOrderType getScriptOrder() {
        return this.scriptOrder;
    }

    public void setScriptOrder(ScriptOrderType scriptOrder) {
        this.scriptOrder = scriptOrder;
    }

    public String debugDump(int indent) {
        StringBuilder sb = new StringBuilder();
        SchemaDebugUtil.indentDebugDump((StringBuilder)sb, (int)indent);
        sb.append("Script execution ");
        if (this.connectorHost) {
            sb.append("on connector ");
        }
        if (this.resourceHost) {
            sb.append("on resource ");
        }
        sb.append(this.scriptOrder);
        sb.append(" : ");
        if (this.textCode.length() <= 32) {
            sb.append(this.textCode);
        } else {
            sb.append(this.textCode.substring(0, 32));
            sb.append(" ...(truncated)...");
        }
        return sb.toString();
    }
}

