/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.impl;

import com.evolveum.midpoint.common.QueryUtil;
import com.evolveum.midpoint.common.refinery.RefinedResourceSchema;
import com.evolveum.midpoint.prism.ComplexTypeDefinition;
import com.evolveum.midpoint.prism.Definition;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.delta.ContainerDelta;
import com.evolveum.midpoint.prism.schema.PrismSchema;
import com.evolveum.midpoint.provisioning.api.GenericConnectorException;
import com.evolveum.midpoint.provisioning.impl.ConnectorTypeManager;
import com.evolveum.midpoint.provisioning.impl.DiscoveryHandler;
import com.evolveum.midpoint.provisioning.impl.ResourceSchemaCache;
import com.evolveum.midpoint.provisioning.impl.ShadowConverter;
import com.evolveum.midpoint.provisioning.impl.ShadowHandler;
import com.evolveum.midpoint.provisioning.ucf.api.ConnectorInstance;
import com.evolveum.midpoint.provisioning.ucf.api.GenericFrameworkException;
import com.evolveum.midpoint.provisioning.ucf.api.ResultHandler;
import com.evolveum.midpoint.provisioning.util.ShadowCacheUtil;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.constants.ConnectorTestOperation;
import com.evolveum.midpoint.schema.processor.ObjectClassComplexTypeDefinition;
import com.evolveum.midpoint.schema.processor.ResourceAttribute;
import com.evolveum.midpoint.schema.processor.ResourceAttributeContainerDefinition;
import com.evolveum.midpoint.schema.processor.ResourceAttributeDefinition;
import com.evolveum.midpoint.schema.processor.ResourceSchema;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ConnectorTypeUtil;
import com.evolveum.midpoint.schema.util.MiscSchemaUtil;
import com.evolveum.midpoint.schema.util.ObjectTypeUtil;
import com.evolveum.midpoint.schema.util.ResourceObjectShadowUtil;
import com.evolveum.midpoint.schema.util.ResourceTypeUtil;
import com.evolveum.midpoint.schema.util.SchemaDebugUtil;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.exception.CommunicationException;
import com.evolveum.midpoint.util.exception.ConfigurationException;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.CachedCapabilitiesType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.CachingMetadataType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.CapabilitiesType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ConnectorType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.XmlSchemaType;
import com.evolveum.midpoint.xml.ns._public.resource.capabilities_2.ActivationCapabilityType;
import com.evolveum.prism.xml.ns._public.query_2.QueryType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Component
public class ResourceTypeManager {
    @Autowired(required=true)
    @Qualifier(value="cacheRepositoryService")
    private RepositoryService repositoryService = null;
    @Autowired(required=true)
    private ResourceSchemaCache resourceSchemaCache;
    @Autowired(required=true)
    private ConnectorTypeManager connectorTypeManager;
    @Autowired(required=true)
    private ShadowConverter shadowConverter;
    @Autowired(required=true)
    private PrismContext prismContext;
    private PrismObjectDefinition<ResourceType> resourceTypeDefinition = null;
    private static final Trace LOGGER = TraceManager.getTrace(ResourceTypeManager.class);

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public ResourceType completeResource(ResourceType resource, ResourceSchema resourceSchema, OperationResult parentResult) throws ObjectNotFoundException, SchemaException, CommunicationException, ConfigurationException {
        this.applyConnectorSchemaToResource(resource, parentResult);
        XmlSchemaType xmlSchemaType = resource.getSchema();
        if (xmlSchemaType == null) {
            xmlSchemaType = new XmlSchemaType();
            resource.setSchema(xmlSchemaType);
        }
        Element xsdElement = ResourceTypeUtil.getResourceXsdSchema((ResourceType)resource);
        ResourceType newResource = null;
        ConnectorInstance connector = null;
        if (xsdElement == null) {
            if (resourceSchema == null) {
                LOGGER.trace("Fetching resource schema for " + ObjectTypeUtil.toShortString((ObjectType)resource));
                try {
                    connector = this.getConnectorInstance(resource, parentResult);
                }
                catch (ObjectNotFoundException e) {
                    throw new ObjectNotFoundException("Error resolving connector reference in " + resource + ": Error creating connector instace: " + e.getMessage(), (Throwable)e);
                }
                try {
                    resourceSchema = connector.getResourceSchema(parentResult);
                }
                catch (CommunicationException ex) {
                    LOGGER.error("Unable to complete {}: {}", new Object[]{resource, ex.getMessage(), ex});
                }
                catch (GenericFrameworkException ex) {
                    LOGGER.error("Unable to complete {}: {}", new Object[]{resource, ex.getMessage(), ex});
                }
                catch (ConfigurationException ex) {
                    LOGGER.error("Unable to complete {}: {}", new Object[]{resource, ex.getMessage(), ex});
                }
                if (resourceSchema == null) {
                    LOGGER.warn("No resource schema generated for {}", (Object)resource);
                } else {
                    LOGGER.debug("Generated resource schema for " + ObjectTypeUtil.toShortString((ObjectType)resource) + ": " + resourceSchema.getDefinitions().size() + " definitions");
                }
            }
            if (resourceSchema == null) {
                return resource;
            }
            this.adjustSchemaForCapabilities(resource, resourceSchema);
            Document xsdDoc = null;
            try {
                LOGGER.trace("Serializing XSD resource schema for {} to DOM", (Object)ObjectTypeUtil.toShortString((ObjectType)resource));
                xsdDoc = resourceSchema.serializeToXsd();
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Serialized XSD resource schema for {}:\n{}", (Object)ObjectTypeUtil.toShortString((ObjectType)resource), (Object)DOMUtil.serializeDOMToString((Node)xsdDoc));
                }
            }
            catch (SchemaException e) {
                throw new SchemaException("Error processing resource schema for " + ObjectTypeUtil.toShortString((ObjectType)resource) + ": " + e.getMessage(), (Throwable)e);
            }
            xsdElement = DOMUtil.getFirstChildElement((Node)xsdDoc);
            if (xsdElement == null) {
                throw new SchemaException("No schema was generated for " + resource);
            }
            CachingMetadataType cachingMetadata = MiscSchemaUtil.generateCachingMetadata();
            LOGGER.info("Storing generated schema in resource " + ObjectTypeUtil.toShortString((ObjectType)resource));
            ContainerDelta schemaContainerDelta = ContainerDelta.createDelta((PrismContext)this.prismContext, ResourceType.class, (QName)ResourceType.F_SCHEMA);
            PrismContainerValue cval = new PrismContainerValue();
            schemaContainerDelta.setValueToReplace((PrismValue)cval);
            PrismProperty cachingMetadataProperty = cval.createProperty(XmlSchemaType.F_CACHING_METADATA);
            cachingMetadataProperty.setRealValue((Object)cachingMetadata);
            PrismProperty definitionProperty = cval.createProperty(XmlSchemaType.F_DEFINITION);
            ObjectTypeUtil.setXsdSchemaDefinition((PrismProperty)definitionProperty, (Element)xsdElement);
            ArrayList<ContainerDelta> modifications = new ArrayList<ContainerDelta>(1);
            modifications.add(schemaContainerDelta);
            try {
                this.repositoryService.modifyObject(ResourceType.class, resource.getOid(), modifications, parentResult);
            }
            catch (ObjectAlreadyExistsException ex) {
                throw new SystemException((Throwable)ex);
            }
            ResourceTypeUtil.setResourceXsdSchema((ResourceType)resource, (Element)xsdElement);
            resource.getSchema().setCachingMetadata(cachingMetadata);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Putting resource in cache:\n{}", (Object)resource.asPrismObject().dump());
                LOGGER.trace("Schema:\n{}", (Object)DOMUtil.serializeDOMToString((Node)ResourceTypeUtil.getResourceXsdSchema((ResourceType)resource)));
            }
            newResource = this.resourceSchemaCache.put(resource);
        }
        if (newResource == null) {
            newResource = this.resourceSchemaCache.get(resource);
        }
        try {
            this.addNativeCapabilities(newResource, connector, parentResult);
        }
        catch (CommunicationException communicationException) {
            parentResult.recordWarning("Cannot add native capabilities to resource object because the resource is unreachable. Resource object returned without native capabilities.");
            newResource.setFetchResult(parentResult.createOperationResultType());
        }
        parentResult.recordSuccess();
        return newResource;
    }

    private void applyConnectorSchemaToResource(ResourceType resource, OperationResult result) throws SchemaException, ObjectNotFoundException {
        ConnectorType connectorType = this.connectorTypeManager.getConnectorType(resource, result);
        PrismContainerDefinition configurationContainerDefintion = ConnectorTypeUtil.findConfigurationContainerDefintion((ConnectorType)connectorType, (PrismContext)this.prismContext);
        if (configurationContainerDefintion == null) {
            throw new SchemaException("No configuration container definition in " + connectorType);
        }
        PrismContainer configurationContainer = ResourceTypeUtil.getConfigurationContainer((ResourceType)resource);
        if (configurationContainer == null) {
            throw new SchemaException("No configuration container in " + resource);
        }
        configurationContainer.applyDefinition((ItemDefinition)configurationContainerDefintion, true);
    }

    public void testConnection(ResourceType resourceType, OperationResult parentResult) {
        ConnectorInstance connector;
        OperationResult initResult = parentResult.createSubresult(ConnectorTestOperation.CONNECTOR_INITIALIZATION.getOperation());
        try {
            connector = this.getConnectorInstance(resourceType, initResult);
            initResult.recordSuccess();
        }
        catch (ObjectNotFoundException e) {
            initResult.recordFatalError("The connector was not found", (Throwable)e);
            return;
        }
        catch (SchemaException e) {
            initResult.recordFatalError("Schema error while dealing with the connector definition", (Throwable)e);
            return;
        }
        catch (RuntimeException e) {
            initResult.recordFatalError("Unexpected runtime error", (Throwable)e);
            return;
        }
        catch (CommunicationException e) {
            initResult.recordFatalError("Communication error", (Throwable)e);
            return;
        }
        catch (ConfigurationException e) {
            initResult.recordFatalError("Configuration error", (Throwable)e);
            return;
        }
        LOGGER.debug("Testing connection to the resource with oid {}", (Object)resourceType.getOid());
        OperationResult configResult = parentResult.createSubresult(ConnectorTestOperation.CONFIGURATION_VALIDATION.getOperation());
        try {
            connector.configure(resourceType.asPrismObject().findContainer(ResourceType.F_CONFIGURATION).getValue(), configResult);
            configResult.recordSuccess();
        }
        catch (CommunicationException e) {
            configResult.recordFatalError("Communication error", (Throwable)e);
            return;
        }
        catch (GenericFrameworkException e) {
            configResult.recordFatalError("Generic error", (Throwable)e);
            return;
        }
        catch (SchemaException e) {
            configResult.recordFatalError("Schema error", (Throwable)e);
            return;
        }
        catch (ConfigurationException e) {
            configResult.recordFatalError("Configuration error", (Throwable)e);
            return;
        }
        catch (RuntimeException e) {
            configResult.recordFatalError("Unexpected runtime error", (Throwable)e);
            return;
        }
        connector.test(parentResult);
        parentResult.computeStatus();
        if (!parentResult.isAcceptable()) {
            return;
        }
        OperationResult schemaResult = parentResult.createSubresult(ConnectorTestOperation.CONNECTOR_SCHEMA.getOperation());
        ResourceSchema schema = null;
        try {
            schema = connector.getResourceSchema(schemaResult);
        }
        catch (CommunicationException e) {
            schemaResult.recordFatalError("Communication error: " + e.getMessage(), (Throwable)e);
            return;
        }
        catch (GenericFrameworkException e) {
            schemaResult.recordFatalError("Generic error: " + e.getMessage(), (Throwable)e);
            return;
        }
        catch (ConfigurationException e) {
            schemaResult.recordFatalError("Configuration error: " + e.getMessage(), (Throwable)e);
            return;
        }
        if (schema == null || schema.isEmpty()) {
            schemaResult.recordFatalError("Empty schema returned");
            return;
        }
        try {
            this.completeResource(resourceType, schema, schemaResult);
        }
        catch (ObjectNotFoundException e) {
            schemaResult.recordFatalError("Object not found (unexpected error, probably a bug): " + e.getMessage(), (Throwable)e);
            return;
        }
        catch (SchemaException e) {
            schemaResult.recordFatalError("Schema processing error (probably connector bug): " + e.getMessage(), (Throwable)e);
            return;
        }
        catch (CommunicationException e) {
            schemaResult.recordFatalError("Communication error: " + e.getMessage(), (Throwable)e);
            return;
        }
        catch (ConfigurationException e) {
            schemaResult.recordFatalError("Configuration error: " + e.getMessage(), (Throwable)e);
            return;
        }
        schemaResult.recordSuccess();
    }

    private void adjustSchemaForCapabilities(ResourceType resource, ResourceSchema resourceSchema) {
        QName attributeName;
        if (resource.getCapabilities() == null) {
            return;
        }
        ActivationCapabilityType activationCapability = (ActivationCapabilityType)ResourceTypeUtil.getCapability((Collection)resource.getCapabilities().getAny(), ActivationCapabilityType.class);
        if (activationCapability != null && activationCapability.getEnableDisable() != null && (attributeName = activationCapability.getEnableDisable().getAttribute()) != null) {
            for (ObjectClassComplexTypeDefinition objectClassDefinition : resourceSchema.getDefinitions(ObjectClassComplexTypeDefinition.class)) {
                ResourceAttributeDefinition attributeDefinition = objectClassDefinition.findAttributeDefinition(attributeName);
                if (attributeDefinition != null) {
                    attributeDefinition.setIgnored(true);
                    continue;
                }
                LOGGER.debug("Simulated activation attribute " + attributeName + " for objectclass " + objectClassDefinition.getTypeName() + " in " + ObjectTypeUtil.toShortString((ObjectType)resource) + " does not exist in the resource schema. This may work well, but it is not clean. Connector exposing such schema should be fixed.");
            }
        }
    }

    public ResourceSchema getResourceSchema(ResourceType resource, ConnectorInstance connector, OperationResult parentResult) throws SchemaException, CommunicationException, ConfigurationException {
        ResourceSchema schema = null;
        try {
            ResourceType completeResource = this.completeResource(resource, null, parentResult);
            schema = RefinedResourceSchema.getResourceSchema((ResourceType)completeResource, (PrismContext)this.prismContext);
        }
        catch (SchemaException e) {
            parentResult.recordFatalError("Unable to parse resource schema: " + e.getMessage(), (Throwable)e);
            throw new SchemaException("Unable to parse resource schema: " + e.getMessage(), (Throwable)e);
        }
        catch (ObjectNotFoundException e) {
            parentResult.recordFatalError("Unexpected ObjectNotFoundException: " + e.getMessage(), (Throwable)e);
            throw new SystemException("Unexpected ObjectNotFoundException: " + e.getMessage(), (Throwable)e);
        }
        catch (ConfigurationException e) {
            parentResult.recordFatalError("Unable to parse resource schema: " + e.getMessage(), (Throwable)e);
            throw new ConfigurationException("Unable to parse resource schema: " + e.getMessage(), (Throwable)e);
        }
        this.checkSchema((PrismSchema)schema);
        return schema;
    }

    public void listShadows(ResourceType resource, QName objectClass, ShadowHandler handler, boolean readFromRepository, OperationResult parentResult) throws CommunicationException, ObjectNotFoundException, SchemaException, ConfigurationException {
        Validate.notNull((Object)objectClass);
        if (resource == null) {
            parentResult.recordFatalError("Resource must not be null");
            throw new IllegalArgumentException("Resource must not be null.");
        }
        this.searchObjects(ResourceObjectShadowType.class, objectClass, resource, null, handler, null, readFromRepository, parentResult);
    }

    public <T extends ResourceObjectShadowType> void searchObjectsIterative(Class<T> type, QName objectClass, ResourceType resourceType, List<ResourceAttribute> resourceAttributesFilter, ShadowHandler handler, DiscoveryHandler discoveryHandler, OperationResult parentResult) throws ObjectNotFoundException, CommunicationException, SchemaException, ConfigurationException {
        Validate.notNull((Object)resourceType, (String)"Resource must not be null.");
        Validate.notNull((Object)objectClass, (String)"Object class must not be null.");
        Validate.notNull((Object)parentResult, (String)"Operation result must not be null.");
        LOGGER.trace("Searching objects iterative with obejct class {}, resource: {}.", (Object)objectClass, (Object)ObjectTypeUtil.toShortString((ObjectType)resourceType));
        this.searchObjects(type, objectClass, resourceType, resourceAttributesFilter, handler, discoveryHandler, true, parentResult);
    }

    private <T extends ResourceObjectShadowType> void searchObjects(final Class<T> type, QName objectClass, final ResourceType resourceType, List<ResourceAttribute> resourceAttributesFilter, final ShadowHandler handler, final DiscoveryHandler discoveryHandler, final boolean readFromRepository, final OperationResult parentResult) throws SchemaException, ObjectNotFoundException, CommunicationException, ConfigurationException {
        ConnectorInstance connector = this.getConnectorInstance(resourceType, parentResult);
        ResourceSchema schema = this.getResourceSchema(resourceType, connector, parentResult);
        if (schema == null) {
            parentResult.recordFatalError("Can't get resource schema.");
            throw new IllegalArgumentException("Can't get resource schema.");
        }
        ObjectClassComplexTypeDefinition objectClassDef = schema.findObjectClassDefinition(objectClass);
        if (objectClassDef == null) {
            String message = "Object class " + objectClass + " is not defined in schema of " + ObjectTypeUtil.toShortString((ObjectType)resourceType);
            LOGGER.error(message);
            parentResult.recordFatalError(message);
            throw new SchemaException(message);
        }
        ResultHandler resultHandler = new ResultHandler<T>(){

            @Override
            public boolean handle(PrismObject<T> resourceShadow) {
                ResourceObjectShadowType resultShadowType;
                block9: {
                    block8: {
                        LOGGER.trace("Found resource object {}", (Object)SchemaDebugUtil.prettyPrint(resourceShadow));
                        try {
                            if (!ResourceTypeManager.this.shadowConverter.isProtectedShadow(resourceType, resourceShadow)) break block8;
                            LOGGER.trace("Skipping protected shadow " + resourceShadow + " in search");
                            return true;
                        }
                        catch (SchemaException e) {
                            parentResult.recordFatalError("Schema error: " + e.getMessage(), (Throwable)e);
                            LOGGER.error("Schema error: {}", (Object)e.getMessage(), (Object)e);
                            return false;
                        }
                    }
                    ResourceObjectShadowType resourceShadowType = (ResourceObjectShadowType)resourceShadow.asObjectable();
                    if (readFromRepository) {
                        resultShadowType = ResourceTypeManager.this.lookupShadowInRepository(type, resourceShadowType, resourceType, parentResult);
                        if (resultShadowType == null) {
                            LOGGER.trace("Shadow object (in repo) corresponding to the resource object (on the resource) was not found. The repo shadow will be created. The resource object:\n{}", (Object)SchemaDebugUtil.prettyPrint(resourceShadow));
                            try {
                                ResourceObjectShadowType repoShadow = ShadowCacheUtil.createRepositoryShadow(resourceShadowType, resourceType);
                                String oid = ResourceTypeManager.this.getRepositoryService().addObject(repoShadow.asPrismObject(), parentResult);
                                resultShadowType = ShadowCacheUtil.completeShadow(resourceShadowType, null, resourceType, parentResult);
                                resultShadowType.setOid(oid);
                            }
                            catch (ObjectAlreadyExistsException e) {
                                LOGGER.error("Unexpected repository behavior: Object already exists: {}", (Object)e.getMessage(), (Object)e);
                                throw new SystemException("Unexpected repository behavior: Object already exists: " + e.getMessage(), (Throwable)e);
                            }
                            if (discoveryHandler != null) {
                                discoveryHandler.discovered(resultShadowType, parentResult);
                            }
                            break block9;
                        }
                        LOGGER.trace("Found shadow object in the repository {}", (Object)SchemaDebugUtil.prettyPrint((ObjectType)resultShadowType));
                        break block9;
                    }
                    resultShadowType = ShadowCacheUtil.completeShadow(resourceShadowType, null, resourceType, parentResult);
                }
                return handler.handle(resultShadowType);
            }
        };
        try {
            QueryType query = null;
            if (resourceAttributesFilter != null) {
                if (resourceAttributesFilter.size() > 1) {
                    throw new UnsupportedOperationException("Now it is only supported to search accounts according to only one shadow attribute.");
                }
                if (!resourceAttributesFilter.isEmpty()) {
                    Element filter = QueryUtil.createEqualFilter((Document)DOMUtil.getDocument(), null, (QName)resourceAttributesFilter.get(0).getName(), (String)((String)resourceAttributesFilter.get(0).getRealValue()));
                    query = QueryUtil.createQuery((Element)filter);
                }
            }
            connector.search(type, objectClassDef, query, resultHandler, parentResult);
        }
        catch (GenericFrameworkException e) {
            parentResult.recordFatalError("Generic error in the connector: " + e.getMessage(), (Throwable)e);
            throw new CommunicationException("Generic error in the connector: " + e.getMessage(), (Throwable)e);
        }
        catch (CommunicationException ex) {
            parentResult.recordFatalError("Error communicating with the connector " + connector + ": " + ex.getMessage(), (Throwable)ex);
            throw new CommunicationException("Error communicating with the connector " + connector + ": " + ex.getMessage(), (Throwable)ex);
        }
        parentResult.recordSuccess();
    }

    private <T extends ResourceObjectShadowType> T lookupShadowInRepository(Class<T> type, T resourceShadow, ResourceType resource, OperationResult parentResult) throws SchemaException {
        QueryType query = ShadowCacheUtil.createSearchShadowQuery(resourceShadow, resource, this.prismContext, parentResult);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Searching for shadow using filter:\n{}", (Object)DOMUtil.serializeDOMToString((Node)query.getFilter()));
        }
        PagingType paging = new PagingType();
        List results = this.getRepositoryService().searchObjects(type, query, paging, parentResult);
        LOGGER.trace("lookupShadow found {} objects", (Object)results.size());
        if (results.size() == 0) {
            return null;
        }
        if (results.size() > 1) {
            for (PrismObject result : results) {
                LOGGER.trace("Search result:\n{}", (Object)result.dump());
            }
            LOGGER.error("More than one shadows found for " + resourceShadow);
            throw new IllegalStateException("More than one shadows found for " + resourceShadow);
        }
        ResourceObjectShadowType repoShadow = (ResourceObjectShadowType)((PrismObject)results.get(0)).asObjectable();
        if (repoShadow != null) {
            ResourceSchema resourceSchema = null;
            try {
                resourceSchema = this.getResourceSchema(resource, null, parentResult);
            }
            catch (CommunicationException ex) {
                parentResult.recordFatalError("Error communicating with the connector " + ex.getMessage(), (Throwable)ex);
            }
            catch (ConfigurationException ex) {
                parentResult.recordFatalError("Error in the configuration: " + ex.getMessage(), (Throwable)ex);
            }
            ResourceObjectShadowUtil.fixShadow((PrismObject)repoShadow.asPrismObject(), (ResourceSchema)resourceSchema);
        }
        return (T)ShadowCacheUtil.completeShadow(resourceShadow, repoShadow, resource, parentResult);
    }

    private void checkSchema(PrismSchema schema) throws SchemaException {
        for (Definition def : schema.getDefinitions()) {
            if (def instanceof ComplexTypeDefinition) continue;
            if (def instanceof ResourceAttributeContainerDefinition) {
                this.checkResourceObjectDefinition((ResourceAttributeContainerDefinition)def);
                continue;
            }
            throw new SchemaException("Unexpected definition in resource schema: " + def);
        }
    }

    private void checkResourceObjectDefinition(ResourceAttributeContainerDefinition rod) throws SchemaException {
        for (ItemDefinition def : rod.getDefinitions()) {
            if (def instanceof ResourceAttributeDefinition) continue;
            throw new SchemaException("Unexpected definition in resource schema object " + rod + ": " + def);
        }
    }

    private void addNativeCapabilities(ResourceType resource, ConnectorInstance connector, OperationResult result) throws CommunicationException, ObjectNotFoundException, SchemaException {
        if (resource.getNativeCapabilities() != null) {
            return;
        }
        Collection<Object> capabilities = null;
        try {
            if (connector == null) {
                connector = this.getConnectorInstance(resource, result);
            }
            capabilities = connector.getCapabilities(result);
        }
        catch (CommunicationException ex) {
            throw new CommunicationException("Cannot fetch resource native capabilities: " + ex.getMessage(), (Throwable)ex);
        }
        catch (GenericFrameworkException ex) {
            throw new GenericConnectorException("Generic error in connector " + connector + ": " + ex.getMessage(), (Throwable)ex);
        }
        catch (ConfigurationException ex) {
            throw new GenericConnectorException("Configuration error in connector " + connector + ": " + ex.getMessage(), (Throwable)ex);
        }
        CapabilitiesType capType = new CapabilitiesType();
        capType.getAny().addAll(capabilities);
        CachedCapabilitiesType cachedCapType = new CachedCapabilitiesType();
        cachedCapType.setCapabilities(capType);
        CachingMetadataType cachingMetadata = MiscSchemaUtil.generateCachingMetadata();
        cachedCapType.setCachingMetadata(cachingMetadata);
        resource.setNativeCapabilities(cachedCapType);
    }

    private ConnectorInstance getConnectorInstance(ResourceType resource, OperationResult parentResult) throws ObjectNotFoundException, SchemaException, CommunicationException, ConfigurationException {
        return this.connectorTypeManager.getConfiguredConnectorInstance(resource, parentResult);
    }

    private PrismObjectDefinition<ResourceType> getResourceTypeDefinition() {
        if (this.resourceTypeDefinition == null) {
            this.resourceTypeDefinition = this.prismContext.getSchemaRegistry().findObjectDefinitionByCompileTimeClass(ResourceType.class);
        }
        return this.resourceTypeDefinition;
    }
}

