/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.consistency.impl;

import com.evolveum.midpoint.common.QueryUtil;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.provisioning.api.ChangeNotificationDispatcher;
import com.evolveum.midpoint.provisioning.api.ProvisioningService;
import com.evolveum.midpoint.provisioning.api.ResourceObjectShadowChangeDescription;
import com.evolveum.midpoint.provisioning.api.ResultHandler;
import com.evolveum.midpoint.provisioning.consistency.api.ErrorHandler;
import com.evolveum.midpoint.provisioning.ucf.api.GenericFrameworkException;
import com.evolveum.midpoint.provisioning.util.ShadowCacheUtil;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.holder.XPathHolder;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ObjectTypeUtil;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.QNameUtil;
import com.evolveum.midpoint.util.exception.CommunicationException;
import com.evolveum.midpoint.util.exception.ConfigurationException;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SecurityViolationException;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.OperationResultType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.prism.xml.ns._public.query_2.QueryType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Component
public class ObjectAlreadyExistHandler
extends ErrorHandler {
    @Autowired
    @Qualifier(value="cacheRepositoryService")
    private RepositoryService cacheRepositoryService;
    @Autowired
    private ChangeNotificationDispatcher changeNotificationDispatcher;
    @Autowired(required=true)
    private ProvisioningService provisioningService;
    @Autowired(required=true)
    private PrismContext prismContext;

    @Override
    public void handleError(ResourceObjectShadowType shadow, Exception ex) throws SchemaException, GenericFrameworkException, CommunicationException, ObjectNotFoundException, ObjectAlreadyExistsException, ConfigurationException, SecurityViolationException {
        OperationResult parentResult = OperationResult.createOperationResult((OperationResultType)shadow.getResult());
        OperationResult handleErrorResult = parentResult.createSubresult(ObjectAlreadyExistHandler.class + ".handleError");
        ResourceObjectShadowChangeDescription change = new ResourceObjectShadowChangeDescription();
        if (shadow instanceof AccountShadowType) {
            AccountShadowType account = (AccountShadowType)shadow;
            account.setActivation(ShadowCacheUtil.completeActivation((ResourceObjectShadowType)account, account.getResource(), parentResult));
        }
        change.setResource(shadow.getResource().asPrismObject());
        change.setSourceChannel(QNameUtil.qNameToUri((QName)SchemaConstants.CHANGE_CHANNEL_DISCOVERY));
        QueryType query = this.createQueryByIcfName(shadow);
        List<PrismObject<AccountShadowType>> foundAccount = this.getExistingAccount(query, parentResult);
        if (!foundAccount.isEmpty() && foundAccount.size() == 1) {
            change.setCurrentShadow(foundAccount.get(0));
            this.changeNotificationDispatcher.notifyChange(change, null, handleErrorResult);
        }
        throw new ObjectAlreadyExistsException(ex.getMessage(), (Throwable)ex);
    }

    private QueryType createQueryByIcfName(ResourceObjectShadowType shadow) throws SchemaException {
        Document doc = DOMUtil.getDocument();
        XPathHolder holder = ObjectTypeUtil.createXPathHolder((QName)SchemaConstants.I_ATTRIBUTES);
        PrismProperty nameProperty = shadow.getAttributes().asPrismContainerValue().findProperty(new QName("http://midpoint.evolveum.com/xml/ns/public/connector/icf-1/resource-schema-2", "name"));
        Element nameFilter = QueryUtil.createEqualFilter((Document)doc, (XPathHolder)holder, (QName)nameProperty.getName(), (String)((String)nameProperty.getValue().getValue()));
        Element resourceFilter = QueryUtil.createEqualRefFilter((Document)doc, null, (QName)ResourceObjectShadowType.F_RESOURCE_REF, (String)shadow.getResourceRef().getOid());
        Element objectClassFilter = QueryUtil.createEqualFilter((Document)doc, null, (QName)ResourceObjectShadowType.F_OBJECT_CLASS, (QName)shadow.getObjectClass());
        Element filter = QueryUtil.createAndFilter((Document)doc, (Element[])new Element[]{nameFilter, resourceFilter, objectClassFilter});
        return QueryUtil.createQuery((Element)filter);
    }

    private List<PrismObject<AccountShadowType>> getExistingAccount(QueryType query, OperationResult parentResult) throws ObjectNotFoundException, CommunicationException, ConfigurationException, SchemaException, SecurityViolationException {
        final ArrayList<PrismObject<AccountShadowType>> foundAccount = new ArrayList<PrismObject<AccountShadowType>>();
        ResultHandler handler = new ResultHandler(){

            public boolean handle(PrismObject object, OperationResult parentResult) {
                return foundAccount.add(object);
            }
        };
        this.provisioningService.searchObjectsIterative(AccountShadowType.class, query, new PagingType(), handler, parentResult);
        return foundAccount;
    }
}

