/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.xml;

import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.schema.SchemaDescription;
import com.evolveum.midpoint.prism.schema.SchemaRegistry;
import com.evolveum.midpoint.prism.xml.DynamicNamespacePrefixMapper;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.JAXBUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PrismJaxbProcessor {
    private static final Trace LOGGER = TraceManager.getTrace(PrismJaxbProcessor.class);
    private PrismContext prismContext;
    private JAXBContext context;

    public PrismJaxbProcessor(PrismContext prismContext) {
        this.prismContext = prismContext;
    }

    public PrismContext getPrismContext() {
        return this.prismContext;
    }

    private SchemaRegistry getSchemaRegistry() {
        return this.prismContext.getSchemaRegistry();
    }

    public void initialize() {
        StringBuilder sb = new StringBuilder();
        Iterator<Package> iterator = this.getSchemaRegistry().getCompileTimePackages().iterator();
        while (iterator.hasNext()) {
            Package jaxbPackage = iterator.next();
            sb.append(jaxbPackage.getName());
            if (!iterator.hasNext()) continue;
            sb.append(":");
        }
        String jaxbPaths = sb.toString();
        if (jaxbPaths.isEmpty()) {
            LOGGER.warn("No JAXB paths, skipping creation of JAXB context");
        } else {
            try {
                this.context = JAXBContext.newInstance((String)jaxbPaths);
            }
            catch (JAXBException ex) {
                throw new SystemException("Couldn't create JAXBContext for: " + jaxbPaths, (Throwable)ex);
            }
        }
    }

    public JAXBContext getContext() {
        return this.context;
    }

    public void setContext(JAXBContext context) {
        this.context = context;
    }

    public boolean isJaxbClass(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("No class, no fun");
        }
        if (clazz.getPackage() == null) {
            return false;
        }
        for (Package jaxbPackage : this.getSchemaRegistry().getCompileTimePackages()) {
            if (!jaxbPackage.equals(clazz.getPackage())) continue;
            return true;
        }
        return false;
    }

    public boolean canConvert(Class<?> clazz) {
        return this.isJaxbClass(clazz);
    }

    public boolean canConvert(QName xsdType) {
        SchemaDescription schemaDesc = this.getSchemaRegistry().findSchemaDescriptionByNamespace(xsdType.getNamespaceURI());
        if (schemaDesc == null) {
            return false;
        }
        return schemaDesc.getCompileTimeClassesPackage() != null;
    }

    public Class<?> getCompileTimeClass(QName xsdType) {
        SchemaDescription desc = this.getSchemaRegistry().findSchemaDescriptionByNamespace(xsdType.getNamespaceURI());
        if (desc == null) {
            return null;
        }
        Map<QName, Class<?>> map = desc.getXsdTypeTocompileTimeClassMap();
        if (map == null) {
            return null;
        }
        return map.get(xsdType);
    }

    public <T> T toJavaValue(Element element, Class<T> typeClass) throws JAXBException {
        QName type = JAXBUtil.getTypeQName(typeClass);
        return (T)this.toJavaValue(element, type);
    }

    public Object toJavaValue(Element element, QName xsdType) throws JAXBException {
        Class<?> declaredType = this.getCompileTimeClass(xsdType);
        if (declaredType == null) {
            throw new SystemException("Cannot determine Java type for " + xsdType);
        }
        JAXBElement jaxbElement = this.createUnmarshaller().unmarshal((Node)element, declaredType);
        Object object = jaxbElement.getValue();
        return object;
    }

    private Marshaller createMarshaller(Map<String, Object> jaxbProperties) throws JAXBException {
        Marshaller marshaller = this.context.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        DynamicNamespacePrefixMapper namespacePrefixMapper = this.getSchemaRegistry().getNamespacePrefixMapper().clone();
        namespacePrefixMapper.setAlwaysExplicit(true);
        marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", (Object)namespacePrefixMapper);
        if (jaxbProperties != null) {
            for (Map.Entry<String, Object> property : jaxbProperties.entrySet()) {
                marshaller.setProperty(property.getKey(), property.getValue());
            }
        }
        return marshaller;
    }

    private Marshaller getMarshaller() throws JAXBException {
        return this.createMarshaller(null);
    }

    private Unmarshaller createUnmarshaller() throws JAXBException {
        return this.context.createUnmarshaller();
    }

    private Unmarshaller getUnmarshaller() throws JAXBException {
        return this.createUnmarshaller();
    }

    public String marshalToString(Objectable objectable) throws JAXBException {
        return this.marshalToString(objectable, new HashMap<String, Object>());
    }

    public String marshalToString(Objectable objectable, Map<String, Object> properties) throws JAXBException {
        QName elementQName = this.determineElementQName(objectable);
        JAXBElement jaxbElement = new JAXBElement(elementQName, objectable.getClass(), (Object)objectable);
        return this.marshalElementToString(jaxbElement, properties);
    }

    public String marshalElementToString(JAXBElement<?> jaxbElement) throws JAXBException {
        return this.marshalElementToString(jaxbElement, (Map<String, Object>)new HashMap<String, Object>());
    }

    public String marshalElementToString(JAXBElement<?> jaxbElement, Map<String, Object> properties) throws JAXBException {
        StringWriter writer = new StringWriter();
        Marshaller marshaller = this.getMarshaller();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            marshaller.setProperty(entry.getKey(), entry.getValue());
        }
        marshaller.marshal(jaxbElement, (Writer)writer);
        return writer.getBuffer().toString();
    }

    public String marshalElementToString(Object element) throws JAXBException {
        return this.marshalElementToString(element, new HashMap<String, Object>());
    }

    public String marshalElementToString(Object element, Map<String, Object> properties) throws JAXBException {
        if (element == null) {
            return null;
        }
        if (element instanceof Element) {
            return DOMUtil.serializeDOMToString((Node)((Element)element));
        }
        if (element instanceof JAXBElement) {
            return this.marshalElementToString((JAXBElement)element, properties);
        }
        throw new IllegalArgumentException("Unsupported element type " + element.getClass().getName());
    }

    public String marshalElementToString(Object element, QName elementName) throws JAXBException {
        if (element == null) {
            return null;
        }
        if (element instanceof Element) {
            return DOMUtil.serializeDOMToString((Node)((Element)element));
        }
        if (element instanceof JAXBElement) {
            return this.marshalElementToString((JAXBElement)element);
        }
        JAXBElement jaxbElement = new JAXBElement(elementName, Object.class, element);
        return this.marshalElementToString(jaxbElement);
    }

    public void marshalToDom(Objectable objectable, Node parentNode) throws JAXBException {
        QName elementQName = this.determineElementQName(objectable);
        JAXBElement jaxbElement = new JAXBElement(elementQName, objectable.getClass(), (Object)objectable);
        this.marshalElementToDom(jaxbElement, parentNode);
    }

    public void marshalElementToDom(JAXBElement<?> jaxbElement, Node parentNode) throws JAXBException {
        this.getMarshaller().marshal(jaxbElement, parentNode);
    }

    public <T> Element marshalElementToDom(JAXBElement<T> jaxbElement, Document doc) throws JAXBException {
        if (doc == null) {
            doc = DOMUtil.getDocument();
        }
        Element element = doc.createElementNS(jaxbElement.getName().getNamespaceURI(), jaxbElement.getName().getLocalPart());
        this.marshalElementToDom(jaxbElement, element);
        return (Element)element.getFirstChild();
    }

    public <T> Element marshalObjectToDom(T jaxbObject, QName elementQName, Document doc) throws JAXBException {
        if (doc == null) {
            doc = DOMUtil.getDocument();
        }
        JAXBElement jaxbElement = new JAXBElement(elementQName, jaxbObject.getClass(), jaxbObject);
        Element element = doc.createElementNS(elementQName.getNamespaceURI(), elementQName.getLocalPart());
        this.marshalElementToDom(jaxbElement, element);
        return (Element)element.getFirstChild();
    }

    public <T> void marshalObjectToDom(T jaxbObject, QName elementQName, Element parentElement) throws JAXBException {
        JAXBElement jaxbElement = new JAXBElement(elementQName, jaxbObject.getClass(), jaxbObject);
        this.marshalElementToDom(jaxbElement, parentElement);
    }

    public Element toDomElement(Object element) throws JAXBException {
        return this.toDomElement(element, DOMUtil.getDocument());
    }

    public Element toDomElement(Object jaxbElement, Document doc) throws JAXBException {
        return this.toDomElement(jaxbElement, doc, false, false, false);
    }

    public Element toDomElement(Object jaxbElement, Document doc, boolean adopt, boolean clone, boolean deep) throws JAXBException {
        if (jaxbElement == null) {
            return null;
        }
        if (jaxbElement instanceof Element) {
            Element domElement = (Element)jaxbElement;
            if (clone) {
                domElement = (Element)domElement.cloneNode(deep);
            }
            if (domElement.getOwnerDocument().equals(doc)) {
                return domElement;
            }
            if (adopt) {
                doc.adoptNode(domElement);
            }
            return domElement;
        }
        if (jaxbElement instanceof JAXBElement) {
            return this.marshalElementToDom((JAXBElement)jaxbElement, doc);
        }
        throw new IllegalArgumentException("Not an element: " + jaxbElement + " (" + jaxbElement.getClass().getName() + ")");
    }

    public <T> JAXBElement<T> unmarshalElement(String xmlString, Class<T> type) throws JAXBException, SchemaException {
        if (xmlString == null) {
            return null;
        }
        if (!(xmlString = xmlString.trim()).startsWith("<") || !xmlString.endsWith(">")) {
            throw new IllegalArgumentException("Provided string is unlikely to be an XML");
        }
        StringReader reader = null;
        try {
            reader = new StringReader(xmlString);
            JAXBElement<T> element = this.unmarshalElement(reader, type);
            this.adopt(element);
            JAXBElement<T> jAXBElement = element;
            return jAXBElement;
        }
        finally {
            if (reader != null) {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
    }

    public <T> JAXBElement<T> unmarshalElement(InputStream input, Class<T> type) throws JAXBException, SchemaException {
        Object object = this.getUnmarshaller().unmarshal(input);
        JAXBElement jaxbElement = (JAXBElement)object;
        this.adopt(jaxbElement);
        return jaxbElement;
    }

    public <T> JAXBElement<T> unmarshalElement(Reader reader, Class<T> type) throws JAXBException, SchemaException {
        Object object = this.getUnmarshaller().unmarshal(reader);
        JAXBElement jaxbElement = (JAXBElement)object;
        this.adopt(jaxbElement);
        return jaxbElement;
    }

    public <T> T unmarshalToObject(Node node, Class<T> type) throws JAXBException, SchemaException {
        JAXBElement<T> element = this.unmarshalElement(node, type);
        if (element == null) {
            return null;
        }
        this.adopt(element);
        return (T)element.getValue();
    }

    public <T> JAXBElement<T> unmarshalElement(Node node, Class<T> type) throws JAXBException, SchemaException {
        Object object = this.createUnmarshaller().unmarshal(node);
        JAXBElement jaxbElement = (JAXBElement)object;
        this.adopt(jaxbElement);
        return jaxbElement;
    }

    public <T> T unmarshalObject(File file, Class<T> type) throws JAXBException, SchemaException, FileNotFoundException {
        JAXBElement<T> element = this.unmarshalElement(file, type);
        if (element == null) {
            return null;
        }
        Object value = element.getValue();
        return (T)value;
    }

    public <T> T unmarshalObject(String stringXml, Class<T> type) throws JAXBException, SchemaException {
        JAXBElement<T> element = this.unmarshalElement(stringXml, type);
        if (element == null) {
            return null;
        }
        Object value = element.getValue();
        this.adopt(value, type);
        return (T)value;
    }

    public <T> JAXBElement<T> unmarshalElement(File file, Class<T> type) throws SchemaException, FileNotFoundException, JAXBException {
        if (file == null) {
            throw new IllegalArgumentException("File argument must not be null.");
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            JAXBElement element = (JAXBElement)this.getUnmarshaller().unmarshal((InputStream)is);
            this.adopt(element);
            JAXBElement jAXBElement = element;
            return jAXBElement;
        }
        finally {
            if (is != null) {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }

    public <T> T unmarshalRootObject(File file, Class<T> type) throws JAXBException, FileNotFoundException, SchemaException {
        Validate.notNull((Object)file, (String)"File must not be null.");
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            Object object = this.getUnmarshaller().unmarshal((InputStream)is);
            this.adopt(object);
            Object object2 = object;
            return (T)object2;
        }
        finally {
            if (is != null) {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }

    public boolean compareAny(List<Object> a, List<Object> b) {
        if (a == b) {
            return true;
        }
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        int i = 0;
        while (i < a.size()) {
            if (!this.compareElement(a.get(i), b.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean compareElement(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        Document doc = null;
        Element ae = null;
        Element be = null;
        if (a instanceof Element) {
            ae = (Element)a;
        } else if (a instanceof JAXBElement) {
            if (doc == null) {
                doc = DOMUtil.getDocument();
            }
            try {
                ae = this.marshalElementToDom((JAXBElement)a, doc);
            }
            catch (JAXBException e) {
                throw new IllegalStateException("Failed to marshall element " + a, e);
            }
        } else {
            throw new IllegalArgumentException("Got unexpected type " + a.getClass().getName() + ": " + a);
        }
        if (b instanceof Element) {
            be = (Element)b;
        } else if (a instanceof JAXBElement) {
            if (doc == null) {
                doc = DOMUtil.getDocument();
            }
            try {
                be = this.marshalElementToDom((JAXBElement)a, doc);
            }
            catch (JAXBException e) {
                throw new IllegalStateException("Failed to marshall element " + b, e);
            }
        } else {
            throw new IllegalArgumentException("Got unexpected type " + b.getClass().getName() + ": " + b);
        }
        return DOMUtil.compareElement((Element)ae, (Element)be, (boolean)true);
    }

    public <T> T fromElement(Object element, Class<T> type) throws SchemaException {
        if (element == null) {
            return null;
        }
        if (type.isAssignableFrom(element.getClass())) {
            return (T)element;
        }
        if (element instanceof JAXBElement) {
            if (((JAXBElement)element).getValue() == null) {
                return null;
            }
            if (type.isAssignableFrom(((JAXBElement)element).getValue().getClass())) {
                return (T)((JAXBElement)element).getValue();
            }
        }
        if (element instanceof Element) {
            try {
                JAXBElement<T> unmarshalledElement = this.unmarshalElement((Element)element, type);
                return (T)unmarshalledElement.getValue();
            }
            catch (JAXBException e) {
                throw new IllegalArgumentException("Unmarshall failed: " + e.getMessage(), e);
            }
        }
        throw new IllegalArgumentException("Unknown element type " + element.getClass().getName());
    }

    private QName determineElementQName(Objectable objectable) {
        PrismObject prismObject = objectable.asPrismObject();
        if (prismObject.getName() != null) {
            return prismObject.getName();
        }
        PrismContainerDefinition definition = prismObject.getDefinition();
        if (definition != null && definition.getNameOrDefaultName() != null) {
            return definition.getNameOrDefaultName();
        }
        throw new IllegalStateException("Cannot determine element name of " + objectable);
    }

    private boolean isObjectable(Class type) {
        return Objectable.class.isAssignableFrom(type);
    }

    private <T> void adopt(T object, Class<T> type) throws SchemaException {
        if (object instanceof Objectable) {
            this.getPrismContext().adopt((Objectable)object);
        }
    }

    private void adopt(Object object) throws SchemaException {
        if (object instanceof JAXBElement) {
            this.adopt(((JAXBElement)object).getValue());
        } else if (object instanceof Objectable) {
            this.getPrismContext().adopt((Objectable)object);
        }
    }
}

