/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.xml;

import com.evolveum.midpoint.prism.xml.DynamicNamespacePrefixMapper;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.Dumpable;
import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;

public class GlobalDynamicNamespacePrefixMapper
extends NamespacePrefixMapper
implements DynamicNamespacePrefixMapper,
Dumpable {
    private static final Map<String, String> globalNamespacePrefixMap = new HashMap<String, String>();
    private Map<String, String> localNamespacePrefixMap = new HashMap<String, String>();
    private String defaultNamespace = null;
    private boolean alwaysExplicit = false;

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    @Override
    public boolean isAlwaysExplicit() {
        return this.alwaysExplicit;
    }

    @Override
    public void setAlwaysExplicit(boolean alwaysExplicit) {
        this.alwaysExplicit = alwaysExplicit;
    }

    @Override
    public void registerPrefix(String namespace, String prefix, boolean isDefaultNamespace) {
        globalNamespacePrefixMap.put(namespace, prefix);
        if (isDefaultNamespace || prefix == null) {
            this.defaultNamespace = namespace;
        }
    }

    @Override
    public void registerPrefixLocal(String namespace, String prefix) {
        this.localNamespacePrefixMap.put(namespace, prefix);
    }

    @Override
    public String getPrefix(String namespace) {
        if (this.defaultNamespace != null && this.defaultNamespace.equals(namespace) && !this.alwaysExplicit) {
            return "";
        }
        return this.getPrefixExplicit(namespace);
    }

    public String getPrefixExplicit(String namespace) {
        String prefix = this.localNamespacePrefixMap.get(namespace);
        if (prefix == null) {
            return GlobalDynamicNamespacePrefixMapper.getPreferredPrefix(namespace);
        }
        return prefix;
    }

    @Override
    public QName setQNamePrefix(QName qname) {
        String namespace = qname.getNamespaceURI();
        String prefix = this.getPrefix(namespace);
        if (prefix == null) {
            return qname;
        }
        return new QName(qname.getNamespaceURI(), qname.getLocalPart(), prefix);
    }

    @Override
    public QName setQNamePrefixExplicit(QName qname) {
        String namespace = qname.getNamespaceURI();
        String prefix = this.getPrefixExplicit(namespace);
        if (prefix == null) {
            return qname;
        }
        return new QName(qname.getNamespaceURI(), qname.getLocalPart(), prefix);
    }

    public String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) {
        if (this.defaultNamespace != null && this.defaultNamespace.equals(namespaceUri) && !this.alwaysExplicit) {
            return "";
        }
        return GlobalDynamicNamespacePrefixMapper.getPreferredPrefix(namespaceUri, suggestion);
    }

    public static synchronized String getPreferredPrefix(String namespace) {
        return GlobalDynamicNamespacePrefixMapper.getPreferredPrefix(namespace, null);
    }

    public static synchronized String getPreferredPrefix(String namespace, String hintPrefix) {
        String prefix = globalNamespacePrefixMap.get(namespace);
        if (StringUtils.isEmpty((String)prefix)) {
            prefix = StringUtils.isEmpty((String)hintPrefix) ? "gen" + new Random().nextInt(999) : (globalNamespacePrefixMap.containsValue(hintPrefix) ? "gen" + new Random().nextInt(999) : hintPrefix);
            globalNamespacePrefixMap.put(namespace, prefix);
        }
        return prefix;
    }

    @Override
    public GlobalDynamicNamespacePrefixMapper clone() {
        GlobalDynamicNamespacePrefixMapper clone = new GlobalDynamicNamespacePrefixMapper();
        clone.defaultNamespace = this.defaultNamespace;
        clone.localNamespacePrefixMap = this.clonePrefixMap(this.localNamespacePrefixMap);
        clone.alwaysExplicit = this.alwaysExplicit;
        return clone;
    }

    private Map<String, String> clonePrefixMap(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, String> clone = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            clone.put(entry.getKey(), entry.getValue());
        }
        return clone;
    }

    public String dump() {
        StringBuilder sb = new StringBuilder("GlobalDynamicNamespacePrefixMapper(");
        sb.append(this.defaultNamespace);
        sb.append("):\n");
        DebugUtil.indentDebugDump((StringBuilder)sb, (int)1);
        sb.append("Global map:\n");
        DebugUtil.debugDumpMapMultiLine((StringBuilder)sb, globalNamespacePrefixMap, (int)2);
        sb.append("\n");
        DebugUtil.indentDebugDump((StringBuilder)sb, (int)1);
        sb.append("Local map:\n");
        DebugUtil.debugDumpMapMultiLine((StringBuilder)sb, this.localNamespacePrefixMap, (int)2);
        return sb.toString();
    }
}

