/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.dom;

import com.evolveum.midpoint.prism.Containerable;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.dom.ElementPrismContainerImpl;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeListPrismContainerImpl<T extends Containerable>
implements NodeList {
    private ElementPrismContainerImpl<T> elementPrismContainerImpl;
    private String selectionNamespace;
    private String selectionLocalName;

    NodeListPrismContainerImpl(ElementPrismContainerImpl<T> elementPrismContainerImpl) {
        this.elementPrismContainerImpl = elementPrismContainerImpl;
    }

    NodeListPrismContainerImpl(ElementPrismContainerImpl<T> elementPrismContainerImpl, String selectionNamespace, String selectionLocalName) {
        this.elementPrismContainerImpl = elementPrismContainerImpl;
        this.selectionNamespace = selectionNamespace;
        this.selectionLocalName = selectionLocalName;
    }

    @Override
    public Node item(int index) {
        for (Item<?> item : this.getContainerValue().getItems()) {
            if (!this.selected(item)) continue;
            if (index < item.getValues().size()) {
                return ((PrismValue)item.getValue(index)).asDomElement();
            }
            index -= item.getValues().size();
        }
        return null;
    }

    @Override
    public int getLength() {
        int size = 0;
        for (Item<?> item : this.getContainerValue().getItems()) {
            if (!this.selected(item)) continue;
            size += item.getValues().size();
        }
        return size;
    }

    boolean isEmpty() {
        return this.getLength() == 0;
    }

    private PrismContainerValue<T> getContainerValue() {
        return this.elementPrismContainerImpl.getValue();
    }

    private boolean selected(Item item) {
        if (this.selectionLocalName == null) {
            return true;
        }
        return this.selectionLocalName.equals(item.getName().getLocalPart()) && (this.selectionNamespace == null || this.selectionNamespace.equals(item.getName().getNamespaceURI()));
    }
}

