/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.dom;

import com.evolveum.midpoint.prism.dom.AttributeNodeImpl;
import com.evolveum.midpoint.prism.dom.ElementPrismAbstractImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AttributeNamedNodeMapImpl
implements NamedNodeMap {
    private List<AttributeNodeImpl> attributeList;
    private ElementPrismAbstractImpl parent;

    AttributeNamedNodeMapImpl(Map<String, String> attributeMap, String namespace, ElementPrismAbstractImpl parent) {
        this.attributeList = this.convert(attributeMap, namespace);
        this.parent = parent;
    }

    private List<AttributeNodeImpl> convert(Map<String, String> map, String namespace) {
        ArrayList<AttributeNodeImpl> list = new ArrayList<AttributeNodeImpl>();
        if (map != null) {
            int i = 0;
            for (Map.Entry<String, String> entry : map.entrySet()) {
                list.add(this.createAttr(entry.getKey(), entry.getValue(), namespace, i));
                ++i;
            }
        }
        return list;
    }

    private AttributeNodeImpl createAttr(String name, String value, String namespace, int index) {
        QName attrQName = new QName(namespace, name);
        AttributeNodeImpl attr = new AttributeNodeImpl(attrQName, value);
        attr.setIndex(index);
        attr.setNodeMap(this);
        attr.setParent(this.parent);
        return attr;
    }

    @Override
    public Node getNamedItem(String name) {
        for (AttributeNodeImpl attr : this.attributeList) {
            if (!name.equals(attr.getName())) continue;
            return attr;
        }
        return null;
    }

    @Override
    public Node setNamedItem(Node arg) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    @Override
    public Node removeNamedItem(String name) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    @Override
    public Node item(int index) {
        return this.attributeList.get(index);
    }

    @Override
    public int getLength() {
        return this.attributeList.size();
    }

    @Override
    public Node getNamedItemNS(String namespaceURI, String localName) throws DOMException {
        for (AttributeNodeImpl attr : this.attributeList) {
            if (!localName.equals(attr.getName()) || !namespaceURI.equals(attr.getNamespaceURI())) continue;
            return attr;
        }
        return null;
    }

    @Override
    public Node setNamedItemNS(Node arg) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    @Override
    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(7, "This kind of modification is not supported (yet)");
    }

    public Node getPrevious(AttributeNodeImpl attributeNodeImpl) {
        int index = attributeNodeImpl.getIndex();
        if (index == 0) {
            return null;
        }
        return this.attributeList.get(index - 1);
    }

    public Node getNext(AttributeNodeImpl attributeNodeImpl) {
        int index = attributeNodeImpl.getIndex();
        if (index > this.attributeList.size() - 1) {
            return null;
        }
        return this.attributeList.get(index + 1);
    }
}

