/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism;

import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.Itemable;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.SourceType;
import com.evolveum.midpoint.prism.Visitable;
import com.evolveum.midpoint.prism.Visitor;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.Dumpable;
import com.evolveum.midpoint.util.exception.SchemaException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.Element;

public abstract class PrismValue
implements Visitable,
Serializable,
Dumpable,
DebugDumpable {
    private SourceType type;
    private Objectable source;
    private Itemable parent;
    protected Element domElement = null;

    PrismValue() {
    }

    PrismValue(SourceType type, Objectable source) {
        this.type = type;
        this.source = source;
    }

    PrismValue(SourceType type, Objectable source, Itemable parent) {
        this.type = type;
        this.source = source;
        this.parent = parent;
    }

    public void setSource(Objectable source) {
        this.source = source;
    }

    public void setType(SourceType type) {
        this.type = type;
    }

    public SourceType getType() {
        return this.type;
    }

    public Objectable getSource() {
        return this.source;
    }

    public Itemable getParent() {
        return this.parent;
    }

    public void setParent(Itemable parent) {
        this.parent = parent;
    }

    public PropertyPath getPath(PropertyPath pathPrefix) {
        Itemable parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException("No parent, cannot create value path for " + this);
        }
        return parent.getPath(pathPrefix);
    }

    public PrismContext getPrismContext() {
        if (this.parent != null) {
            return this.parent.getPrismContext();
        }
        return null;
    }

    public void applyDefinition(ItemDefinition definition) throws SchemaException {
        this.applyDefinition(definition, true);
    }

    public void applyDefinition(ItemDefinition definition, boolean force) throws SchemaException {
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public Element asDomElement() {
        if (this.domElement == null) {
            this.domElement = this.createDomElement();
        }
        return this.domElement;
    }

    protected abstract Element createDomElement();

    protected void clearDomElement() {
        this.domElement = null;
    }

    public abstract void checkConsistenceInternal(Itemable var1, PropertyPath var2);

    public boolean representsSameValue(PrismValue other) {
        return false;
    }

    public boolean equals(PrismValue otherValue, boolean ignoreMetadata) {
        return this.equals(this, otherValue, ignoreMetadata);
    }

    public boolean equals(PrismValue thisValue, PrismValue otherValue, boolean ignoreMetadata) {
        if (ignoreMetadata) {
            return this.equalsRealValue(thisValue, otherValue);
        }
        return this.equals(thisValue, otherValue);
    }

    public boolean equalsRealValue(PrismValue otherValue) {
        return this.equalsRealValue(this, otherValue);
    }

    public abstract boolean equalsRealValue(PrismValue var1, PrismValue var2);

    public static <V extends PrismValue> boolean containsRealValue(Collection<V> collection, V value) {
        if (collection == null) {
            return false;
        }
        for (PrismValue colVal : collection) {
            if (!colVal.equalsRealValue(value)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean isRaw();

    public static <X extends PrismValue> Collection<X> cloneValues(Collection<X> values) {
        ArrayList<PrismValue> clonedCollection = new ArrayList<PrismValue>(values.size());
        for (PrismValue val : values) {
            clonedCollection.add(val.clone());
        }
        return clonedCollection;
    }

    public abstract PrismValue clone();

    protected void copyValues(PrismValue clone) {
        clone.type = this.type;
        clone.source = this.source;
        clone.parent = this.parent;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrismValue other = (PrismValue)obj;
        return this.equals(this, other);
    }

    public boolean equals(PrismValue thisValue, PrismValue otherValue) {
        if (this.source == null ? otherValue.source != null : !this.source.equals(otherValue.source)) {
            return false;
        }
        return this.type == otherValue.type;
    }

    void diffMatchingRepresentation(PrismValue otherValue, PropertyPath pathPrefix, Collection<? extends ItemDelta> deltas, boolean ignoreMetadata) {
    }
}

