/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism;

import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.Itemable;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismReferenceDefinition;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.SourceType;
import com.evolveum.midpoint.prism.dom.ElementPrismReferenceImpl;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.Dumpable;
import com.evolveum.midpoint.util.exception.SchemaException;
import java.io.Serializable;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class PrismReferenceValue
extends PrismValue
implements Dumpable,
DebugDumpable,
Serializable {
    private String oid = null;
    private PrismObject<?> object = null;
    private QName targetType = null;
    private String description = null;
    private Element filter = null;

    public PrismReferenceValue() {
        this((String)null, (SourceType)null, (Objectable)null);
    }

    public PrismReferenceValue(String oid) {
        this(oid, null, null);
    }

    public PrismReferenceValue(String oid, SourceType type, Objectable source) {
        super(type, source);
        this.oid = oid;
    }

    public String getOid() {
        if (this.oid != null) {
            return this.oid;
        }
        if (this.object != null) {
            return this.object.getOid();
        }
        return null;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public PrismObject getObject() {
        return this.object;
    }

    public void setObject(PrismObject object) {
        this.object = object;
    }

    public QName getTargetType() {
        if (this.targetType != null) {
            return this.targetType;
        }
        if (this.object != null && this.object.getDefinition() != null) {
            return this.object.getDefinition().getTypeName();
        }
        return null;
    }

    public void setTargetType(QName targetType) {
        if (targetType != null) {
            Itemable item = this.getParent();
            DOMUtil.validateNonEmptyQName((QName)targetType, (String)(" in target type in reference " + (item == null ? "(unknown)" : item.getName())));
        }
        this.targetType = targetType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Element getFilter() {
        return this.filter;
    }

    public void setFilter(Element filter) {
        this.filter = filter;
    }

    @Override
    public boolean isRaw() {
        return false;
    }

    @Override
    public void applyDefinition(ItemDefinition definition, boolean force) throws SchemaException {
        if (!(definition instanceof PrismReferenceDefinition)) {
            throw new IllegalArgumentException("Cannot apply " + definition + " to a reference value");
        }
        this.applyDefinition((PrismReferenceDefinition)definition, force);
    }

    public void applyDefinition(PrismReferenceDefinition definition, boolean force) throws SchemaException {
        super.applyDefinition(definition, force);
        if (this.object == null) {
            return;
        }
        if (this.object.getDefinition() != null && !force) {
            return;
        }
        PrismContext prismContext = definition.getPrismContext();
        QName targetTypeName = definition.getTargetTypeName();
        if (targetTypeName == null) {
            throw new SchemaException("Cannot apply definition to composite object in reference " + this.getParent() + ": the target type name is not specified in the reference schema");
        }
        PrismObjectDefinition objectDefinition = prismContext.getSchemaRegistry().findObjectDefinitionByType(targetTypeName);
        if (objectDefinition == null) {
            throw new SchemaException("Cannot apply definition to composite object in reference " + this.getParent() + ": no definition for object type " + targetTypeName);
        }
        this.object.applyDefinition(objectDefinition, force);
    }

    @Override
    protected Element createDomElement() {
        return new ElementPrismReferenceImpl(this);
    }

    @Override
    public void checkConsistenceInternal(Itemable rootItem, PropertyPath parentPath) {
        PropertyPath myPath = this.getParent().getPath(parentPath);
        if (this.oid == null && this.object == null && this.filter == null) {
            throw new IllegalStateException("Neither OID, object nor filter specified in reference value " + this + " (" + myPath + " in " + rootItem + ")");
        }
        if (this.object != null) {
            try {
                this.object.checkConsistence();
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.valueOf(e.getMessage()) + " in reference " + myPath + " in " + rootItem, e);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException(String.valueOf(e.getMessage()) + " in reference " + myPath + " in " + rootItem, e);
            }
        }
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.oid == null ? 0 : this.oid.hashCode());
        result = 31 * result + (this.targetType == null ? 0 : this.targetType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrismReferenceValue other = (PrismReferenceValue)obj;
        return this.equals(this, other);
    }

    @Override
    public boolean equals(PrismValue thisValue, PrismValue otherValue) {
        if (thisValue instanceof PrismReferenceValue && otherValue instanceof PrismReferenceValue) {
            return this.equals((PrismReferenceValue)thisValue, (PrismReferenceValue)otherValue);
        }
        return false;
    }

    public boolean equals(PrismReferenceValue thisValue, PrismReferenceValue otherValue) {
        if (thisValue.oid == null ? otherValue.oid != null : !thisValue.oid.equals(otherValue.oid)) {
            return false;
        }
        return !(thisValue.targetType == null ? otherValue.targetType != null : !thisValue.targetType.equals(otherValue.targetType));
    }

    @Override
    public boolean equalsRealValue(PrismValue thisValue, PrismValue otherValue) {
        if (thisValue instanceof PrismReferenceValue && otherValue instanceof PrismReferenceValue) {
            return this.equalsRealValue((PrismReferenceValue)thisValue, (PrismReferenceValue)otherValue);
        }
        return false;
    }

    public boolean equalsRealValue(PrismReferenceValue thisValue, PrismReferenceValue otherValue) {
        if (otherValue == null) {
            return false;
        }
        String valueToCompare = otherValue.getOid();
        if (valueToCompare == null && thisValue.getOid() == null) {
            return true;
        }
        if (valueToCompare == null || thisValue.getOid() == null) {
            return false;
        }
        return thisValue.getOid().equals(otherValue.getOid());
    }

    @Override
    public boolean representsSameValue(PrismValue other) {
        if (other instanceof PrismPropertyValue) {
            return this.representsSameValue((PrismReferenceValue)other);
        }
        return false;
    }

    public boolean representsSameValue(PrismReferenceValue other) {
        if (this.getOid() != null && other.getOid() != null) {
            return this.getOid().equals(other.getOid());
        }
        return false;
    }

    public static PrismReferenceValue createFromTarget(PrismObject<?> refTarget) {
        PrismReferenceValue refVal = new PrismReferenceValue(refTarget.getOid());
        refVal.setObject(refTarget);
        if (refTarget.getDefinition() != null) {
            refVal.setTargetType(refTarget.getDefinition().getTypeName());
        }
        return refVal;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PRV(");
        if (this.object == null) {
            sb.append("oid=").append(this.oid);
            sb.append(", targetType=").append(DebugUtil.prettyPrint((QName)this.targetType));
        } else {
            sb.append("object=").append(this.object);
        }
        sb.append(", type=").append((Object)this.getType());
        sb.append(", source=").append(this.getSource());
        if (this.filter != null) {
            sb.append(", (filter)");
        }
        sb.append(")");
        return sb.toString();
    }

    public String debugDump() {
        return this.toString();
    }

    public String debugDump(int indent) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < indent) {
            sb.append(DebugDumpable.INDENT_STRING);
            ++i;
        }
        sb.append(this.toString());
        return sb.toString();
    }

    public String dump() {
        return this.toString();
    }

    @Override
    public PrismReferenceValue clone() {
        PrismReferenceValue clone = new PrismReferenceValue(this.getOid(), this.getType(), this.getSource());
        this.copyValues(clone);
        return clone;
    }

    protected void copyValues(PrismReferenceValue clone) {
        super.copyValues(clone);
        clone.targetType = this.targetType;
        if (this.object != null) {
            clone.object = this.object.clone();
        }
        clone.description = this.description;
        clone.filter = this.filter;
    }
}

