/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism;

import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismReferenceDefinition;
import com.evolveum.midpoint.prism.PrismReferenceValue;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.delta.ReferenceDelta;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.DebugUtil;
import java.util.List;
import javax.xml.namespace.QName;

public class PrismReference
extends Item<PrismReferenceValue> {
    private static final long serialVersionUID = 1872343401395762657L;

    public PrismReference(QName name) {
        super(name);
    }

    PrismReference(QName name, PrismReferenceDefinition definition, PrismContext prismContext) {
        super(name, definition, prismContext);
    }

    @Override
    public PrismReferenceDefinition getDefinition() {
        return (PrismReferenceDefinition)super.getDefinition();
    }

    @Override
    public List<PrismReferenceValue> getValues() {
        return super.getValues();
    }

    public PrismReferenceValue getValue() {
        if (this.getDefinition() != null && !this.getDefinition().isDynamic() && this.getDefinition().isMultiValue()) {
            throw new IllegalStateException("Attempt to get single value from property " + this.name + " with multiple values");
        }
        if (this.getValues().size() > 1) {
            throw new IllegalStateException("Attempt to get single value from property " + this.name + " with multiple values");
        }
        if (this.getValues().isEmpty()) {
            PrismReferenceValue rval = new PrismReferenceValue();
            this.add(rval);
            return rval;
        }
        return this.getValues().iterator().next();
    }

    private PrismReferenceValue getValue(String oid) {
        for (PrismReferenceValue val : this.getValues()) {
            if (!oid.equals(val.getOid())) continue;
            return val;
        }
        return null;
    }

    @Override
    public boolean add(PrismReferenceValue value) {
        value.setParent(this);
        return this.getValues().add(value);
    }

    public boolean merge(PrismReferenceValue value) {
        String newOid = value.getOid();
        PrismReferenceValue existingValue = this.getValue(newOid);
        if (existingValue == null) {
            return this.add(value);
        }
        if (value.getObject() != null) {
            existingValue.setObject(value.getObject());
        } else if (value.getTargetType() != null) {
            existingValue.setTargetType(value.getTargetType());
        }
        return true;
    }

    public String getOid() {
        return this.getValue().getOid();
    }

    public PrismReferenceValue findValueByOid(String oid) {
        for (PrismReferenceValue pval : this.getValues()) {
            if (!oid.equals(pval.getOid())) continue;
            return pval;
        }
        return null;
    }

    public ReferenceDelta createDelta(PropertyPath path) {
        return new ReferenceDelta(path, this.getDefinition());
    }

    @Override
    protected void checkDefinition(ItemDefinition def) {
        if (!(def instanceof PrismReferenceDefinition)) {
            throw new IllegalArgumentException("Cannot apply definition " + def + " to reference " + this);
        }
    }

    @Override
    public PrismReference clone() {
        PrismReference clone = new PrismReference(this.getName(), this.getDefinition(), this.prismContext);
        this.copyValues(clone);
        return clone;
    }

    protected void copyValues(PrismReference clone) {
        super.copyValues(clone);
        for (PrismReferenceValue value : this.getValues()) {
            clone.add(value.clone());
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + DebugUtil.prettyPrint((QName)this.getName()) + "):" + this.getValues();
    }

    @Override
    public String debugDump(int indent) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < indent) {
            sb.append(DebugDumpable.INDENT_STRING);
            ++i;
        }
        sb.append(this.getDebugDumpClassName()).append(": ").append(DebugUtil.prettyPrint((QName)this.getName())).append(" = ");
        if (this.getValues() == null) {
            sb.append("null");
        } else {
            sb.append("[ ");
            for (PrismReferenceValue value : this.getValues()) {
                sb.append(DebugUtil.prettyPrint((Object)value));
                sb.append(", ");
            }
            sb.append(" ]");
        }
        if (this.getDefinition() != null) {
            sb.append(" def");
        }
        return sb.toString();
    }

    @Override
    protected String getDebugDumpClassName() {
        return "PR";
    }
}

