/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.activiti.engine.impl.EventSubscriptionQueryImpl;
import org.activiti.engine.impl.HistoricActivityInstanceQueryImpl;
import org.activiti.engine.impl.JobQueryImpl;
import org.activiti.engine.impl.TaskQueryImpl;
import org.activiti.engine.impl.bpmn.parser.SignalEventDefinition;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.history.handler.ActivityInstanceEndHandler;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.jobexecutor.TimerDeclarationImpl;
import org.activiti.engine.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricVariableUpdateEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.MessageEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.SuspensionState;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.TimerEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.persistence.entity.VariableScopeImpl;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmException;
import org.activiti.engine.impl.pvm.PvmExecution;
import org.activiti.engine.impl.pvm.PvmProcessDefinition;
import org.activiti.engine.impl.pvm.PvmProcessElement;
import org.activiti.engine.impl.pvm.PvmProcessInstance;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.delegate.ExecutionListenerExecution;
import org.activiti.engine.impl.pvm.delegate.SignallableActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.impl.pvm.runtime.AtomicOperation;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;
import org.activiti.engine.impl.pvm.runtime.OutgoingExecution;
import org.activiti.engine.impl.pvm.runtime.StartingExecution;
import org.activiti.engine.impl.variable.VariableDeclaration;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.Job;
import org.activiti.engine.runtime.ProcessInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionEntity
extends VariableScopeImpl
implements ActivityExecution,
ExecutionListenerExecution,
Execution,
PvmExecution,
ProcessInstance,
InterpretableExecution,
PersistentObject {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(ExecutionEntity.class.getName());
    protected ProcessDefinitionImpl processDefinition;
    protected ActivityImpl activity;
    protected TransitionImpl transition = null;
    protected TransitionImpl transitionBeingTaken = null;
    protected ExecutionEntity processInstance;
    protected ExecutionEntity parent;
    protected List<ExecutionEntity> executions;
    protected ExecutionEntity superExecution;
    protected ExecutionEntity subProcessInstance;
    protected StartingExecution startingExecution;
    protected boolean isActive = true;
    protected boolean isScope = true;
    protected boolean isConcurrent = false;
    protected boolean isEnded = false;
    protected boolean isEventScope = false;
    protected String eventName;
    protected PvmProcessElement eventSource;
    protected int executionListenerIndex = 0;
    protected List<CompensateEventSubscriptionEntity> compensateEventSubscriptions;
    protected boolean deleteRoot;
    protected String deleteReason;
    protected ExecutionEntity replacedBy;
    protected AtomicOperation nextOperation;
    protected boolean isOperating = false;
    protected String id = null;
    protected int revision = 1;
    protected int suspensionState = SuspensionState.ACTIVE.getStateCode();
    protected String processDefinitionId;
    protected String activityId;
    protected String processInstanceId;
    protected String businessKey;
    protected String parentId;
    protected String superExecutionId;
    protected boolean forcedUpdate;

    public ExecutionEntity() {
    }

    public ExecutionEntity(ActivityImpl activityImpl) {
        this.startingExecution = new StartingExecution(activityImpl);
    }

    @Override
    public ExecutionEntity createExecution() {
        ExecutionEntity createdExecution = this.newExecution();
        this.ensureExecutionsInitialized();
        this.executions.add(createdExecution);
        createdExecution.setParent(this);
        createdExecution.setProcessDefinition(this.getProcessDefinition());
        createdExecution.setProcessInstance(this.getProcessInstance());
        createdExecution.setActivity(this.getActivity());
        if (log.isLoggable(Level.FINE)) {
            log.fine("Child execution " + createdExecution + " created with parent " + this);
        }
        return createdExecution;
    }

    @Override
    public PvmProcessInstance createSubProcessInstance(PvmProcessDefinition processDefinition) {
        ExecutionEntity subProcessInstance = this.newExecution();
        subProcessInstance.setSuperExecution(this);
        this.setSubProcessInstance(subProcessInstance);
        subProcessInstance.setProcessDefinition((ProcessDefinitionImpl)processDefinition);
        subProcessInstance.setProcessInstance(subProcessInstance);
        CommandContext commandContext = Context.getCommandContext();
        int historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        if (historyLevel >= 1) {
            DbSqlSession dbSqlSession = commandContext.getSession(DbSqlSession.class);
            HistoricProcessInstanceEntity historicProcessInstance = new HistoricProcessInstanceEntity(subProcessInstance);
            dbSqlSession.insert(historicProcessInstance);
        }
        return subProcessInstance;
    }

    protected ExecutionEntity newExecution() {
        ExecutionEntity newExecution = new ExecutionEntity();
        newExecution.executions = new ArrayList<ExecutionEntity>();
        Context.getCommandContext().getDbSqlSession().insert(newExecution);
        return newExecution;
    }

    @Override
    public void initialize() {
        List signalDefinitions;
        List timerDeclarations;
        log.fine("initializing " + this);
        ScopeImpl scope = this.getScope();
        this.ensureParentInitialized();
        List variableDeclarations = (List)scope.getProperty("variableDeclarations");
        if (variableDeclarations != null) {
            for (VariableDeclaration variableDeclaration : variableDeclarations) {
                variableDeclaration.initialize(this, this.parent);
            }
        }
        if ((timerDeclarations = (List)scope.getProperty("timerDeclarations")) != null) {
            for (TimerDeclarationImpl timerDeclaration : timerDeclarations) {
                TimerEntity timer = timerDeclaration.prepareTimerEntity(this);
                Context.getCommandContext().getJobManager().schedule(timer);
            }
        }
        if ((signalDefinitions = (List)scope.getProperty("signalDefinition")) != null) {
            for (SignalEventDefinition signalDefinition : signalDefinitions) {
                SignalEventSubscriptionEntity signalEventSubscriptionEntity = new SignalEventSubscriptionEntity(this);
                signalEventSubscriptionEntity.setEventName(signalDefinition.getSignalName());
                if (signalDefinition.getActivityId() != null) {
                    ActivityImpl activity = this.getActivity().findActivity(signalDefinition.getActivityId());
                    signalEventSubscriptionEntity.setActivity(activity);
                }
                Context.getCommandContext().getEventSubscriptionManager().insert(signalEventSubscriptionEntity);
            }
        }
    }

    @Override
    public void start() {
        if (this.startingExecution == null && this.isProcessInstance()) {
            this.startingExecution = new StartingExecution(this.processDefinition.getInitial());
        }
        this.performOperation(AtomicOperation.PROCESS_START);
    }

    @Override
    public void destroy() {
        log.fine("destroying " + this);
        this.ensureParentInitialized();
        this.removeVariablesLocal();
        this.removeVariables();
        this.setScope(false);
    }

    @Override
    public void end() {
        this.isActive = false;
        this.isEnded = true;
        this.performOperation(AtomicOperation.ACTIVITY_END);
    }

    @Override
    public void signal(String signalName, Object signalData) {
        this.ensureActivityInitialized();
        SignallableActivityBehavior activityBehavior = (SignallableActivityBehavior)this.activity.getActivityBehavior();
        try {
            activityBehavior.signal(this, signalName, signalData);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PvmException("couldn't process signal '" + signalName + "' on activity '" + this.activity.getId() + "': " + e.getMessage(), e);
        }
    }

    @Override
    public void take(PvmTransition transition) {
        if (this.transition != null) {
            throw new PvmException("already taking a transition");
        }
        if (transition == null) {
            throw new PvmException("transition is null");
        }
        this.setActivity((ActivityImpl)transition.getSource());
        this.setTransition((TransitionImpl)transition);
        this.performOperation(AtomicOperation.TRANSITION_NOTIFY_LISTENER_END);
    }

    @Override
    public void executeActivity(PvmActivity activity) {
        this.setActivity((ActivityImpl)activity);
        this.performOperation(AtomicOperation.ACTIVITY_START);
    }

    @Override
    public List<ActivityExecution> findInactiveConcurrentExecutions(PvmActivity activity) {
        ArrayList<ActivityExecution> inactiveConcurrentExecutionsInActivity = new ArrayList<ActivityExecution>();
        ArrayList<ActivityExecution> otherConcurrentExecutions = new ArrayList<ActivityExecution>();
        if (this.isConcurrent()) {
            List<ExecutionEntity> concurrentExecutions = this.getParent().getAllChildExecutions();
            for (ActivityExecution activityExecution : concurrentExecutions) {
                if (activityExecution.getActivity() == activity) {
                    if (activityExecution.isActive()) continue;
                    inactiveConcurrentExecutionsInActivity.add(activityExecution);
                    continue;
                }
                otherConcurrentExecutions.add(activityExecution);
            }
        } else if (!this.isActive()) {
            inactiveConcurrentExecutionsInActivity.add(this);
        } else {
            otherConcurrentExecutions.add(this);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("inactive concurrent executions in '" + activity + "': " + inactiveConcurrentExecutionsInActivity);
            log.fine("other concurrent executions: " + otherConcurrentExecutions);
        }
        return inactiveConcurrentExecutionsInActivity;
    }

    protected List<ExecutionEntity> getAllChildExecutions() {
        ArrayList<ExecutionEntity> childExecutions = new ArrayList<ExecutionEntity>();
        for (ExecutionEntity childExecution : this.getExecutions()) {
            childExecutions.add(childExecution);
            childExecutions.addAll(childExecution.getAllChildExecutions());
        }
        return childExecutions;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void takeAll(List<PvmTransition> transitions, List<ActivityExecution> recyclableExecutions) {
        transitions = new ArrayList<PvmTransition>(transitions);
        List<ActivityExecution> list = recyclableExecutions = recyclableExecutions != null ? new ArrayList<ActivityExecution>(recyclableExecutions) : new ArrayList();
        if (recyclableExecutions.size() > 1) {
            for (ActivityExecution recyclableExecution : recyclableExecutions) {
                if (!((ExecutionEntity)recyclableExecution).isScope()) continue;
                throw new PvmException("joining scope executions is not allowed");
            }
        }
        ExecutionEntity concurrentRoot = this.isConcurrent && !this.isScope ? this.getParent() : this;
        ArrayList<ExecutionEntity> concurrentActiveExecutions = new ArrayList<ExecutionEntity>();
        ArrayList<ExecutionEntity> concurrentInActiveExecutions = new ArrayList<ExecutionEntity>();
        for (ExecutionEntity execution : concurrentRoot.getExecutions()) {
            if (execution.isActive()) {
                concurrentActiveExecutions.add(execution);
                continue;
            }
            concurrentInActiveExecutions.add(execution);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("transitions to take concurrent: " + transitions);
            log.fine("active concurrent executions: " + concurrentActiveExecutions);
        }
        if (transitions.size() == 1 && concurrentActiveExecutions.isEmpty() && this.allExecutionsInSameActivity(concurrentInActiveExecutions)) {
            List<ActivityExecution> recyclableExecutionImpls = recyclableExecutions;
            recyclableExecutions.remove(concurrentRoot);
            for (ExecutionEntity executionEntity : recyclableExecutionImpls) {
                if (executionEntity.isEnded()) continue;
                log.fine("pruning execution " + executionEntity);
                executionEntity.remove();
            }
            log.fine("activating the concurrent root " + concurrentRoot + " as the single path of execution going forward");
            concurrentRoot.setActive(true);
            concurrentRoot.setActivity(this.activity);
            concurrentRoot.setConcurrent(false);
            concurrentRoot.take(transitions.get(0));
        } else {
            ArrayList<OutgoingExecution> outgoingExecutions = new ArrayList<OutgoingExecution>();
            recyclableExecutions.remove(concurrentRoot);
            log.fine("recyclable executions for reuse: " + recyclableExecutions);
            while (!transitions.isEmpty()) {
                void var8_9;
                PvmTransition outgoingTransition = transitions.remove(0);
                Object var8_10 = null;
                if (recyclableExecutions.isEmpty()) {
                    ExecutionEntity executionEntity = concurrentRoot.createExecution();
                    log.fine("new " + executionEntity + " with parent " + executionEntity.getParent() + " created to take transition " + outgoingTransition);
                } else {
                    ExecutionEntity executionEntity = (ExecutionEntity)recyclableExecutions.remove(0);
                    log.fine("recycled " + executionEntity + " to take transition " + outgoingTransition);
                }
                var8_9.setActive(true);
                var8_9.setScope(false);
                var8_9.setConcurrent(true);
                var8_9.setTransitionBeingTaken((TransitionImpl)outgoingTransition);
                outgoingExecutions.add(new OutgoingExecution((InterpretableExecution)var8_9, outgoingTransition, true));
            }
            for (ActivityExecution activityExecution : recyclableExecutions) {
                log.fine("pruning execution " + activityExecution);
                activityExecution.end();
            }
            for (OutgoingExecution outgoingExecution : outgoingExecutions) {
                outgoingExecution.take();
            }
        }
    }

    protected boolean allExecutionsInSameActivity(List<ExecutionEntity> executions) {
        if (executions.size() > 1) {
            String activityId = executions.get(0).getActivityId();
            for (ExecutionEntity execution : executions) {
                String otherActivityId = execution.getActivityId();
                if (execution.isEnded || !(activityId == null && otherActivityId != null || activityId != null && otherActivityId == null) && (activityId == null || otherActivityId == null || otherActivityId.equals(activityId))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void performOperation(AtomicOperation executionOperation) {
        if (executionOperation.isAsync(this)) {
            this.scheduleAtomicOperationAsync(executionOperation);
        } else {
            this.performOperationSync(executionOperation);
        }
    }

    protected void performOperationSync(AtomicOperation executionOperation) {
        Context.getCommandContext().performOperation(executionOperation, this);
    }

    protected void scheduleAtomicOperationAsync(AtomicOperation executionOperation) {
        MessageEntity message = new MessageEntity();
        message.setExecution(this);
        message.setExclusive(this.getActivity().isExclusive());
        message.setJobHandlerType("async-continuation");
        Context.getCommandContext().getJobManager().send(message);
    }

    public boolean isActive(String activityId) {
        return this.findExecution(activityId) != null;
    }

    @Override
    public void inactivate() {
        this.isActive = false;
    }

    public List<ExecutionEntity> getExecutions() {
        this.ensureExecutionsInitialized();
        return this.executions;
    }

    protected void ensureExecutionsInitialized() {
        if (this.executions == null) {
            this.executions = Context.getCommandContext().getExecutionManager().findChildExecutionsByParentExecutionId(this.id);
        }
    }

    public void setExecutions(List<ExecutionEntity> executions) {
        this.executions = executions;
    }

    @Override
    public ExecutionEntity findExecution(String activityId) {
        if (this.getActivity() != null && this.getActivity().getId().equals(activityId)) {
            return this;
        }
        for (ExecutionEntity nestedExecution : this.getExecutions()) {
            ExecutionEntity result = nestedExecution.findExecution(activityId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public List<String> findActiveActivityIds() {
        ArrayList<String> activeActivityIds = new ArrayList<String>();
        this.collectActiveActivityIds(activeActivityIds);
        return activeActivityIds;
    }

    protected void collectActiveActivityIds(List<String> activeActivityIds) {
        this.ensureActivityInitialized();
        if (this.isActive && this.activity != null) {
            activeActivityIds.add(this.activity.getId());
        }
        this.ensureExecutionsInitialized();
        for (ExecutionEntity execution : this.executions) {
            execution.collectActiveActivityIds(activeActivityIds);
        }
    }

    @Override
    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    @Override
    public String getProcessBusinessKey() {
        return this.getProcessInstance().getBusinessKey();
    }

    @Override
    public ProcessDefinitionImpl getProcessDefinition() {
        this.ensureProcessDefinitionInitialized();
        return this.processDefinition;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    protected void ensureProcessDefinitionInitialized() {
        if (this.processDefinition == null && this.processDefinitionId != null) {
            ProcessDefinitionEntity deployedProcessDefinition = Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedProcessDefinitionById(this.processDefinitionId);
            this.setProcessDefinition(deployedProcessDefinition);
        }
    }

    @Override
    public void setProcessDefinition(ProcessDefinitionImpl processDefinition) {
        this.processDefinition = processDefinition;
        this.processDefinitionId = processDefinition.getId();
    }

    public ExecutionEntity getProcessInstance() {
        this.ensureProcessInstanceInitialized();
        return this.processInstance;
    }

    protected void ensureProcessInstanceInitialized() {
        if (this.processInstance == null && this.processInstanceId != null) {
            this.processInstance = Context.getCommandContext().getExecutionManager().findExecutionById(this.processInstanceId);
        }
    }

    @Override
    public void setProcessInstance(InterpretableExecution processInstance) {
        this.processInstance = (ExecutionEntity)processInstance;
        if (processInstance != null) {
            this.processInstanceId = this.processInstance.getId();
        }
    }

    @Override
    public boolean isProcessInstance() {
        return this.parentId == null;
    }

    @Override
    public ActivityImpl getActivity() {
        this.ensureActivityInitialized();
        return this.activity;
    }

    protected void ensureActivityInitialized() {
        if (this.activity == null && this.activityId != null) {
            this.activity = this.getProcessDefinition().findActivity(this.activityId);
        }
    }

    @Override
    public void setActivity(ActivityImpl activity) {
        this.activity = activity;
        this.activityId = activity != null ? activity.getId() : null;
    }

    @Override
    public ExecutionEntity getParent() {
        this.ensureParentInitialized();
        return this.parent;
    }

    protected void ensureParentInitialized() {
        if (this.parent == null && this.parentId != null) {
            this.parent = Context.getCommandContext().getExecutionManager().findExecutionById(this.parentId);
        }
    }

    @Override
    public void setParent(InterpretableExecution parent) {
        this.parent = (ExecutionEntity)parent;
        this.parentId = parent != null ? ((ExecutionEntity)parent).getId() : null;
    }

    public String getSuperExecutionId() {
        return this.superExecutionId;
    }

    @Override
    public ExecutionEntity getSuperExecution() {
        this.ensureSuperExecutionInitialized();
        return this.superExecution;
    }

    public void setSuperExecution(ExecutionEntity superExecution) {
        this.superExecution = superExecution;
        if (superExecution != null) {
            superExecution.setSubProcessInstance(null);
        }
        this.superExecutionId = superExecution != null ? superExecution.getId() : null;
    }

    protected void ensureSuperExecutionInitialized() {
        if (this.superExecution == null && this.superExecutionId != null) {
            this.superExecution = Context.getCommandContext().getExecutionManager().findExecutionById(this.superExecutionId);
        }
    }

    @Override
    public ExecutionEntity getSubProcessInstance() {
        this.ensureSubProcessInstanceInitialized();
        return this.subProcessInstance;
    }

    @Override
    public void setSubProcessInstance(InterpretableExecution subProcessInstance) {
        this.subProcessInstance = (ExecutionEntity)subProcessInstance;
    }

    protected void ensureSubProcessInstanceInitialized() {
        if (this.subProcessInstance == null) {
            this.subProcessInstance = Context.getCommandContext().getExecutionManager().findSubProcessInstanceBySuperExecutionId(this.id);
        }
    }

    protected ScopeImpl getScope() {
        ScopeImpl scope = null;
        scope = this.isProcessInstance() ? this.getProcessDefinition() : this.getActivity();
        return scope;
    }

    @Override
    public boolean isScope() {
        return this.isScope;
    }

    @Override
    public void setScope(boolean isScope) {
        this.isScope = isScope;
    }

    @Override
    public void remove() {
        this.ensureParentInitialized();
        if (this.parent != null) {
            this.parent.ensureExecutionsInitialized();
            this.parent.executions.remove(this);
        }
        this.ensureVariableInstancesInitialized();
        this.removeVariablesLocal();
        CommandContext commandContext = Context.getCommandContext();
        List tasks = new TaskQueryImpl(commandContext).executionId(this.id).list();
        for (TaskEntity task : tasks) {
            if (this.replacedBy != null) {
                task.setExecution(this.replacedBy);
                continue;
            }
            commandContext.getTaskManager().deleteTask(task, "deleted", false);
        }
        List jobs = new JobQueryImpl(commandContext).executionId(this.id).list();
        for (Job job : jobs) {
            if (this.replacedBy != null) {
                ((JobEntity)job).setExecution(this.replacedBy);
                continue;
            }
            ((JobEntity)job).delete();
        }
        List<SignalEventSubscriptionEntity> eventSubscriptions = commandContext.getEventSubscriptionManager().findSignalEventSubscriptionsByExecution(this.id);
        for (SignalEventSubscriptionEntity eventSubscription : eventSubscriptions) {
            if (this.replacedBy != null) {
                eventSubscription.setExecution(this.replacedBy);
                continue;
            }
            eventSubscription.delete();
        }
        for (CompensateEventSubscriptionEntity compensateEventSubscription : this.getCompensateEventSubscriptions()) {
            if (this.replacedBy != null) {
                compensateEventSubscription.setExecution(this.replacedBy);
                continue;
            }
            this.removeCompensateEventSubscription(compensateEventSubscription);
            compensateEventSubscription.delete();
        }
        ArrayList<ExecutionEntity> childExecutions = new ArrayList<ExecutionEntity>(this.getExecutions());
        for (InterpretableExecution interpretableExecution : childExecutions) {
            if (!interpretableExecution.isEventScope()) continue;
            log.fine("removing eventScope " + interpretableExecution);
            interpretableExecution.destroy();
            interpretableExecution.remove();
        }
        commandContext.getDbSqlSession().delete(ExecutionEntity.class, this.id);
    }

    @Override
    public ExecutionEntity getReplacedBy() {
        return this.replacedBy;
    }

    @Override
    public void setReplacedBy(InterpretableExecution replacedBy) {
        this.replacedBy = (ExecutionEntity)replacedBy;
        CommandContext commandContext = Context.getCommandContext();
        DbSqlSession dbSqlSession = commandContext.getDbSqlSession();
        List<Object> tasks = new TaskQueryImpl(commandContext).executionId(this.id).list();
        for (TaskEntity taskEntity : tasks) {
            taskEntity.setExecutionId(replacedBy.getId());
        }
        tasks = dbSqlSession.findInCache(TaskEntity.class);
        for (TaskEntity taskEntity : tasks) {
            if (!this.id.equals(taskEntity.getExecutionId())) continue;
            taskEntity.setExecutionId(replacedBy.getId());
        }
        List<Object> jobs = new JobQueryImpl(commandContext).executionId(this.id).list();
        for (JobEntity jobEntity : jobs) {
            jobEntity.setExecutionId(replacedBy.getId());
        }
        jobs = dbSqlSession.findInCache(JobEntity.class);
        for (JobEntity jobEntity : jobs) {
            if (!this.id.equals(jobEntity.getExecutionId())) continue;
            jobEntity.setExecutionId(replacedBy.getId());
        }
        List list = new EventSubscriptionQueryImpl(commandContext).executionId(this.id).list();
        for (EventSubscriptionEntity eventSubscriptionEntity : list) {
            eventSubscriptionEntity.setExecutionId(replacedBy.getId());
        }
        List<EventSubscriptionEntity> list2 = dbSqlSession.findInCache(EventSubscriptionEntity.class);
        for (EventSubscriptionEntity eventSubscriptionEntity : list2) {
            if (!this.id.equals(eventSubscriptionEntity.getExecutionId())) continue;
            eventSubscriptionEntity.setExecutionId(replacedBy.getId());
        }
        List<VariableInstanceEntity> list3 = commandContext.getVariableInstanceManager().findVariableInstancesByExecutionId(this.id);
        for (VariableInstanceEntity variable : list3) {
            variable.setExecutionId(replacedBy.getId());
        }
        List<VariableInstanceEntity> list4 = dbSqlSession.findInCache(VariableInstanceEntity.class);
        for (VariableInstanceEntity variable : list4) {
            if (!this.id.equals(variable.getExecutionId())) continue;
            variable.setExecutionId(replacedBy.getId());
        }
        List<HistoricActivityInstanceEntity> list5 = dbSqlSession.findInCache(HistoricActivityInstanceEntity.class);
        for (HistoricActivityInstanceEntity cachedHistoricActivityInstance : list5) {
            if (cachedHistoricActivityInstance.getEndTime() != null || !this.id.equals(cachedHistoricActivityInstance.getExecutionId())) continue;
            cachedHistoricActivityInstance.setExecutionId(replacedBy.getId());
        }
        if (Context.getProcessEngineConfiguration().getHistoryLevel() > 0) {
            List historicActivityInstances = new HistoricActivityInstanceQueryImpl(commandContext).executionId(this.id).unfinished().list();
            for (HistoricActivityInstanceEntity historicActivityInstance : historicActivityInstances) {
                historicActivityInstance.setExecutionId(replacedBy.getId());
            }
        }
    }

    @Override
    protected void initializeVariableInstanceBackPointer(VariableInstanceEntity variableInstance) {
        variableInstance.setProcessInstanceId(this.processInstanceId);
        variableInstance.setExecutionId(this.id);
    }

    @Override
    protected List<VariableInstanceEntity> loadVariableInstances() {
        return Context.getCommandContext().getVariableInstanceManager().findVariableInstancesByExecutionId(this.id);
    }

    @Override
    protected VariableScopeImpl getParentVariableScope() {
        return this.getParent();
    }

    @Override
    protected void initializeActivityInstanceId(HistoricVariableUpdateEntity historicVariableUpdate) {
        HistoricActivityInstanceEntity historicActivityInstance;
        int historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        if (historyLevel >= 3 && (historicActivityInstance = ActivityInstanceEndHandler.findActivityInstance(this)) != null) {
            historicVariableUpdate.setActivityInstanceId(historicActivityInstance.getId());
        }
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("processDefinitionId", this.processDefinitionId);
        persistentState.put("businessKey", this.businessKey);
        persistentState.put("activityId", this.activityId);
        persistentState.put("isActive", this.isActive);
        persistentState.put("isConcurrent", this.isConcurrent);
        persistentState.put("isScope", this.isScope);
        persistentState.put("isEventScope", this.isEventScope);
        persistentState.put("parentId", this.parentId);
        persistentState.put("superExecution", this.superExecutionId);
        if (this.forcedUpdate) {
            persistentState.put("forcedUpdate", Boolean.TRUE);
        }
        persistentState.put("suspensionState", this.suspensionState);
        return persistentState;
    }

    public void insert() {
        Context.getCommandContext().getDbSqlSession().insert(this);
    }

    @Override
    public void deleteCascade(String deleteReason) {
        this.deleteReason = deleteReason;
        this.deleteRoot = true;
        this.performOperation(AtomicOperation.DELETE_CASCADE);
    }

    public int getRevisionNext() {
        return this.revision + 1;
    }

    public void forceUpdate() {
        this.forcedUpdate = true;
    }

    public String toString() {
        if (this.isProcessInstance()) {
            return "ProcessInstance[" + this.getToStringIdentity() + "]";
        }
        return (this.isConcurrent ? "Concurrent" : "") + (this.isScope ? "Scope" : "") + "Execution[" + this.getToStringIdentity() + "]";
    }

    protected String getToStringIdentity() {
        return this.id;
    }

    public List<CompensateEventSubscriptionEntity> getCompensateEventSubscriptions(String activityId) {
        this.ensureCompensateEventSubscriptionsInitialized();
        ArrayList<CompensateEventSubscriptionEntity> result = new ArrayList<CompensateEventSubscriptionEntity>();
        for (CompensateEventSubscriptionEntity eventSubscriptionEntity : this.compensateEventSubscriptions) {
            if (!eventSubscriptionEntity.getActivityId().equals(activityId)) continue;
            result.add(eventSubscriptionEntity);
        }
        return result;
    }

    public List<CompensateEventSubscriptionEntity> getCompensateEventSubscriptions() {
        this.ensureCompensateEventSubscriptionsInitialized();
        return new ArrayList<CompensateEventSubscriptionEntity>(this.compensateEventSubscriptions);
    }

    protected void ensureCompensateEventSubscriptionsInitialized() {
        if (this.compensateEventSubscriptions == null) {
            this.compensateEventSubscriptions = Context.getCommandContext().getEventSubscriptionManager().findEventSubscriptions(this.id, "compensate");
        }
    }

    public void addCompensateEventSubscription(CompensateEventSubscriptionEntity eventSubscriptionEntity) {
        this.ensureCompensateEventSubscriptionsInitialized();
        this.compensateEventSubscriptions.add(eventSubscriptionEntity);
    }

    public void removeCompensateEventSubscription(CompensateEventSubscriptionEntity eventSubscriptionEntity) {
        this.ensureCompensateEventSubscriptionsInitialized();
        this.compensateEventSubscriptions.remove(eventSubscriptionEntity);
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    public String getActivityId() {
        return this.activityId;
    }

    @Override
    public TransitionImpl getTransition() {
        return this.transition;
    }

    @Override
    public void setTransition(TransitionImpl transition) {
        this.transition = transition;
    }

    public TransitionImpl getTransitionBeingTaken() {
        return this.transitionBeingTaken;
    }

    public void setTransitionBeingTaken(TransitionImpl transitionBeingTaken) {
        this.transitionBeingTaken = transitionBeingTaken;
    }

    @Override
    public Integer getExecutionListenerIndex() {
        return this.executionListenerIndex;
    }

    @Override
    public void setExecutionListenerIndex(Integer executionListenerIndex) {
        this.executionListenerIndex = executionListenerIndex;
    }

    @Override
    public boolean isConcurrent() {
        return this.isConcurrent;
    }

    @Override
    public void setConcurrent(boolean isConcurrent) {
        this.isConcurrent = isConcurrent;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public boolean isEnded() {
        return this.isEnded;
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    @Override
    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    @Override
    public PvmProcessElement getEventSource() {
        return this.eventSource;
    }

    @Override
    public void setEventSource(PvmProcessElement eventSource) {
        this.eventSource = eventSource;
    }

    @Override
    public String getDeleteReason() {
        return this.deleteReason;
    }

    public void setDeleteReason(String deleteReason) {
        this.deleteReason = deleteReason;
    }

    @Override
    public boolean isDeleteRoot() {
        return this.deleteRoot;
    }

    public int getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(int suspensionState) {
        this.suspensionState = suspensionState;
    }

    @Override
    public boolean isSuspended() {
        return this.suspensionState == SuspensionState.SUSPENDED.getStateCode();
    }

    @Override
    public boolean isEventScope() {
        return this.isEventScope;
    }

    @Override
    public void setEventScope(boolean isEventScope) {
        this.isEventScope = isEventScope;
    }

    @Override
    public StartingExecution getStartingExecution() {
        return this.startingExecution;
    }

    @Override
    public void disposeStartingExecution() {
        this.startingExecution = null;
    }
}

