/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.juel;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ELException;
import org.activiti.engine.impl.juel.AstNode;
import org.activiti.engine.impl.juel.AstParameters;
import org.activiti.engine.impl.juel.AstRightValue;
import org.activiti.engine.impl.juel.Bindings;
import org.activiti.engine.impl.juel.FunctionNode;
import org.activiti.engine.impl.juel.LocalMessages;

public class AstFunction
extends AstRightValue
implements FunctionNode {
    private final int index;
    private final String name;
    private final AstParameters params;
    private final boolean varargs;

    public AstFunction(String name, int index, AstParameters params) {
        this(name, index, params, false);
    }

    public AstFunction(String name, int index, AstParameters params, boolean varargs) {
        this.name = name;
        this.index = index;
        this.params = params;
        this.varargs = varargs;
    }

    protected Object invoke(Bindings bindings, ELContext context, Object base, Method method) throws InvocationTargetException, IllegalAccessException {
        Object[] params;
        block11: {
            Class<?>[] types;
            block12: {
                types = method.getParameterTypes();
                params = null;
                if (types.length <= 0) break block11;
                params = new Object[types.length];
                if (!this.varargs || !method.isVarArgs()) break block12;
                for (int i = 0; i < params.length - 1; ++i) {
                    Object param = this.getParam(i).eval(bindings, context);
                    if (param == null && !types[i].isPrimitive()) continue;
                    params[i] = bindings.convert(param, types[i]);
                }
                int varargIndex = types.length - 1;
                Class<?> varargType = types[varargIndex].getComponentType();
                int length = this.getParamCount() - varargIndex;
                Object array = null;
                if (length == 1) {
                    Object param = this.getParam(varargIndex).eval(bindings, context);
                    if (param != null && param.getClass().isArray()) {
                        if (types[varargIndex].isInstance(param)) {
                            array = param;
                        } else {
                            length = Array.getLength(param);
                            array = Array.newInstance(varargType, length);
                            for (int i = 0; i < length; ++i) {
                                Object elem = Array.get(param, i);
                                if (elem == null && !varargType.isPrimitive()) continue;
                                Array.set(array, i, bindings.convert(elem, varargType));
                            }
                        }
                    } else {
                        array = Array.newInstance(varargType, 1);
                        if (param != null || varargType.isPrimitive()) {
                            Array.set(array, 0, bindings.convert(param, varargType));
                        }
                    }
                } else {
                    array = Array.newInstance(varargType, length);
                    for (int i = 0; i < length; ++i) {
                        Object param = this.getParam(varargIndex + i).eval(bindings, context);
                        if (param == null && !varargType.isPrimitive()) continue;
                        Array.set(array, i, bindings.convert(param, varargType));
                    }
                }
                params[varargIndex] = array;
                break block11;
            }
            for (int i = 0; i < params.length; ++i) {
                Object param = this.getParam(i).eval(bindings, context);
                if (param == null && !types[i].isPrimitive()) continue;
                params[i] = bindings.convert(param, types[i]);
            }
        }
        return method.invoke(base, params);
    }

    public Object eval(Bindings bindings, ELContext context) {
        Method method = bindings.getFunction(this.index);
        try {
            return this.invoke(bindings, context, null, method);
        }
        catch (IllegalAccessException e) {
            throw new ELException(LocalMessages.get("error.function.access", this.name), e);
        }
        catch (InvocationTargetException e) {
            throw new ELException(LocalMessages.get("error.function.invocation", this.name), e.getCause());
        }
    }

    public String toString() {
        return this.name;
    }

    public void appendStructure(StringBuilder b, Bindings bindings) {
        b.append(bindings != null && bindings.isFunctionBound(this.index) ? "<fn>" : this.name);
        this.params.appendStructure(b, bindings);
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public boolean isVarArgs() {
        return this.varargs;
    }

    public int getParamCount() {
        return this.params.getCardinality();
    }

    protected AstNode getParam(int i) {
        return this.params.getChild(i);
    }

    public int getCardinality() {
        return 1;
    }

    public AstNode getChild(int i) {
        return i == 0 ? this.params : null;
    }
}

