/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collection;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteTaskCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected Collection<String> taskIds;
    protected boolean cascade;

    public DeleteTaskCmd(String taskId, boolean cascade) {
        this.taskId = taskId;
        this.cascade = cascade;
    }

    public DeleteTaskCmd(Collection<String> taskIds, boolean cascade) {
        this.taskIds = taskIds;
        this.cascade = cascade;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.taskId != null) {
            this.deleteTask(this.taskId);
        } else if (this.taskIds != null) {
            for (String taskId : this.taskIds) {
                this.deleteTask(taskId);
            }
        } else {
            throw new ActivitiException("taskId and taskIds are null");
        }
        return null;
    }

    protected void deleteTask(String taskId) {
        Context.getCommandContext().getTaskManager().deleteTask(taskId, this.cascade);
    }
}

