/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.activiti.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;

public class BoundaryEventActivityBehavior
extends FlowNodeActivityBehavior {
    private static Logger log = Logger.getLogger(BoundaryEventActivityBehavior.class.getName());
    protected boolean interrupting;

    public BoundaryEventActivityBehavior() {
    }

    public BoundaryEventActivityBehavior(boolean interrupting) {
        this.interrupting = interrupting;
    }

    public void execute(ActivityExecution execution) throws Exception {
        List<PvmTransition> outgoingTransitions = execution.getActivity().getOutgoingTransitions();
        ArrayList<ActivityExecution> interruptedExecutions = null;
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        if (this.interrupting) {
            if (executionEntity.getSubProcessInstance() != null) {
                executionEntity.getSubProcessInstance().deleteCascade(executionEntity.getDeleteReason());
            }
            interruptedExecutions = new ArrayList<ActivityExecution>(executionEntity.getExecutions());
            for (ExecutionEntity executionEntity2 : interruptedExecutions) {
                executionEntity2.deleteCascade("interrupting boundary event '" + execution.getActivity().getId() + "' fired");
            }
            execution.takeAll(outgoingTransitions, interruptedExecutions);
        } else {
            ExecutionEntity concurrentRoot = execution.isConcurrent() && !execution.isScope() ? executionEntity.getParent() : executionEntity;
            ExecutionEntity executionEntity3 = concurrentRoot.createExecution();
            log.fine("new " + executionEntity3 + " created in non interrupting boundary event '" + execution.getActivity().getId() + "'");
            executionEntity3.setActive(true);
            executionEntity3.setScope(false);
            executionEntity3.setConcurrent(true);
            executionEntity3.takeAll(outgoingTransitions, new ArrayList<ActivityExecution>());
            executionEntity.setActivity(executionEntity.getActivity().getParentActivity());
        }
    }

    public boolean isInterrupting() {
        return this.interrupting;
    }

    public void setInterrupting(boolean interrupting) {
        this.interrupting = interrupting;
    }
}

