/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.identity.Group;
import org.activiti.engine.impl.AbstractQuery;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.QueryOperator;
import org.activiti.engine.impl.TaskQueryProperty;
import org.activiti.engine.impl.TaskQueryVariableValue;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.variable.VariableTypes;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskQueryImpl
extends AbstractQuery<TaskQuery, Task>
implements TaskQuery {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String name;
    protected String nameLike;
    protected String description;
    protected String descriptionLike;
    protected Integer priority;
    protected Integer minPriority;
    protected Integer maxPriority;
    protected String assignee;
    protected String involvedUser;
    protected String owner;
    protected boolean unassigned = false;
    protected String candidateUser;
    protected String candidateGroup;
    private List<String> candidateGroups;
    protected String processInstanceId;
    protected String executionId;
    protected Date createTime;
    protected Date createTimeBefore;
    protected Date createTimeAfter;
    protected String key;
    protected String keyLike;
    protected String processDefinitionKey;
    protected String processDefinitionId;
    protected String processDefinitionName;
    protected String processInstanceBusinessKey;
    protected List<TaskQueryVariableValue> variables = new ArrayList<TaskQueryVariableValue>();
    protected Date dueDate;
    protected Date dueBefore;
    protected Date dueAfter;

    public TaskQueryImpl() {
    }

    public TaskQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public TaskQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public TaskQueryImpl taskId(String taskId) {
        if (taskId == null) {
            throw new ActivitiException("Task id is null");
        }
        this.taskId = taskId;
        return this;
    }

    @Override
    public TaskQueryImpl taskName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public TaskQueryImpl taskNameLike(String nameLike) {
        if (nameLike == null) {
            throw new ActivitiException("Task namelike is null");
        }
        this.nameLike = nameLike;
        return this;
    }

    @Override
    public TaskQueryImpl taskDescription(String description) {
        if (description == null) {
            throw new ActivitiException("Description is null");
        }
        this.description = description;
        return this;
    }

    @Override
    public TaskQuery taskDescriptionLike(String descriptionLike) {
        if (descriptionLike == null) {
            throw new ActivitiException("Task descriptionlike is null");
        }
        this.descriptionLike = descriptionLike;
        return this;
    }

    @Override
    public TaskQuery taskPriority(Integer priority) {
        if (priority == null) {
            throw new ActivitiException("Priority is null");
        }
        this.priority = priority;
        return this;
    }

    @Override
    public TaskQuery taskMinPriority(Integer minPriority) {
        if (minPriority == null) {
            throw new ActivitiException("Min Priority is null");
        }
        this.minPriority = minPriority;
        return this;
    }

    @Override
    public TaskQuery taskMaxPriority(Integer maxPriority) {
        if (maxPriority == null) {
            throw new ActivitiException("Max Priority is null");
        }
        this.maxPriority = maxPriority;
        return this;
    }

    @Override
    public TaskQueryImpl taskAssignee(String assignee) {
        if (assignee == null) {
            throw new ActivitiException("Assignee is null");
        }
        this.assignee = assignee;
        return this;
    }

    @Override
    public TaskQueryImpl taskOwner(String owner) {
        if (owner == null) {
            throw new ActivitiException("Owner is null");
        }
        this.owner = owner;
        return this;
    }

    @Override
    public TaskQuery taskUnnassigned() {
        this.unassigned = true;
        return this;
    }

    @Override
    public TaskQueryImpl taskCandidateUser(String candidateUser) {
        if (candidateUser == null) {
            throw new ActivitiException("Candidate user is null");
        }
        if (this.candidateGroup != null) {
            throw new ActivitiException("Invalid query usage: cannot set both candidateUser and candidateGroup");
        }
        if (this.candidateGroups != null) {
            throw new ActivitiException("Invalid query usage: cannot set both candidateUser and candidateGroupIn");
        }
        this.candidateUser = candidateUser;
        return this;
    }

    @Override
    public TaskQueryImpl taskInvolvedUser(String involvedUser) {
        if (involvedUser == null) {
            throw new ActivitiException("Involved user is null");
        }
        this.involvedUser = involvedUser;
        return this;
    }

    @Override
    public TaskQueryImpl taskCandidateGroup(String candidateGroup) {
        if (candidateGroup == null) {
            throw new ActivitiException("Candidate group is null");
        }
        if (this.candidateUser != null) {
            throw new ActivitiException("Invalid query usage: cannot set both candidateGroup and candidateUser");
        }
        if (this.candidateGroups != null) {
            throw new ActivitiException("Invalid query usage: cannot set both candidateGroup and candidateGroupIn");
        }
        this.candidateGroup = candidateGroup;
        return this;
    }

    @Override
    public TaskQuery taskCandidateGroupIn(List<String> candidateGroups) {
        if (candidateGroups == null) {
            throw new ActivitiException("Candidate group list is null");
        }
        if (candidateGroups.size() == 0) {
            throw new ActivitiException("Candidate group list is empty");
        }
        if (this.candidateUser != null) {
            throw new ActivitiException("Invalid query usage: cannot set both candidateGroupIn and candidateUser");
        }
        if (this.candidateGroup != null) {
            throw new ActivitiException("Invalid query usage: cannot set both candidateGroupIn and candidateGroup");
        }
        this.candidateGroups = candidateGroups;
        return this;
    }

    @Override
    public TaskQueryImpl processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public TaskQueryImpl processInstanceBusinessKey(String processInstanceBusinessKey) {
        this.processInstanceBusinessKey = processInstanceBusinessKey;
        return this;
    }

    @Override
    public TaskQueryImpl executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Override
    public TaskQueryImpl taskCreatedOn(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    @Override
    public TaskQuery taskCreatedBefore(Date before) {
        this.createTimeBefore = before;
        return this;
    }

    @Override
    public TaskQuery taskCreatedAfter(Date after) {
        this.createTimeAfter = after;
        return this;
    }

    @Override
    public TaskQuery taskDefinitionKey(String key) {
        this.key = key;
        return this;
    }

    @Override
    public TaskQuery taskDefinitionKeyLike(String keyLike) {
        this.keyLike = keyLike;
        return this;
    }

    @Override
    public TaskQuery taskVariableValueEquals(String variableName, Object variableValue) {
        this.variables.add(new TaskQueryVariableValue(variableName, variableValue, QueryOperator.EQUALS, true));
        return this;
    }

    @Override
    public TaskQuery processVariableValueEquals(String variableName, Object variableValue) {
        this.variables.add(new TaskQueryVariableValue(variableName, variableValue, QueryOperator.EQUALS, false));
        return this;
    }

    @Override
    public TaskQuery processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public TaskQuery processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public TaskQuery processDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
        return this;
    }

    @Override
    public TaskQuery dueDate(Date dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    @Override
    public TaskQuery dueBefore(Date dueBefore) {
        this.dueBefore = dueBefore;
        return this;
    }

    @Override
    public TaskQuery dueAfter(Date dueAfter) {
        this.dueAfter = dueAfter;
        return this;
    }

    public List<String> getCandidateGroups() {
        if (this.candidateGroup != null) {
            return Collections.singletonList(this.candidateGroup);
        }
        if (this.candidateUser != null) {
            return this.getGroupsForCandidateUser(this.candidateUser);
        }
        if (this.candidateGroups != null) {
            return this.candidateGroups;
        }
        return null;
    }

    protected List<String> getGroupsForCandidateUser(String candidateUser) {
        List<Group> groups = Context.getCommandContext().getGroupManager().findGroupsByUser(candidateUser);
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Group group : groups) {
            groupIds.add(group.getId());
        }
        return groupIds;
    }

    protected void ensureVariablesInitialized() {
        VariableTypes types = Context.getProcessEngineConfiguration().getVariableTypes();
        for (TaskQueryVariableValue var : this.variables) {
            var.initialize(types);
        }
    }

    @Override
    public TaskQuery orderByTaskId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.TASK_ID);
    }

    @Override
    public TaskQuery orderByTaskName() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.NAME);
    }

    @Override
    public TaskQuery orderByTaskDescription() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.DESCRIPTION);
    }

    @Override
    public TaskQuery orderByTaskPriority() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.PRIORITY);
    }

    @Override
    public TaskQuery orderByProcessInstanceId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.PROCESS_INSTANCE_ID);
    }

    @Override
    public TaskQuery orderByExecutionId() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.EXECUTION_ID);
    }

    @Override
    public TaskQuery orderByTaskAssignee() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.ASSIGNEE);
    }

    @Override
    public TaskQuery orderByTaskCreateTime() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.CREATE_TIME);
    }

    @Override
    public TaskQuery orderByDueDate() {
        return (TaskQuery)this.orderBy(TaskQueryProperty.DUE_DATE);
    }

    @Override
    public List<Task> executeList(CommandContext commandContext, Page page) {
        this.ensureVariablesInitialized();
        this.checkQueryOk();
        return commandContext.getTaskManager().findTasksByQueryCriteria(this, page);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        this.checkQueryOk();
        return commandContext.getTaskManager().findTaskCountByQueryCriteria(this);
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public boolean getUnassigned() {
        return this.unassigned;
    }

    public String getCandidateUser() {
        return this.candidateUser;
    }

    public String getCandidateGroup() {
        return this.candidateGroup;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionLike() {
        return this.descriptionLike;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getCreateTimeBefore() {
        return this.createTimeBefore;
    }

    public Date getCreateTimeAfter() {
        return this.createTimeAfter;
    }

    public String getKey() {
        return this.key;
    }

    public String getKeyLike() {
        return this.keyLike;
    }

    public List<TaskQueryVariableValue> getVariables() {
        return this.variables;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public String getProcessInstanceBusinessKey() {
        return this.processInstanceBusinessKey;
    }
}

