/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl;

import java.io.Serializable;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.management.TablePage;
import org.activiti.engine.management.TablePageQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TablePageQueryImpl
implements TablePageQuery,
Command<TablePage>,
Serializable {
    private static final long serialVersionUID = 1L;
    transient CommandExecutor commandExecutor;
    protected String tableName;
    protected String orderBy;
    protected int firstResult;
    protected int maxResults;

    public TablePageQueryImpl() {
    }

    public TablePageQueryImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    @Override
    public TablePageQueryImpl tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    @Override
    public TablePageQueryImpl orderAsc(String column) {
        this.addOrder(column, "asc");
        return this;
    }

    @Override
    public TablePageQueryImpl orderDesc(String column) {
        this.addOrder(column, "desc");
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    protected void addOrder(String column, String sortOrder) {
        this.orderBy = this.orderBy == null ? "" : this.orderBy + ", ";
        this.orderBy = this.orderBy + column + " " + sortOrder;
    }

    @Override
    public TablePage listPage(int firstResult, int maxResults) {
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        return this.commandExecutor.execute(this);
    }

    @Override
    public TablePage execute(CommandContext commandContext) {
        return commandContext.getTableDataManager().getTablePage(this, this.firstResult, this.maxResults);
    }
}

