/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.task.api;

import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.task.api.ClusterStatusInformation;
import com.evolveum.midpoint.task.api.Node;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.task.api.TaskHandler;
import com.evolveum.midpoint.task.api.TaskManagerException;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.NodeType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.TaskType;
import com.evolveum.prism.xml.ns._public.query_2.QueryType;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public interface TaskManager {
    public Task createTaskInstance();

    public Task createTaskInstance(PrismObject<TaskType> var1, OperationResult var2) throws SchemaException;

    public Task createTaskInstance(String var1);

    public Task createTaskInstance(PrismObject<TaskType> var1, String var2, OperationResult var3) throws SchemaException;

    public Task getTask(String var1, OperationResult var2) throws ObjectNotFoundException, SchemaException;

    public String addTask(PrismObject<TaskType> var1, OperationResult var2) throws ObjectAlreadyExistsException, SchemaException;

    @Deprecated
    public void modifyTask(String var1, Collection<? extends ItemDelta> var2, OperationResult var3) throws ObjectNotFoundException, SchemaException;

    public void deleteTask(String var1, OperationResult var2) throws ObjectNotFoundException, SchemaException;

    public boolean suspendTask(Task var1, long var2, OperationResult var4);

    public void resumeTask(Task var1, OperationResult var2) throws ObjectNotFoundException, SchemaException;

    public void switchToBackground(Task var1, OperationResult var2);

    public List<Task> searchTasks(QueryType var1, PagingType var2, ClusterStatusInformation var3, OperationResult var4) throws SchemaException;

    public int countTasks(QueryType var1, OperationResult var2) throws SchemaException;

    public List<Node> searchNodes(QueryType var1, PagingType var2, ClusterStatusInformation var3, OperationResult var4) throws SchemaException;

    public int countNodes(QueryType var1, OperationResult var2) throws SchemaException;

    public void registerHandler(String var1, TaskHandler var2);

    public void shutdown();

    @Deprecated
    public Set<Task> getRunningTasks() throws TaskManagerException;

    public boolean deactivateServiceThreads(long var1, OperationResult var3);

    public void reactivateServiceThreads(OperationResult var1);

    public boolean getServiceThreadsActivationState();

    public void stopScheduler(String var1, OperationResult var2);

    public void startScheduler(String var1, OperationResult var2);

    public void onTaskCreate(String var1, OperationResult var2);

    public void onTaskDelete(String var1, OperationResult var2);

    public Long getNextRunStartTime(String var1, OperationResult var2);

    public ClusterStatusInformation getRunningTasksClusterwide(OperationResult var1);

    public String getNodeId();

    public boolean isCurrentNode(PrismObject<NodeType> var1);

    public List<String> getAllTaskCategories();

    public void postInit(OperationResult var1);

    public boolean suspendTasks(Collection<Task> var1, long var2, OperationResult var4);

    public boolean suspendTasks(Collection<Task> var1, long var2, boolean var4, OperationResult var5);

    public ClusterStatusInformation getRunningTasksClusterwide(long var1, OperationResult var3);

    public boolean stopSchedulersAndTasks(List<String> var1, long var2, OperationResult var4);

    public void synchronizeTasks(OperationResult var1);

    public void deleteNode(String var1, OperationResult var2);

    public void scheduleTaskNow(Task var1, OperationResult var2);

    public String getHandlerUriForCategory(String var1);

    public ParseException validateCronExpression(String var1);
}

