/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.wicket.util.lang.Args;

public abstract class Response {
    public abstract void write(CharSequence var1);

    public abstract void write(byte[] var1);

    public void write(byte[] array, int offset, int length) {
        byte[] towrite = new byte[length];
        System.arraycopy(array, offset, towrite, 0, length);
        this.write(towrite);
    }

    public void close() {
    }

    public abstract String encodeURL(CharSequence var1);

    public void reset() {
    }

    public abstract Object getContainerResponse();

    public OutputStream getOutputStream() {
        return new StreamAdapter(this);
    }

    private static class StreamAdapter
    extends OutputStream {
        private final Response response;

        public StreamAdapter(Response response) {
            Args.notNull((Object)response, (String)"response");
            this.response = response;
        }

        public void write(int b) throws IOException {
            this.response.write(new byte[]{(byte)b});
        }

        public void write(byte[] b) throws IOException {
            this.response.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.response.write(b, off, len);
        }

        public void close() throws IOException {
            super.close();
            this.response.close();
        }
    }
}

