/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.query;

import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismReferenceValue;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.PropertyPathSegment;
import com.evolveum.midpoint.prism.dom.PrismDomProcessor;
import com.evolveum.midpoint.repo.sql.data.common.RAnyConverter;
import com.evolveum.midpoint.repo.sql.query.AttributeDefinition;
import com.evolveum.midpoint.repo.sql.query.Definition;
import com.evolveum.midpoint.repo.sql.query.EntityDefinition;
import com.evolveum.midpoint.repo.sql.query.Op;
import com.evolveum.midpoint.repo.sql.query.QueryException;
import com.evolveum.midpoint.repo.sql.query.QueryInterpreter;
import com.evolveum.midpoint.repo.sql.query.QueryRegistry;
import com.evolveum.midpoint.repo.sql.type.QNameType;
import com.evolveum.midpoint.repo.sql.util.ClassMapper;
import com.evolveum.midpoint.schema.SchemaConstantsGenerated;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimpleOp
extends Op {
    private static final Trace LOGGER = TraceManager.getTrace(SimpleOp.class);

    public SimpleOp(QueryInterpreter interpreter) {
        super(interpreter);
    }

    @Override
    protected QName[] canHandle() {
        return new QName[]{SchemaConstantsGenerated.Q_EQUAL, SchemaConstantsGenerated.Q_SUBSTRING};
    }

    private Operation getOperationType(Element filterPart) throws QueryException {
        if (DOMUtil.isElementName((Element)filterPart, (QName)SchemaConstantsGenerated.Q_EQUAL)) {
            return Operation.EQUAL;
        }
        if (DOMUtil.isElementName((Element)filterPart, (QName)SchemaConstantsGenerated.Q_SUBSTRING)) {
            return Operation.SUBSTRING;
        }
        throw new QueryException("Unknown filter type '" + DOMUtil.getQNameWithoutPrefix((Node)filterPart) + "'.");
    }

    @Override
    public Criterion interpret(Element filter, boolean pushNot) throws QueryException {
        Element value;
        LOGGER.debug("Interpreting '{}', pushNot '{}'", new Object[]{DOMUtil.getQNameWithoutPrefix((Node)filter), pushNot});
        this.validate(filter);
        Element path = DOMUtil.getChildElement((Element)filter, (QName)SchemaConstantsGenerated.Q_PATH);
        PropertyPath propertyPath = this.getInterpreter().createPropertyPath(path);
        if (path != null) {
            this.updateQueryContext(propertyPath);
        }
        if ((value = DOMUtil.getChildElement((Element)filter, (QName)SchemaConstantsGenerated.Q_VALUE)) == null || DOMUtil.listChildElements((Node)value).isEmpty()) {
            throw new QueryException("Equal without value element, or without element in <value> not supported now.");
        }
        Element condition = (Element)DOMUtil.listChildElements((Node)value).get(0);
        SimpleItem conditionItem = this.updateConditionItem(condition, path);
        LOGGER.trace("Condition item updated, updating value type.");
        Criterion criterion = null;
        if (!conditionItem.isReference) {
            try {
                Object testedValue = null;
                if (!conditionItem.isEnum) {
                    QName condQName = DOMUtil.getQNameWithoutPrefix((Node)condition);
                    testedValue = RAnyConverter.getRealRepoValue(this.getInterpreter().findDefinition(path, condQName), condition);
                } else {
                    Class<?> type = conditionItem.enumType;
                    if (type == null || !type.isEnum()) {
                        throw new IllegalStateException("Type '" + type + "' was marked as enum but it is not enum.");
                    }
                    ?[] objArray = type.getEnumConstants();
                    int n = objArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objArray[n2];
                        Enum e = (Enum)obj;
                        if (e.name().equals(condition.getTextContent())) {
                            testedValue = e;
                            break;
                        }
                        ++n2;
                    }
                }
                LOGGER.trace("Value updated to type '{}'", new Object[]{testedValue == null ? null : testedValue.getClass().getName()});
                criterion = this.createBaseCriteria(filter, pushNot, conditionItem.getQueryableItem(), testedValue);
            }
            catch (SchemaException ex) {
                throw new QueryException(ex.getMessage(), ex);
            }
        }
        if (conditionItem.isAny) {
            criterion = this.interpretAny(condition, conditionItem, path, criterion);
        } else if (conditionItem.isReference) {
            criterion = this.interpretReference(condition, conditionItem, filter, pushNot);
        }
        return criterion;
    }

    private Criterion createBaseCriteria(Element filter, boolean pushNot, String name, Object testedValue) throws QueryException {
        Operation operation = this.getOperationType(filter);
        switch (operation) {
            case EQUAL: {
                if (pushNot) {
                    return Restrictions.ne((String)name, (Object)testedValue);
                }
                return Restrictions.eq((String)name, (Object)testedValue);
            }
            case SUBSTRING: {
                if (pushNot) {
                    return Restrictions.not((Criterion)Restrictions.like((String)name, (Object)("%" + testedValue + "%")));
                }
                return Restrictions.like((String)name, (Object)("%" + testedValue + "%"));
            }
        }
        throw new IllegalStateException("Couldn't create base criteria for filter '" + DOMUtil.getQNameWithoutPrefix((Node)filter) + "' and pushNot '" + pushNot + "'.");
    }

    private Criterion interpretAny(Element condition, SimpleItem conditionItem, Element path, Criterion baseCriterion) throws QueryException {
        QName type;
        QName name;
        LOGGER.trace("Condition is type of any, creating conjunction for value and QName name, type");
        QName condQName = DOMUtil.getQNameWithoutPrefix((Node)condition);
        ItemDefinition itemDefinition = this.getInterpreter().findDefinition(path, condQName);
        if (itemDefinition == null) {
            name = condQName;
            type = DOMUtil.resolveXsiType((Element)condition);
        } else {
            name = itemDefinition.getName();
            type = itemDefinition.getTypeName();
        }
        if (name == null || type == null) {
            throw new QueryException("Couldn't get name or type for queried item '" + condQName + "'");
        }
        Conjunction conjunction = Restrictions.conjunction();
        conjunction.add(baseCriterion);
        conjunction.add((Criterion)Restrictions.eq((String)(String.valueOf(conditionItem.alias) + ".name"), (Object)QNameType.optimizeQName(name)));
        conjunction.add((Criterion)Restrictions.eq((String)(String.valueOf(conditionItem.alias) + ".type"), (Object)QNameType.optimizeQName(type)));
        return conjunction;
    }

    private Criterion interpretReference(Element condition, SimpleItem conditionItem, Element filter, boolean pushNot) throws QueryException {
        String targetOid = condition.getAttribute("oid");
        if (StringUtils.isEmpty((String)targetOid)) {
            throw new QueryException("Couldn't find target oid in reference in query value element.");
        }
        PrismDomProcessor domProcessor = this.getInterpreter().getPrismContext().getPrismDomProcessor();
        PrismReferenceValue refValue = domProcessor.parseReferenceValue(condition);
        QName type = refValue.getTargetType();
        Criterion criterion = this.createBaseCriteria(filter, pushNot, conditionItem.getQueryableItem(), targetOid);
        if (type != null) {
            Conjunction conjunction = Restrictions.conjunction();
            conjunction.add(criterion);
            conjunction.add((Criterion)Restrictions.eq((String)"type", (Object)((Object)ClassMapper.getHQLTypeForQName(type))));
            criterion = conjunction;
        }
        return criterion;
    }

    private SimpleItem updateConditionItem(Element condition, Element path) throws QueryException {
        PropertyPath propertyPath = this.getInterpreter().createPropertyPath(path);
        QName conditionItem = DOMUtil.getQNameWithoutPrefix((Node)condition);
        LOGGER.debug("Updating condition item '{}' on property path\n{}", new Object[]{conditionItem, propertyPath});
        SimpleItem item = new SimpleItem();
        EntityDefinition definition = this.findDefinition(this.getInterpreter().getType(), propertyPath);
        if (propertyPath != null) {
            if (definition.isAny()) {
                try {
                    item.isAny = true;
                    List segments = propertyPath.getSegments();
                    String anyTypeName = RAnyConverter.getAnySetType(this.getInterpreter().findDefinition(path, conditionItem), condition);
                    segments.add(new PropertyPathSegment(new QName("http://midpoint.evolveum.com/xml/ns/fake/sqlRepository-1.xsd", anyTypeName)));
                    propertyPath = new PropertyPath(segments);
                    LOGGER.trace("Condition item is from 'any' container, adding new criteria based on any type '{}'", new Object[]{anyTypeName});
                    this.addNewCriteriaToContext(propertyPath, anyTypeName);
                }
                catch (SchemaException ex) {
                    throw new QueryException(ex.getMessage(), ex);
                }
            }
            item.alias = this.getInterpreter().getAlias(propertyPath);
            LOGGER.trace("Found alias '{}' for path.", new Object[]{item.alias});
        }
        if (definition.isAny()) {
            item.item = "value";
        } else {
            Definition def = definition.findDefinition(conditionItem);
            if (def == null) {
                throw new QueryException("Couldn't find query definition for condition item '" + conditionItem + "'.");
            }
            if (def.isEntity()) {
                throw new QueryException("Can't query entity for value, only attribute can be queried for value.");
            }
            AttributeDefinition attrDef = (AttributeDefinition)def;
            if (!attrDef.isIndexed()) {
                LOGGER.debug("You're probably querying by attribute ('" + attrDef + "') which is not indexed.");
            }
            if (attrDef.isReference()) {
                PropertyPath propPath = propertyPath;
                String realName = attrDef.getRealName();
                if (propPath == null) {
                    propPath = new PropertyPath(new QName[]{new QName("http://midpoint.evolveum.com/xml/ns/fake/sqlRepository-1.xsd", realName)});
                }
                this.addNewCriteriaToContext(propPath, realName);
                item.isReference = true;
                item.alias = this.getInterpreter().getAlias(propPath);
                LOGGER.trace("Found alias '{}' for path.", new Object[]{item.alias});
                item.item = "targetOid";
            } else {
                item.item = attrDef.getRealName();
                if (attrDef.isPolyString()) {
                    item.item = String.valueOf(item.item) + ".norm";
                }
            }
            item.isPolyString = attrDef.isPolyString();
            item.isEnum = attrDef.isEnumerated();
            item.enumType = attrDef.getClassType();
        }
        return item;
    }

    private EntityDefinition findDefinition(Class<? extends ObjectType> type, PropertyPath path) throws QueryException {
        EntityDefinition definition = this.getClassTypeDefinition(type);
        if (path == null) {
            return definition;
        }
        for (PropertyPathSegment segment : path.getSegments()) {
            Definition def = definition.findDefinition(segment.getName());
            if (!def.isEntity()) {
                throw new QueryException("Can't query attribute in attribute.");
            }
            definition = (EntityDefinition)def;
        }
        return definition;
    }

    private EntityDefinition getClassTypeDefinition(Class<? extends ObjectType> type) throws QueryException {
        EntityDefinition definition = QueryRegistry.getInstance().findDefinition(type);
        if (definition == null) {
            throw new QueryException("Can't query, unknown type '" + type.getSimpleName() + "'.");
        }
        return definition;
    }

    private void updateQueryContext(PropertyPath path) throws QueryException {
        LOGGER.debug("Updating query context based on path\n{}", new Object[]{path.toString()});
        Class<? extends ObjectType> type = this.getInterpreter().getType();
        Definition definition = this.getClassTypeDefinition(type);
        List segments = path.getSegments();
        ArrayList<PropertyPathSegment> propPathSegments = new ArrayList<PropertyPathSegment>();
        for (PropertyPathSegment segment : segments) {
            QName qname = segment.getName();
            propPathSegments.add(new PropertyPathSegment(qname));
            PropertyPath propPath = new PropertyPath(propPathSegments);
            definition = definition.findDefinition(qname);
            if (definition == null || !definition.isEntity()) {
                throw new QueryException("This definition '" + definition + "' is not entity definition, " + "we can't query attribute in attribute. Please check your path in query, or query " + "entity/attribute mappings.");
            }
            EntityDefinition entityDefinition = (EntityDefinition)definition;
            if (entityDefinition.isEmbedded()) {
                LOGGER.trace("Skipping segment '{}' because it's embedded, sub path\n{}", new Object[]{qname, propPath.toString()});
                continue;
            }
            LOGGER.trace("Adding criteria '{}' to context based on sub path\n{}", new Object[]{definition.getRealName(), propPath.toString()});
            this.addNewCriteriaToContext(propPath, definition.getRealName());
        }
    }

    private void addNewCriteriaToContext(PropertyPath propPath, String realName) {
        PropertyPath lastPropPath = propPath.allExceptLast();
        if (PropertyPath.EMPTY_PATH.equals((Object)lastPropPath)) {
            lastPropPath = null;
        }
        Criteria pCriteria = this.getInterpreter().getCriteria(lastPropPath);
        String alias = this.getInterpreter().createAlias(propPath.last().getName());
        Criteria criteria = pCriteria.createCriteria(realName, alias);
        this.getInterpreter().setCriteria(propPath, criteria);
        this.getInterpreter().setAlias(propPath, alias);
    }

    private static enum Operation {
        EQUAL,
        SUBSTRING;

    }

    private static class SimpleItem {
        String item;
        String alias;
        boolean isAny;
        boolean isReference;
        boolean isEnum;
        boolean isPolyString;
        Class<?> enumType;

        private SimpleItem() {
        }

        String getQueryableItem() {
            StringBuilder builder = new StringBuilder();
            if (StringUtils.isNotEmpty((String)this.alias)) {
                builder.append(this.alias);
                builder.append(".");
            }
            builder.append(this.item);
            return builder.toString();
        }
    }
}

