/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.data.common;

import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.repo.sql.data.common.RObject;
import com.evolveum.midpoint.repo.sql.data.common.RUtil;
import com.evolveum.midpoint.repo.sql.query.QueryAttribute;
import com.evolveum.midpoint.repo.sql.util.DtoTranslationException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.PasswordLifeTimeType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.PasswordPolicyType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.StringPolicyType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.xml.namespace.QName;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;

@Entity
@ForeignKey(name="fk_password_policy")
public class RPasswordPolicy
extends RObject {
    @QueryAttribute
    private String name;
    private String lifetime;
    private String stringPolicy;

    @Type(type="org.hibernate.type.MaterializedClobType")
    public String getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(String lifetime) {
        this.lifetime = lifetime;
    }

    @Type(type="org.hibernate.type.MaterializedClobType")
    public String getStringPolicy() {
        return this.stringPolicy;
    }

    @Index(name="iPasswordPolicyName")
    @Column(name="objectName", unique=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStringPolicy(String stringPolicy) {
        this.stringPolicy = stringPolicy;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RPasswordPolicy that = (RPasswordPolicy)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.lifetime != null ? !this.lifetime.equals(that.lifetime) : that.lifetime != null) {
            return false;
        }
        return !(this.stringPolicy != null ? !this.stringPolicy.equals(that.stringPolicy) : that.stringPolicy != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.lifetime != null ? this.lifetime.hashCode() : 0);
        result = 31 * result + (this.stringPolicy != null ? this.stringPolicy.hashCode() : 0);
        return result;
    }

    public static void copyToJAXB(RPasswordPolicy repo, PasswordPolicyType jaxb, PrismContext prismContext) throws DtoTranslationException {
        RObject.copyToJAXB(repo, (ObjectType)jaxb, prismContext);
        jaxb.setName(repo.getName());
        try {
            jaxb.setLifetime(RUtil.toJAXB(PasswordPolicyType.class, new PropertyPath(new QName[]{PasswordPolicyType.F_LIFETIME}), repo.getLifetime(), PasswordLifeTimeType.class, prismContext));
            jaxb.setStringPolicy(RUtil.toJAXB(PasswordPolicyType.class, new PropertyPath(new QName[]{PasswordPolicyType.F_STRING_POLICY}), repo.getStringPolicy(), StringPolicyType.class, prismContext));
        }
        catch (Exception ex) {
            throw new DtoTranslationException(ex.getMessage(), ex);
        }
    }

    public static void copyFromJAXB(PasswordPolicyType jaxb, RPasswordPolicy repo, PrismContext prismContext) throws DtoTranslationException {
        RObject.copyFromJAXB((ObjectType)jaxb, repo, prismContext);
        repo.setName(jaxb.getName());
        try {
            repo.setLifetime(RUtil.toRepo(jaxb.getLifetime(), prismContext));
            repo.setStringPolicy(RUtil.toRepo(jaxb.getStringPolicy(), prismContext));
        }
        catch (Exception ex) {
            throw new DtoTranslationException(ex.getMessage(), ex);
        }
    }

    public PasswordPolicyType toJAXB(PrismContext prismContext) throws DtoTranslationException {
        PasswordPolicyType policy = new PasswordPolicyType();
        RUtil.revive((Objectable)policy, prismContext);
        RPasswordPolicy.copyToJAXB(this, policy, prismContext);
        return policy;
    }
}

