/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.data.common;

import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.repo.sql.data.common.RContainer;
import com.evolveum.midpoint.repo.sql.data.common.REmbeddedReference;
import com.evolveum.midpoint.repo.sql.data.common.RObjectReferenceId;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectReferenceType;
import java.io.Serializable;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.Table;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.annotations.ForeignKey;

@Entity
@IdClass(value=RObjectReferenceId.class)
@Table(name="m_reference")
public class RObjectReference
implements Serializable {
    private RContainer owner;
    private String ownerOid;
    private Long ownerId;
    private String targetOid;
    private REmbeddedReference reference = new REmbeddedReference();

    @ForeignKey(name="fk_reference_owner")
    @MapsId(value="owner")
    @ManyToOne(fetch=FetchType.LAZY)
    @PrimaryKeyJoinColumns(value={@PrimaryKeyJoinColumn(name="owner_oid", referencedColumnName="oid"), @PrimaryKeyJoinColumn(name="owner_id", referencedColumnName="id")})
    public RContainer getOwner() {
        return this.owner;
    }

    @Id
    @Column(name="owner_id")
    public Long getOwnerId() {
        if (this.ownerId == null && this.owner != null) {
            this.ownerId = this.owner.getId();
        }
        return this.ownerId;
    }

    @Id
    @Column(name="owner_oid", length=36)
    public String getOwnerOid() {
        if (this.ownerOid == null && this.owner != null) {
            this.ownerOid = this.owner.getOid();
        }
        return this.ownerOid;
    }

    @Id
    @Column(name="targetOid", length=36)
    public String getTargetOid() {
        if (this.targetOid == null) {
            this.targetOid = this.getReference().getTargetOid();
        }
        if (this.targetOid == null) {
            this.targetOid = "";
        }
        return this.targetOid;
    }

    @AttributeOverrides(value={@AttributeOverride(name="type", column=@Column(name="type")), @AttributeOverride(name="targetOid", column=@Column(name="targetOid", insertable=false, updatable=false)), @AttributeOverride(name="description", column=@Column(name="description")), @AttributeOverride(name="filter", column=@Column(name="filter"))})
    @Embedded
    public REmbeddedReference getReference() {
        return this.reference;
    }

    public void setTargetOid(String targetOid) {
        this.getReference().setTargetOid(targetOid);
        this.targetOid = targetOid;
    }

    public void setReference(REmbeddedReference reference) {
        Validate.notNull((Object)reference, (String)"Embedded reference must not be null.");
        this.reference = reference;
        this.targetOid = reference.getTargetOid();
    }

    public void setOwner(RContainer owner) {
        this.owner = owner;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public void setOwnerOid(String ownerOid) {
        this.ownerOid = ownerOid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RObjectReference that = (RObjectReference)o;
        return !(this.reference != null ? !this.reference.equals(that.reference) : that.reference != null);
    }

    public int hashCode() {
        return this.reference != null ? this.reference.hashCode() : 0;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public static void copyToJAXB(RObjectReference repo, ObjectReferenceType jaxb, PrismContext prismContext) {
        Validate.notNull((Object)repo, (String)"Repo object must not be null.");
        Validate.notNull((Object)jaxb, (String)"JAXB object must not be null.");
        REmbeddedReference.copyToJAXB(repo.getReference(), jaxb, prismContext);
    }

    public static void copyFromJAXB(ObjectReferenceType jaxb, RObjectReference repo, PrismContext prismContext) {
        Validate.notNull((Object)repo, (String)"Repo object must not be null.");
        Validate.notNull((Object)jaxb, (String)"JAXB object must not be null.");
        REmbeddedReference ref = new REmbeddedReference();
        REmbeddedReference.copyFromJAXB(jaxb, ref, prismContext);
        repo.setReference(ref);
    }

    public ObjectReferenceType toJAXB(PrismContext prismContext) {
        ObjectReferenceType ref = new ObjectReferenceType();
        RObjectReference.copyToJAXB(this, ref, prismContext);
        return ref;
    }
}

