/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.data.common;

import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.repo.sql.data.common.RObject;
import com.evolveum.midpoint.repo.sql.data.common.RUtil;
import com.evolveum.midpoint.repo.sql.query.QueryAttribute;
import com.evolveum.midpoint.repo.sql.util.DtoTranslationException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ConnectorHostType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ProtectedStringType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.xml.namespace.QName;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;

@Entity
@ForeignKey(name="fk_connector_host")
public class RConnectorHost
extends RObject {
    @QueryAttribute
    private String name;
    private String hostname;
    private String port;
    private String sharedSecret;
    private Boolean protectConnection;
    private Integer timeout;

    @Type(type="org.hibernate.type.TextType")
    public String getSharedSecret() {
        return this.sharedSecret;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    @Column(nullable=true)
    public Boolean isProtectConnection() {
        return this.protectConnection;
    }

    @Index(name="iConnectorHostName")
    @Column(name="objectName", unique=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProtectConnection(Boolean protectConnection) {
        this.protectConnection = protectConnection;
    }

    @Column(nullable=true)
    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setSharedSecret(String sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RConnectorHost that = (RConnectorHost)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        if (this.protectConnection != null ? !this.protectConnection.equals(that.protectConnection) : that.protectConnection != null) {
            return false;
        }
        if (this.sharedSecret != null ? !this.sharedSecret.equals(that.sharedSecret) : that.sharedSecret != null) {
            return false;
        }
        return !(this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
        result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
        result = 31 * result + (this.sharedSecret != null ? this.sharedSecret.hashCode() : 0);
        result = 31 * result + (this.protectConnection != null ? this.protectConnection.hashCode() : 0);
        result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
        return result;
    }

    public static void copyToJAXB(RConnectorHost repo, ConnectorHostType jaxb, PrismContext prismContext) throws DtoTranslationException {
        RObject.copyToJAXB(repo, (ObjectType)jaxb, prismContext);
        jaxb.setName(repo.getName());
        jaxb.setHostname(repo.getHostname());
        jaxb.setPort(repo.getPort());
        jaxb.setProtectConnection(repo.isProtectConnection());
        jaxb.setTimeout(repo.getTimeout());
        try {
            jaxb.setSharedSecret(RUtil.toJAXB(ConnectorHostType.class, new PropertyPath(new QName[]{ConnectorHostType.F_SHARED_SECRET}), repo.getSharedSecret(), ProtectedStringType.class, prismContext));
        }
        catch (Exception ex) {
            new DtoTranslationException(ex.getMessage(), ex);
        }
    }

    public static void copyFromJAXB(ConnectorHostType jaxb, RConnectorHost repo, PrismContext prismContext) throws DtoTranslationException {
        RObject.copyFromJAXB((ObjectType)jaxb, repo, prismContext);
        repo.setName(jaxb.getName());
        repo.setHostname(jaxb.getHostname());
        repo.setPort(jaxb.getPort());
        repo.setTimeout(jaxb.getTimeout());
        repo.setProtectConnection(jaxb.isProtectConnection());
        try {
            repo.setSharedSecret(RUtil.toRepo(jaxb.getSharedSecret(), prismContext));
        }
        catch (Exception ex) {
            new DtoTranslationException(ex.getMessage(), ex);
        }
    }

    public ConnectorHostType toJAXB(PrismContext prismContext) throws DtoTranslationException {
        ConnectorHostType object = new ConnectorHostType();
        RUtil.revive((Objectable)object, prismContext);
        RConnectorHost.copyToJAXB(this, object, prismContext);
        return object;
    }
}

