/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.data.common;

import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.Itemable;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismReference;
import com.evolveum.midpoint.prism.PrismReferenceDefinition;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.dom.PrismDomProcessor;
import com.evolveum.midpoint.prism.xml.XmlTypeConverter;
import com.evolveum.midpoint.repo.sql.data.common.RClobValue;
import com.evolveum.midpoint.repo.sql.data.common.RDateValue;
import com.evolveum.midpoint.repo.sql.data.common.RLongValue;
import com.evolveum.midpoint.repo.sql.data.common.RStringValue;
import com.evolveum.midpoint.repo.sql.data.common.RUtil;
import com.evolveum.midpoint.repo.sql.data.common.RValue;
import com.evolveum.midpoint.repo.sql.data.common.RValueType;
import com.evolveum.midpoint.repo.sql.type.XMLGregorianCalendarType;
import com.evolveum.midpoint.repo.sql.util.DtoTranslationException;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RAnyConverter {
    private static final Trace LOGGER = TraceManager.getTrace(RAnyConverter.class);
    private static final Map<QName, ValueType> TYPE_MAP = new HashMap<QName, ValueType>();
    private PrismContext prismContext;
    private Document document;

    static {
        TYPE_MAP.put(DOMUtil.XSD_INT, ValueType.LONG);
        TYPE_MAP.put(DOMUtil.XSD_LONG, ValueType.LONG);
        TYPE_MAP.put(DOMUtil.XSD_SHORT, ValueType.LONG);
        TYPE_MAP.put(DOMUtil.XSD_INTEGER, ValueType.STRING);
        TYPE_MAP.put(DOMUtil.XSD_STRING, ValueType.STRING);
        TYPE_MAP.put(DOMUtil.XSD_DOUBLE, ValueType.STRING);
        TYPE_MAP.put(DOMUtil.XSD_FLOAT, ValueType.STRING);
        TYPE_MAP.put(DOMUtil.XSD_DATETIME, ValueType.DATE);
    }

    RAnyConverter(PrismContext prismContext) {
        this.prismContext = prismContext;
    }

    Set<RValue> convertToRValue(Item item) throws DtoTranslationException {
        Validate.notNull((Object)item, (String)"Object for converting must not be null.");
        Validate.notNull((Object)item.getDefinition(), (String)("Item '" + item.getName() + "' without definition can't be saved."));
        HashSet<RValue> rValues = new HashSet<RValue>();
        try {
            ItemDefinition definition = item.getDefinition();
            RValue rValue = null;
            List values = item.getValues();
            for (PrismValue value : values) {
                if (value instanceof PrismContainerValue) {
                    rValue = this.createClobValue(value);
                } else if (value instanceof PrismPropertyValue) {
                    PrismPropertyValue propertyValue = (PrismPropertyValue)value;
                    switch (RAnyConverter.getValueType(definition.getTypeName())) {
                        case LONG: {
                            RLongValue longValue = new RLongValue();
                            longValue.setValue(this.extractValue(propertyValue, Long.class));
                            rValue = longValue;
                            break;
                        }
                        case DATE: {
                            RDateValue dateValue = new RDateValue();
                            dateValue.setValue(this.extractValue(propertyValue, Date.class));
                            rValue = dateValue;
                            break;
                        }
                        default: {
                            if (RAnyConverter.isIndexable(definition)) {
                                RStringValue strValue = new RStringValue();
                                strValue.setValue(this.extractValue(propertyValue, String.class));
                                rValue = strValue;
                                break;
                            }
                            rValue = this.createClobValue((PrismValue)propertyValue);
                        }
                    }
                }
                rValue.setName(definition.getName());
                rValue.setType(definition.getTypeName());
                rValue.setValueType(this.getValueType(value.getParent()));
                rValue.setDynamic(definition.isDynamic());
                rValues.add(rValue);
            }
        }
        catch (Exception ex) {
            throw new DtoTranslationException(ex.getMessage(), ex);
        }
        return rValues;
    }

    private static boolean isIndexable(ItemDefinition definition) {
        if (definition instanceof PrismContainerDefinition) {
            return false;
        }
        if (definition instanceof PrismReferenceDefinition) {
            return true;
        }
        if (!(definition instanceof PrismPropertyDefinition)) {
            throw new UnsupportedOperationException("Unknown definition type '" + definition + "', can't say if it's indexed or not.");
        }
        PrismPropertyDefinition pDefinition = (PrismPropertyDefinition)definition;
        if (pDefinition.isIndexed() != null) {
            return pDefinition.isIndexed();
        }
        QName type = definition.getTypeName();
        return RAnyConverter.isIndexable(type);
    }

    private static boolean isIndexable(QName type) {
        return DOMUtil.XSD_DATETIME.equals(type) || DOMUtil.XSD_INT.equals(type) || DOMUtil.XSD_LONG.equals(type) || DOMUtil.XSD_SHORT.equals(type) || DOMUtil.XSD_INTEGER.equals(type) || DOMUtil.XSD_DOUBLE.equals(type) || DOMUtil.XSD_FLOAT.equals(type) || DOMUtil.XSD_STRING.equals(type);
    }

    private RValueType getValueType(Itemable itemable) {
        Validate.notNull((Object)itemable, (String)"Value parent must not be null.");
        if (!(itemable instanceof Item)) {
            throw new IllegalArgumentException("Item type '" + itemable.getClass() + "' not supported in 'any' now.");
        }
        return RValueType.getTypeFromItemClass(((Item)itemable).getClass());
    }

    private RClobValue createClobValue(PrismValue prismValue) throws SchemaException {
        PrismDomProcessor domProcessor = this.prismContext.getPrismDomProcessor();
        Element root = this.createElement(RUtil.CUSTOM_OBJECT);
        domProcessor.serializeValueToDom(prismValue, root);
        String value = DOMUtil.serializeDOMToString((Node)root);
        return new RClobValue(value);
    }

    private <T> T extractValue(PrismPropertyValue value, Class<T> returnType) throws SchemaException {
        ItemDefinition definition = value.getParent().getDefinition();
        Object object = value.getValue();
        object = object instanceof Element ? RAnyConverter.getRealRepoValue(definition, (Element)object) : RAnyConverter.updateJavaValueType(object);
        if (returnType.isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        throw new IllegalStateException("Can't extract value for saving from prism property value\n" + value);
    }

    private static ValueType getValueType(QName qname) {
        if (qname == null) {
            return ValueType.STRING;
        }
        ValueType type = TYPE_MAP.get(qname);
        if (type == null) {
            return ValueType.STRING;
        }
        return type;
    }

    void convertFromRValue(RValue value, PrismContainerValue any) throws DtoTranslationException {
        Validate.notNull((Object)value, (String)"Value for converting must not be null.");
        Validate.notNull((Object)any, (String)"Parent prism container value must not be null.");
        try {
            Item item;
            if (value.isDynamic()) {
                ItemDefinition def = this.createDefinitionForItem(value);
                def.setDynamic(true);
                item = def.instantiate();
                any.add(item);
            } else {
                try {
                    item = any.findOrCreateItem(value.getName(), value.getValueType().getItemClass());
                }
                catch (SchemaException schemaException) {
                    ItemDefinition def = this.createDefinitionForItem(value);
                    item = def.instantiate();
                    any.add(item);
                }
            }
            if (item == null) {
                throw new DtoTranslationException("Couldn't create item for value '" + value.getName() + "'.");
            }
            this.addValueToItem(value, item);
        }
        catch (Exception ex) {
            if (ex instanceof DtoTranslationException) {
                throw (DtoTranslationException)ex;
            }
            throw new DtoTranslationException(ex.getMessage(), ex);
        }
    }

    private ItemDefinition createDefinitionForItem(RValue value) {
        PrismPropertyDefinition def;
        switch (value.getValueType()) {
            case PROPERTY: {
                def = new PrismPropertyDefinition(value.getName(), value.getName(), value.getType(), this.prismContext);
                break;
            }
            case CONTAINER: {
                throw new UnsupportedOperationException("Not implemented yet.");
            }
            case OBJECT: {
                throw new UnsupportedOperationException("Not implemented yet.");
            }
            case REFERENCE: {
                def = new PrismReferenceDefinition(value.getName(), value.getName(), value.getType(), this.prismContext);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown value type " + (Object)((Object)value.getValueType()));
            }
        }
        return def;
    }

    private Item createDefinitionlessItem(RValue value) throws DtoTranslationException {
        PrismProperty item;
        switch (value.getValueType()) {
            case PROPERTY: {
                item = new PrismProperty(value.getName());
                break;
            }
            case CONTAINER: {
                item = new PrismContainer(value.getName());
                break;
            }
            case OBJECT: {
                item = new PrismObject(value.getName(), null);
                break;
            }
            case REFERENCE: {
                item = new PrismReference(value.getName());
                break;
            }
            default: {
                throw new DtoTranslationException("Unknown value type: " + (Object)((Object)value.getValueType()));
            }
        }
        return item;
    }

    private Element createElement(QName name) {
        if (this.document == null) {
            this.document = DOMUtil.getDocument();
        }
        return DOMUtil.createElement((Document)this.document, (QName)name);
    }

    private void addClobValueToItem(RClobValue value, Item item) throws SchemaException {
        PrismDomProcessor domProcessor = this.prismContext.getPrismDomProcessor();
        Element root = DOMUtil.parseDocument((String)value.getValue()).getDocumentElement();
        Item parsedItem = domProcessor.parseItem(DOMUtil.listChildElements((Node)root), value.getName(), item.getDefinition());
        item.addAll((Collection)parsedItem.getValues());
    }

    private void addValueToItem(RValue value, Item item) throws SchemaException {
        if (value instanceof RClobValue) {
            this.addClobValueToItem((RClobValue)value, item);
            return;
        }
        Object realValue = this.createRealValue(value);
        if (realValue == null) {
            throw new SchemaException("Real value must not be null. Some error occurred when adding value " + value + " to item " + item);
        }
        switch (value.getValueType()) {
            case REFERENCE: {
                throw new UnsupportedOperationException("Not implemented yet.");
            }
            case PROPERTY: {
                PrismPropertyValue propertyValue = new PrismPropertyValue(realValue, null, null);
                item.add((PrismValue)propertyValue);
                break;
            }
            case CONTAINER: 
            case OBJECT: {
                throw new UnsupportedOperationException("Not implemented yet.");
            }
        }
    }

    private Object createRealValue(RValue rValue) throws SchemaException {
        Object value = rValue.getValue();
        if (rValue instanceof RDateValue) {
            if (value instanceof Date) {
                return XMLGregorianCalendarType.asXMLGregorianCalendar((Date)value);
            }
        } else if (rValue instanceof RLongValue) {
            if (DOMUtil.XSD_LONG.equals(rValue.getType())) {
                return value;
            }
            if (DOMUtil.XSD_INT.equals(rValue.getType())) {
                return ((Long)value).intValue();
            }
            if (DOMUtil.XSD_SHORT.equals(rValue.getType())) {
                return ((Long)value).shortValue();
            }
        } else if (rValue instanceof RStringValue) {
            if (DOMUtil.XSD_STRING.equals(rValue.getType())) {
                return value;
            }
            if (DOMUtil.XSD_DOUBLE.equals(rValue.getType())) {
                return Double.parseDouble((String)value);
            }
            if (DOMUtil.XSD_FLOAT.equals(rValue.getType())) {
                return Float.valueOf(Float.parseFloat((String)value));
            }
            if (DOMUtil.XSD_INTEGER.equals(rValue.getType())) {
                return new BigInteger((String)value);
            }
        }
        LOGGER.trace("Couldn't create real value of type '{}' from '{}'", new Object[]{rValue.getType(), rValue.getValue()});
        throw new IllegalStateException("Can't create real value of type '" + rValue.getType() + "' from value saved in DB as '" + rValue.getClass().getSimpleName() + "'.");
    }

    public static <T extends ObjectType> String getAnySetType(ItemDefinition definition, Element value) throws SchemaException {
        boolean indexed;
        QName typeName = definition == null ? DOMUtil.resolveXsiType((Element)value) : definition.getTypeName();
        Validate.notNull((Object)typeName, (String)("Definition was not defined for element value '" + DOMUtil.getQNameWithoutPrefix((Node)value) + "' and it doesn't have xsi:type."));
        ValueType valueType = RAnyConverter.getValueType(typeName);
        switch (valueType) {
            case DATE: {
                return "dates";
            }
            case LONG: {
                return "longs";
            }
        }
        boolean bl = indexed = definition == null ? RAnyConverter.isIndexable(typeName) : RAnyConverter.isIndexable(definition);
        if (indexed) {
            return "strings";
        }
        return "clobs";
    }

    public static Object getRealRepoValue(ItemDefinition definition, Element value) throws SchemaException {
        ValueType willBeSaveAs = definition == null ? null : RAnyConverter.getValueType(definition.getTypeName());
        QName typeName = definition == null ? DOMUtil.resolveXsiType((Element)value) : definition.getTypeName();
        Validate.notNull((Object)typeName, (String)("Definition was not defined for element value '" + DOMUtil.getQNameWithoutPrefix((Node)value) + "' and it doesn't have xsi:type."));
        if (ValueType.STRING.equals((Object)willBeSaveAs)) {
            if (DOMUtil.listChildElements((Node)value).isEmpty()) {
                return value.getTextContent();
            }
            return DOMUtil.serializeDOMToString((Node)value);
        }
        Object object = XmlTypeConverter.toJavaValue((Element)value, (QName)typeName);
        if ((object = RAnyConverter.updateJavaValueType(object)) == null) {
            throw new IllegalStateException("Can't extract value for saving from prism property value\n" + value);
        }
        return object;
    }

    private static Object updateJavaValueType(Object object) {
        if (object instanceof Float) {
            object = ((Float)object).toString();
        } else if (object instanceof Double) {
            object = ((Double)object).toString();
        } else if (object instanceof BigInteger) {
            object = ((BigInteger)object).toString();
        }
        if (object instanceof Short) {
            object = ((Short)object).longValue();
        } else if (object instanceof Integer) {
            object = ((Integer)object).longValue();
        }
        if (object instanceof GregorianCalendar) {
            object = ((GregorianCalendar)object).getTime();
        } else if (object instanceof XMLGregorianCalendar) {
            object = XMLGregorianCalendarType.asDate((XMLGregorianCalendar)object);
        }
        return object;
    }

    private static enum ValueType {
        LONG,
        STRING,
        DATE;

    }
}

