/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.xqj;

import java.util.Arrays;
import javax.xml.namespace.QName;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQPreparedExpression;
import javax.xml.xquery.XQQueryException;
import javax.xml.xquery.XQResultSequence;
import javax.xml.xquery.XQSequenceType;
import javax.xml.xquery.XQStaticContext;
import org.basex.api.xqj.BXQConnection;
import org.basex.api.xqj.BXQDynamicContext;
import org.basex.api.xqj.BXQException;
import org.basex.api.xqj.BXQItemType;
import org.basex.api.xqj.BXQStaticContext;
import org.basex.query.QueryException;
import org.basex.query.item.QNm;
import org.basex.query.util.Var;
import org.basex.query.util.VarList;
import org.basex.util.Array;

final class BXQPreparedExpression
extends BXQDynamicContext
implements XQPreparedExpression {
    BXQPreparedExpression(String input, BXQStaticContext s, BXQConnection c) throws XQQueryException {
        super(input, s, c);
        try {
            this.qp.parse();
        }
        catch (QueryException ex) {
            throw new XQQueryException(ex.getMessage(), new QName(ex.code()), ex.line(), ex.col(), -1);
        }
    }

    public void cancel() throws XQException {
        this.opened();
        this.qp.ctx.stop();
    }

    public XQResultSequence executeQuery() throws XQException {
        return this.execute();
    }

    public QName[] getAllExternalVariables() throws XQException {
        return this.getVariables(true);
    }

    public QName[] getAllUnboundExternalVariables() throws XQException {
        return this.getVariables(false);
    }

    private QName[] getVariables(boolean all) throws XQException {
        this.opened();
        Object[] names = new QName[]{};
        VarList vars = this.qp.ctx.vars.global();
        Var[] varArray = Arrays.copyOf(vars.vars, vars.size);
        int n = varArray.length;
        int n2 = 0;
        while (n2 < n) {
            Var v = varArray[n2];
            if (all || v.expr() == null) {
                names = (QName[])Array.add((Object[])names, (Object)v.name.toJava());
            }
            ++n2;
        }
        return names;
    }

    public XQStaticContext getStaticContext() throws XQException {
        this.opened();
        return this.sc;
    }

    public XQSequenceType getStaticResultType() throws XQException {
        this.opened();
        return BXQItemType.DEFAULT;
    }

    public XQSequenceType getStaticVariableType(QName qn) throws XQException {
        this.opened();
        BXQPreparedExpression.valid(qn, String.class);
        QNm nm = new QNm(qn);
        Var var = this.qp.ctx.vars.get(nm);
        if (var == null) {
            throw new BXQException("Unknown variable %.", nm);
        }
        return var.type != null ? new BXQItemType(var.type.type) : BXQItemType.DEFAULT;
    }
}

