/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.xqj;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQResultItem;
import org.basex.api.xqj.BXQAbstract;
import org.basex.api.xqj.BXQConnection;
import org.basex.api.xqj.BXQDataFactory;
import org.basex.api.xqj.BXQException;
import org.basex.api.xqj.BXQItemType;
import org.basex.api.xqj.IterStreamReader;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.SAXSerializer;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.XMLSerializer;
import org.basex.query.QueryException;
import org.basex.query.item.ANode;
import org.basex.query.item.AtomType;
import org.basex.query.item.Bln;
import org.basex.query.item.Dbl;
import org.basex.query.item.Flt;
import org.basex.query.item.Item;
import org.basex.query.item.NodeType;
import org.basex.query.item.Type;
import org.basex.query.iter.ItemCache;
import org.basex.query.iter.Iter;
import org.basex.util.Token;
import org.basex.util.Util;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

final class BXQItem
extends BXQAbstract
implements XQResultItem {
    private final BXQConnection conn;
    final Item it;

    BXQItem(Item item) throws XQException {
        this(item, new BXQDataFactory(null, null), null);
    }

    BXQItem(Item item, BXQAbstract c, BXQConnection connection) {
        super(c);
        this.conn = connection;
        this.it = item;
    }

    public String getAtomicValue() throws XQException {
        this.opened();
        if (this.it.node()) {
            throw new BXQException("Atomic value expected.", new Object[0]);
        }
        try {
            return Token.string((byte[])this.it.atom(null));
        }
        catch (QueryException e) {
            throw new BXQException("Atomic value expected.", new Object[0]);
        }
    }

    public boolean getBoolean() throws XQException {
        return ((Bln)this.check((Type)AtomType.BLN)).bool(null);
    }

    public byte getByte() throws XQException {
        return (byte)this.castItr((Type)AtomType.BYT);
    }

    public double getDouble() throws XQException {
        return ((Dbl)this.check((Type)AtomType.DBL)).dbl(null);
    }

    public float getFloat() throws XQException {
        return ((Flt)this.check((Type)AtomType.FLT)).flt(null);
    }

    public int getInt() throws XQException {
        return (int)this.castItr((Type)AtomType.INT);
    }

    public XMLStreamReader getItemAsStream() {
        return new IterStreamReader((Iter)new ItemCache(new Item[]{this.it}, 1));
    }

    public String getItemAsString(Properties props) throws XQException {
        try {
            return this.it.node() && this.it.type != NodeType.TXT ? this.serialize() : Token.string((byte[])this.it.atom(null));
        }
        catch (QueryException e) {
            throw new XQException(e.getMessage(), e.code());
        }
    }

    public XQItemType getItemType() throws XQException {
        this.opened();
        return new BXQItemType(this.it.type);
    }

    public long getLong() throws XQException {
        return this.castItr((Type)AtomType.LNG);
    }

    public Node getNode() throws XQException {
        this.opened();
        if (!this.it.node()) {
            throw new BXQException("Wrong data type; % expected, % found.", NodeType.NOD, this.it.type);
        }
        return ((ANode)this.it).toJava();
    }

    public URI getNodeUri() throws XQException {
        this.opened();
        if (!this.it.node()) {
            throw new BXQException("Current item is not a node.", new Object[0]);
        }
        ANode node = (ANode)this.it;
        try {
            return new URI(Token.string((byte[])node.base()));
        }
        catch (URISyntaxException ex) {
            throw new BXQException(ex.toString(), new Object[0]);
        }
    }

    public Object getObject() throws XQException {
        this.opened();
        return this.it.toJava();
    }

    public short getShort() throws XQException {
        return (short)this.castItr((Type)AtomType.SHR);
    }

    public boolean instanceOf(XQItemType type) throws XQException {
        this.opened();
        return this.it.type.instance(((BXQItemType)type).getType());
    }

    public void writeItem(OutputStream os, Properties props) throws XQException {
        BXQItem.valid(os, OutputStream.class);
        this.serialize(os);
    }

    public void writeItemToSAX(ContentHandler sax) throws XQException {
        BXQItem.valid(sax, ContentHandler.class);
        this.writeItemToResult(new SAXResult(sax));
    }

    public XQConnection getConnection() throws XQException {
        this.opened();
        return this.conn;
    }

    public void writeItem(Writer ow, Properties props) throws XQException {
        BXQItem.valid(ow, Writer.class);
        try {
            ow.write(this.serialize());
        }
        catch (IOException ex) {
            throw new BXQException(ex);
        }
    }

    public void writeItemToResult(Result result) throws XQException {
        BXQItem.valid(result, Result.class);
        if (result instanceof StreamResult) {
            this.writeItem(((StreamResult)result).getWriter(), null);
        } else if (result instanceof SAXResult) {
            try {
                SAXSerializer ser = new SAXSerializer(null);
                ser.setContentHandler(((SAXResult)result).getHandler());
                this.serialize(this.it, (Serializer)ser);
                ser.close();
            }
            catch (IOException ex) {
                throw new BXQException(ex);
            }
        } else {
            Util.notimplemented((Object[])new Object[0]);
        }
    }

    private void serialize(OutputStream os) throws XQException {
        try {
            XMLSerializer xml = new XMLSerializer(os);
            this.serialize(this.it, (Serializer)xml);
            xml.close();
        }
        catch (IOException ex) {
            throw new BXQException(ex);
        }
    }

    private String serialize() throws XQException {
        this.opened();
        ArrayOutput ao = new ArrayOutput();
        this.serialize((OutputStream)ao);
        return ao.toString();
    }

    private Item check(Type type) throws XQException {
        this.opened();
        if (this.it.type != type) {
            throw new BXQException("Wrong data type; % expected, % found.", this.it.type, type);
        }
        return this.it;
    }

    private long castItr(Type type) throws XQException {
        this.opened();
        try {
            double d = this.it.dbl(null);
            if (!this.it.num() || d != (double)((long)d)) {
                throw new BXQException("Number '%' is no integer.", d);
            }
            return type.e(this.it, this.ctx.ctx, null).itr(null);
        }
        catch (QueryException ex) {
            throw new BXQException((Exception)((Object)ex));
        }
    }
}

