/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.xmldb;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.basex.api.dom.BXDoc;
import org.basex.api.xmldb.BXXMLDBText;
import org.basex.data.Data;
import org.basex.data.Result;
import org.basex.io.IOFile;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.XMLSerializer;
import org.basex.query.item.ANode;
import org.basex.query.item.DBNode;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

final class BXXMLResource
implements XMLResource,
BXXMLDBText {
    private final Collection coll;
    private String id;
    private Result result;
    Object content;
    Data data;
    int pre;

    BXXMLResource(byte[] d, Collection c) {
        this.content = d;
        this.coll = c;
    }

    BXXMLResource(Result res, int p, Collection c) {
        this.result = res;
        this.coll = c;
        this.pre = p;
    }

    BXXMLResource(Data d, int p, String i, Collection c) {
        this.id = i;
        this.coll = c;
        this.data = d;
        this.pre = p;
    }

    public Collection getParentCollection() {
        return this.coll;
    }

    public String getId() {
        return this.id;
    }

    public String getResourceType() {
        return "XMLResource";
    }

    public Object getContent() throws XMLDBException {
        if (this.content == null) {
            ArrayOutput ao;
            block6: {
                try {
                    ao = new ArrayOutput();
                    XMLSerializer xml = new XMLSerializer((OutputStream)ao);
                    if (this.data != null) {
                        new DBNode(this.data, this.pre).serialize((Serializer)xml);
                        break block6;
                    }
                    if (this.result != null) {
                        this.result.serialize((Serializer)xml, this.pre);
                        break block6;
                    }
                    return null;
                }
                catch (IOException ex) {
                    throw new XMLDBException(1, ex.getMessage());
                }
            }
            this.content = ao.toArray();
        }
        return this.content instanceof byte[] ? Token.string((byte[])((byte[])this.content)) : this.content;
    }

    public void setContent(Object value) throws XMLDBException {
        if (value instanceof byte[]) {
            this.content = value;
        } else if (value instanceof String) {
            this.content = Token.token((String)value.toString());
        } else if (value instanceof File) {
            try {
                this.content = new IOFile((File)value).content();
            }
            catch (IOException ex) {
                throw new XMLDBException(1, "Content cannot be set.\n" + ex.getMessage());
            }
        } else {
            throw new XMLDBException(1, "Content cannot be set.");
        }
    }

    public String getDocumentId() throws XMLDBException {
        if (this.result != null) {
            throw new XMLDBException(1, "Document ID cannot be retrieved from query result.");
        }
        if (this.id != null) {
            return this.id;
        }
        int p = this.pre;
        while (p >= 0) {
            int k = this.data.kind(p);
            if (k == 0) {
                return Token.string((byte[])this.data.text(p, true));
            }
            p = this.data.parent(p, k);
        }
        return null;
    }

    public Node getContentAsDOM() {
        if (!(this.content instanceof Node)) {
            this.content = new BXDoc((ANode)new DBNode(this.data, this.pre));
        }
        return (Node)this.content;
    }

    public void setContentAsDOM(Node cont) throws XMLDBException {
        if (cont == null) {
            throw new XMLDBException(301);
        }
        if (!(cont instanceof Document)) {
            throw new XMLDBException(3);
        }
        this.content = cont;
    }

    public void getContentAsSAX(ContentHandler handler) throws XMLDBException {
        if (handler == null) {
            throw new XMLDBException(301);
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            XMLReader reader = factory.newSAXParser().getXMLReader();
            reader.setContentHandler(handler);
            reader.parse(new InputSource(new StringReader(this.getContent().toString())));
        }
        catch (Exception pce) {
            throw new XMLDBException(1, pce.getMessage());
        }
    }

    public ContentHandler setContentAsSAX() throws XMLDBException {
        try {
            return new BXSAXContentHandler(this);
        }
        catch (IOException ex) {
            throw new XMLDBException(1, ex.getMessage());
        }
    }

    private static final class BXSAXContentHandler
    extends DefaultHandler {
        private final HashMap<String, String> ns = new HashMap();
        private final ArrayOutput out = new ArrayOutput();
        private final XMLSerializer xml = new XMLSerializer((OutputStream)this.out);
        private final BXXMLResource res;

        BXSAXContentHandler(BXXMLResource r) throws IOException {
            this.res = r;
        }

        @Override
        public void characters(char[] ac, int i, int j) throws SAXException {
            try {
                TokenBuilder tb = new TokenBuilder();
                int k = 0;
                while (k < j) {
                    tb.add((int)ac[i + k]);
                    ++k;
                }
                this.xml.text(tb.finish());
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }

        @Override
        public void endDocument() {
            this.res.content = this.out.toArray();
        }

        @Override
        public void endElement(String s, String s1, String s2) throws SAXException {
            try {
                this.xml.closeElement();
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ac, int i, int j) throws SAXException {
            this.characters(ac, i, j);
        }

        @Override
        public void processingInstruction(String s, String s1) throws SAXException {
            try {
                this.xml.pi(Token.token((String)s), s1 != null ? Token.token((String)s1) : Token.EMPTY);
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }

        @Override
        public void startElement(String s, String s1, String s2, Attributes atts) throws SAXException {
            try {
                this.xml.openElement(Token.token((String)s2), (byte[][])new byte[0][]);
                int i = 0;
                while (i < atts.getLength()) {
                    this.xml.attribute(Token.token((String)atts.getQName(i)), Token.token((String)atts.getValue(i)));
                    ++i;
                }
                for (Map.Entry<String, String> e : this.ns.entrySet()) {
                    this.xml.attribute(Token.concat((byte[])Token.XMLNSC, (byte[])Token.token((String)e.getKey())), Token.token((String)e.getValue()));
                }
            }
            catch (IOException ex) {
                throw new SAXException(ex);
            }
        }

        @Override
        public void startPrefixMapping(String s, String s1) {
            this.ns.put(s, s1);
        }

        @Override
        public void endPrefixMapping(String s) {
            this.ns.remove(s);
        }
    }
}

