/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public final class BaseXClient {
    final Map<String, EventNotifier> notifiers = new HashMap<String, EventNotifier>();
    final OutputStream out;
    private final Socket socket = new Socket();
    private final BufferedInputStream in;
    private String info;
    Socket esocket;
    String ehost;

    public BaseXClient(String host, int port, String usern, String pw) throws IOException {
        this.socket.connect(new InetSocketAddress(host, port), 5000);
        this.in = new BufferedInputStream(this.socket.getInputStream());
        this.out = this.socket.getOutputStream();
        this.ehost = host;
        String ts = this.receive();
        this.send(usern);
        this.send(BaseXClient.md5(String.valueOf(BaseXClient.md5(pw)) + ts));
        if (!this.ok()) {
            throw new IOException("Access denied.");
        }
    }

    public void execute(String cmd, OutputStream o) throws IOException {
        this.send(cmd);
        this.receive(o);
        this.info = this.receive();
        if (!this.ok()) {
            throw new IOException(this.info);
        }
    }

    public String execute(String cmd) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.execute(cmd, os);
        return os.toString("UTF-8");
    }

    public Query query(String query) throws IOException {
        return new Query(query);
    }

    public void create(String name, InputStream input) throws IOException {
        this.out.write(8);
        this.send(name);
        this.send(input);
    }

    public void add(String name, String target, InputStream input) throws IOException {
        this.out.write(9);
        this.send(name);
        this.send(target);
        this.send(input);
    }

    public void watch(String name, EventNotifier notifier) throws IOException {
        this.out.write(10);
        this.send(name);
        if (this.esocket == null) {
            int eport = Integer.parseInt(this.receive());
            this.esocket = new Socket();
            this.esocket.connect(new InetSocketAddress(this.ehost, eport), 5000);
            OutputStream os = this.esocket.getOutputStream();
            this.receive(this.in, os);
            os.write(0);
            os.flush();
            this.listen(this.esocket.getInputStream());
        }
        this.info = this.receive();
        if (!this.ok()) {
            throw new IOException(this.info);
        }
        this.notifiers.put(name, notifier);
    }

    private void listen(final InputStream is) {
        new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        BufferedInputStream bi = new BufferedInputStream(is);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        BaseXClient.this.receive(bi, baos);
                        String name = baos.toString("UTF-8");
                        baos = new ByteArrayOutputStream();
                        BaseXClient.this.receive(bi, baos);
                        String data = baos.toString("UTF-8");
                        BaseXClient.this.notifiers.get(name).notify(data);
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }
        }.start();
    }

    public void unwatch(String name) throws IOException {
        this.out.write(11);
        this.send(name);
        this.info = this.receive();
        if (!this.ok()) {
            throw new IOException(this.info);
        }
        this.notifiers.remove(name);
    }

    private void send(InputStream input) throws IOException {
        int b;
        BufferedInputStream bis = new BufferedInputStream(input);
        BufferedOutputStream bos = new BufferedOutputStream(this.out);
        while ((b = bis.read()) != -1) {
            bos.write(b);
        }
        bos.write(0);
        bos.flush();
        this.info = this.receive();
        if (!this.ok()) {
            throw new IOException(this.info);
        }
    }

    public String info() {
        return this.info;
    }

    public void close() throws IOException {
        this.send("exit");
        this.out.flush();
        if (this.esocket != null) {
            this.esocket.close();
        }
        this.socket.close();
    }

    boolean ok() throws IOException {
        this.out.flush();
        return this.in.read() == 0;
    }

    String receive() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.receive(os);
        return os.toString("UTF-8");
    }

    void send(String s) throws IOException {
        this.out.write((String.valueOf(s) + '\u0000').getBytes("UTF8"));
    }

    void receive(BufferedInputStream bis, OutputStream o) throws IOException {
        int b;
        while ((b = bis.read()) != 0 && b != -1) {
            o.write(b);
        }
    }

    private void receive(OutputStream o) throws IOException {
        int b;
        this.out.flush();
        while ((b = this.in.read()) != 0 && b != -1) {
            o.write(b);
        }
    }

    private static String md5(String pw) {
        StringBuilder sb = new StringBuilder();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(pw.getBytes());
            byte[] byArray = md.digest();
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                String s = Integer.toHexString(b & 0xFF);
                if (s.length() == 1) {
                    sb.append('0');
                }
                sb.append(s);
                ++n2;
            }
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
        return sb.toString();
    }

    public static interface EventNotifier {
        public void notify(String var1);
    }

    public final class Query {
        private final String id;
        private String next;

        public Query(String query) throws IOException {
            this.id = this.exec(0, query);
        }

        public String init() throws IOException {
            return this.exec(4, this.id);
        }

        public void bind(String name, String value) throws IOException {
            this.exec(3, String.valueOf(this.id) + '\u0000' + name + '\u0000' + value + '\u0000');
        }

        public boolean more() throws IOException {
            this.next = this.exec(1, this.id);
            return this.next.length() != 0;
        }

        public String next() {
            return this.next;
        }

        public String execute() throws IOException {
            return this.exec(5, this.id);
        }

        public String info() throws IOException {
            return this.exec(6, this.id);
        }

        public String close() throws IOException {
            String s = this.exec(2, this.id);
            BaseXClient.this.out.flush();
            return s;
        }

        private String exec(int cmd, String arg) throws IOException {
            BaseXClient.this.out.write(cmd);
            BaseXClient.this.send(arg);
            String s = BaseXClient.this.receive();
            if (!BaseXClient.this.ok()) {
                throw new IOException(BaseXClient.this.receive());
            }
            return s;
        }
    }
}

