/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.validation.validator;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.wicket.util.parse.metapattern.MetaPattern;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.validator.StringValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternValidator
extends StringValidator {
    private static final long serialVersionUID = 1L;
    private final Pattern pattern;
    private boolean reverse = false;

    public PatternValidator(String pattern) {
        this(Pattern.compile(pattern));
    }

    public PatternValidator(String pattern, int flags) {
        this(Pattern.compile(pattern, flags));
    }

    public PatternValidator(Pattern pattern) {
        this.pattern = pattern;
    }

    public PatternValidator(MetaPattern pattern) {
        this(pattern.pattern());
    }

    public final Pattern getPattern() {
        return this.pattern;
    }

    public PatternValidator setReverse(boolean reverse) {
        this.reverse = reverse;
        return this;
    }

    @Override
    protected Map<String, Object> variablesMap(IValidatable<String> validatable) {
        Map<String, Object> map = super.variablesMap(validatable);
        map.put("pattern", this.pattern.pattern());
        return map;
    }

    public String toString() {
        return "[PatternValidator pattern = " + this.pattern + "]";
    }

    @Override
    protected void onValidate(IValidatable<String> validatable) {
        if (this.pattern.matcher(validatable.getValue()).matches() == this.reverse) {
            this.error(validatable);
        }
    }
}

