/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource.filtering;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.resource.filtering.HeaderResponseContainerFilteringHeaderResponse;

public class HeaderResponseFilteredResponseContainer
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private final String filterName;

    public HeaderResponseFilteredResponseContainer(String id, String filterName) {
        super(id);
        this.filterName = filterName;
        this.setRenderBodyOnly(true);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.setType(XmlTag.TagType.OPEN);
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        HeaderResponseContainerFilteringHeaderResponse response = HeaderResponseContainerFilteringHeaderResponse.get();
        if (!response.isClosed()) {
            throw new RuntimeException("there was an error processing the header response - you tried to render a bucket of response from HeaderResponseContainerFilteringHeaderResponse, but it had not yet run and been closed.  this should occur when the header container that is standard in wicket renders, so perhaps you have done something to keep that from rendering?");
        }
        CharSequence foot = response.getContent(this.filterName);
        this.replaceComponentTagBody(markupStream, openTag, foot);
    }
}

