/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource.aggregation;

import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.dependencies.AbstractResourceDependentResourceReference;

public class ResourceReferenceAndStringData {
    private final ResourceReference reference;
    private final PageParameters parameters;
    private final String url;
    private final String idOrMedia;
    private final AbstractResourceDependentResourceReference.ResourceType type;
    private final boolean jsDefer;
    private final String charset;
    private final String cssCondition;
    private final CharSequence content;

    public ResourceReferenceAndStringData(ResourceReference reference, PageParameters parameters, String url, String idOrMedia, AbstractResourceDependentResourceReference.ResourceType type, boolean jsDefer, String charset, String cssCondition) {
        this.reference = reference;
        this.parameters = parameters;
        this.url = url;
        this.idOrMedia = idOrMedia;
        this.type = type;
        this.jsDefer = jsDefer;
        this.charset = charset;
        this.cssCondition = cssCondition;
        this.content = null;
    }

    @Deprecated
    public ResourceReferenceAndStringData(ResourceReference reference, String idOrMedia, boolean isCss) {
        this.reference = reference;
        this.parameters = null;
        this.url = null;
        this.idOrMedia = idOrMedia;
        this.type = isCss ? AbstractResourceDependentResourceReference.ResourceType.CSS : AbstractResourceDependentResourceReference.ResourceType.JS;
        this.jsDefer = false;
        this.charset = null;
        this.cssCondition = null;
        this.content = null;
    }

    public ResourceReferenceAndStringData(CharSequence content, AbstractResourceDependentResourceReference.ResourceType type, String idOrMedia) {
        this.content = content;
        this.type = type;
        this.reference = null;
        this.parameters = null;
        this.url = null;
        this.idOrMedia = idOrMedia;
        this.jsDefer = false;
        this.charset = null;
        this.cssCondition = null;
    }

    public ResourceReference getReference() {
        return this.reference;
    }

    public PageParameters getParameters() {
        return this.parameters;
    }

    public String getUrl() {
        return this.url;
    }

    public String getIdOrMedia() {
        return this.idOrMedia;
    }

    @Deprecated
    public String getString() {
        return this.getIdOrMedia();
    }

    @Deprecated
    public boolean isCss() {
        return this.type == AbstractResourceDependentResourceReference.ResourceType.CSS;
    }

    public AbstractResourceDependentResourceReference.ResourceType getResourceType() {
        return this.type;
    }

    public boolean isJsDefer() {
        return this.jsDefer;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getCssCondition() {
        return this.cssCondition;
    }

    public CharSequence getContent() {
        return this.content;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.charset == null ? 0 : this.charset.hashCode());
        result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
        result = 31 * result + (this.cssCondition == null ? 0 : this.cssCondition.hashCode());
        result = 31 * result + (this.idOrMedia == null ? 0 : this.idOrMedia.hashCode());
        result = 31 * result + (this.jsDefer ? 1231 : 1237);
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.reference == null ? 0 : this.reference.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceReferenceAndStringData other = (ResourceReferenceAndStringData)obj;
        if (this.charset == null ? other.charset != null : !this.charset.equals(other.charset)) {
            return false;
        }
        if (this.content == null ? other.content != null : !this.content.equals(other.content)) {
            return false;
        }
        if (this.cssCondition == null ? other.cssCondition != null : !this.cssCondition.equals(other.cssCondition)) {
            return false;
        }
        if (this.idOrMedia == null ? other.idOrMedia != null : !this.idOrMedia.equals(other.idOrMedia)) {
            return false;
        }
        if (this.jsDefer != other.jsDefer) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals((Object)other.parameters)) {
            return false;
        }
        if (this.reference == null ? other.reference != null : !this.reference.equals(other.reference)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }

    public String toString() {
        return "ResourceReferenceAndStringData [reference=" + this.reference + ", parameters=" + this.parameters + ", url=" + this.url + ", idOrMedia=" + this.idOrMedia + ", type=" + (Object)((Object)this.type) + ", jsDefer=" + this.jsDefer + ", charset=" + this.charset + ", cssCondition=" + this.cssCondition + ", content=" + this.content + "]";
    }
}

