/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.resolver;

import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.resolver.IComponentResolver;

public class ComponentResolvers {
    private ComponentResolvers() {
    }

    public static Component resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag, ResolverFilter filter) {
        Component component = ComponentResolvers.resolveByComponentHierarchy(container, markupStream, tag);
        if (component == null) {
            component = ComponentResolvers.resolveByApplication(container, markupStream, tag, filter);
        }
        return component;
    }

    private static Component resolveByApplication(MarkupContainer container, MarkupStream markupStream, ComponentTag tag, ResolverFilter filter) {
        for (IComponentResolver resolver : Application.get().getPageSettings().getComponentResolvers()) {
            Component component;
            if (filter != null && filter.ignoreResolver(resolver) || (component = resolver.resolve(container, markupStream, tag)) == null) continue;
            return component;
        }
        return null;
    }

    private static Component resolveByComponentHierarchy(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        for (MarkupContainer cursor = container; cursor != null; cursor = cursor.getParent()) {
            IComponentResolver resolver;
            Component component;
            if (!(cursor instanceof IComponentResolver) || (component = (resolver = (IComponentResolver)((Object)cursor)).resolve(container, markupStream, tag)) == null) continue;
            return component;
        }
        return null;
    }

    public static interface ResolverFilter {
        public boolean ignoreResolver(IComponentResolver var1);
    }
}

