/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.WicketParseException;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.markup.parser.filter.WicketTagIdentifier;

public final class WicketRemoveTagHandler
extends AbstractMarkupFilter {
    public static final String REMOVE = "remove";

    protected final MarkupElement onComponentTag(ComponentTag tag) throws ParseException {
        MarkupElement markupElement;
        if (!(tag instanceof WicketTag) || !((WicketTag)tag).isRemoveTag()) {
            return tag;
        }
        if (tag.isOpenClose()) {
            throw new WicketParseException("Wicket remove tag must not be an open-close tag:", tag);
        }
        while ((markupElement = this.getNextFilter().nextElement()) != null) {
            ComponentTag closeTag;
            if (!(markupElement instanceof ComponentTag) || (closeTag = (ComponentTag)markupElement).getId() == null) continue;
            if (closeTag.closes(tag)) {
                tag.setIgnore(true);
                return tag;
            }
            throw new WicketParseException("Markup remove regions must not contain Wicket component tags:", closeTag);
        }
        throw new WicketParseException("Did not find close tag for markup remove region. Open tag:", tag);
    }

    static {
        WicketTagIdentifier.registerWellKnownTagName(REMOVE);
    }
}

