/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.ajax;

import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AjaxEventBehavior
extends AbstractDefaultAjaxBehavior {
    private static final Logger LOG = LoggerFactory.getLogger(AjaxEventBehavior.class);
    private static long sequence = 0L;
    private static final long serialVersionUID = 1L;
    private final String event;
    private ThrottlingSettings throttlingSettings;

    public AjaxEventBehavior(String event) {
        if (Strings.isEmpty((CharSequence)event)) {
            throw new IllegalArgumentException("argument [event] cannot be null or empty");
        }
        this.onCheckEvent(event);
        this.event = event;
    }

    public final AjaxEventBehavior setThrottleDelay(Duration throttleDelay) {
        this.throttlingSettings = new ThrottlingSettings("th" + ++sequence, throttleDelay);
        return this;
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        Component myComponent = this.getComponent();
        if (myComponent.isEnabledInHierarchy()) {
            String attribute;
            if (LOG.isWarnEnabled() && myComponent.getApplication().usesDevelopmentConfig() && !Strings.isEmpty((CharSequence)(attribute = tag.getAttribute(this.event)))) {
                LOG.warn("{} assigned to {} is overriding the previous value of the inline attribute. Maybe there are several Ajax event behaviors on the same type assigned to this component.", new Object[]{this, myComponent});
            }
            tag.put(this.event, this.getEventHandler());
        }
    }

    protected CharSequence getEventHandler() {
        CharSequence handler = this.getCallbackScript();
        if (this.event.equalsIgnoreCase("href")) {
            handler = "javascript:" + handler;
        }
        return handler;
    }

    protected CharSequence generateCallbackScript(CharSequence partialCall) {
        CharSequence script = super.generateCallbackScript(partialCall);
        ThrottlingSettings ts = this.throttlingSettings;
        if (ts != null) {
            script = AbstractDefaultAjaxBehavior.throttleScript(script, ts.getId(), ts.getDelay());
        }
        return script;
    }

    protected void onCheckEvent(String event) {
    }

    public final String getEvent() {
        return this.event;
    }

    protected final void respond(AjaxRequestTarget target) {
        this.onEvent(target);
    }

    protected abstract void onEvent(AjaxRequestTarget var1);

    public String toString() {
        return this.getClass().getName() + " {" + "event='" + this.event + '\'' + '}';
    }

    private static class ThrottlingSettings
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        private final Duration delay;
        private final String id;

        public ThrottlingSettings(String id, Duration delay) {
            this.id = id;
            this.delay = delay;
        }

        public Duration getDelay() {
            return this.delay;
        }

        public String getId() {
            return this.id;
        }
    }
}

