/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DOMNodeList;
import net.sf.saxon.dom.DOMSender;
import net.sf.saxon.dom.DOMWriter;
import net.sf.saxon.dom.DocumentOverNodeInfo;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExternalObjectModel;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.wrapper.VirtualNode;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMObjectModel
implements ExternalObjectModel,
Serializable {
    private static DOMObjectModel THE_INSTANCE = new DOMObjectModel();
    private static final DocumentBuilder docBuilder;

    public static DOMObjectModel getInstance() {
        return THE_INSTANCE;
    }

    @Override
    public String getIdentifyingURI() {
        return "http://java.sun.com/jaxp/xpath/dom";
    }

    @Override
    public PJConverter getPJConverter(Class clazz) {
        if (Node.class.isAssignableFrom(clazz) && !NodeOverNodeInfo.class.isAssignableFrom(clazz)) {
            return new PJConverter(){

                @Override
                public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
                    return DOMObjectModel.convertXPathValueToObject(Value.asValue(valueRepresentation), clazz);
                }
            };
        }
        if (NodeList.class == clazz) {
            return new PJConverter(){

                @Override
                public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
                    return DOMObjectModel.convertXPathValueToObject(Value.asValue(valueRepresentation), clazz);
                }
            };
        }
        return null;
    }

    @Override
    public JPConverter getJPConverter(Class clazz) {
        if (Node.class.isAssignableFrom(clazz) && !NodeOverNodeInfo.class.isAssignableFrom(clazz)) {
            return new JPConverter(){

                @Override
                public ValueRepresentation convert(Object object, XPathContext xPathContext) throws XPathException {
                    return DOMObjectModel.this.wrapOrUnwrapNode((Node)object, xPathContext.getConfiguration());
                }

                @Override
                public ItemType getItemType() {
                    return AnyNodeTest.getInstance();
                }
            };
        }
        if (NodeList.class.isAssignableFrom(clazz)) {
            return new JPConverter(){

                @Override
                public ValueRepresentation convert(Object object, XPathContext xPathContext) throws XPathException {
                    Configuration configuration = xPathContext.getConfiguration();
                    NodeList nodeList = (NodeList)object;
                    int n = nodeList.getLength();
                    Item[] itemArray = new NodeInfo[n];
                    for (int i = 0; i < n; ++i) {
                        itemArray[i] = DOMObjectModel.this.wrapOrUnwrapNode(nodeList.item(i), configuration);
                    }
                    return new SequenceExtent(itemArray);
                }

                @Override
                public ItemType getItemType() {
                    return AnyNodeTest.getInstance();
                }

                @Override
                public int getCardinality() {
                    return 57344;
                }
            };
        }
        if (DOMSource.class == clazz) {
            return new JPConverter(){

                @Override
                public ValueRepresentation convert(Object object, XPathContext xPathContext) throws XPathException {
                    return DOMObjectModel.this.unravel((DOMSource)object, xPathContext.getConfiguration());
                }

                @Override
                public ItemType getItemType() {
                    return AnyNodeTest.getInstance();
                }
            };
        }
        return null;
    }

    @Override
    public PJConverter getNodeListCreator(Object object) {
        if (object == null || object instanceof Node || object instanceof DOMSource || object instanceof VirtualNode && ((VirtualNode)object).getRealNode() instanceof Node) {
            return new PJConverter(){

                @Override
                public Object convert(ValueRepresentation valueRepresentation, Class clazz, XPathContext xPathContext) throws XPathException {
                    return DOMObjectModel.convertXPathValueToObject(Value.asValue(valueRepresentation), NodeList.class);
                }
            };
        }
        return null;
    }

    @Override
    public Receiver getDocumentBuilder(Result result) throws XPathException {
        if (result instanceof DOMResult) {
            DOMWriter dOMWriter = new DOMWriter();
            Node node = ((DOMResult)result).getNode();
            if (node instanceof NodeOverNodeInfo && !(((NodeOverNodeInfo)node).getUnderlyingNodeInfo() instanceof MutableNodeInfo)) {
                throw new XPathException("Supplied DOMResult is a non-mutable Saxon implementation");
            }
            Node node2 = ((DOMResult)result).getNextSibling();
            if (node == null) {
                Document document = docBuilder.newDocument();
                ((DOMResult)result).setNode(document);
                dOMWriter.setNode(document);
            } else {
                dOMWriter.setNode(node);
                dOMWriter.setNextSibling(node2);
            }
            return dOMWriter;
        }
        return null;
    }

    @Override
    public boolean sendSource(Source source, Receiver receiver) throws XPathException {
        if (source instanceof DOMSource) {
            Node node = ((DOMSource)source).getNode();
            DOMSender dOMSender = new DOMSender(node, receiver);
            dOMSender.setSystemId(source.getSystemId());
            dOMSender.send();
            return true;
        }
        return false;
    }

    public NodeInfo wrap(Node node, Configuration configuration) {
        Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        DocumentWrapper documentWrapper = new DocumentWrapper((Node)document, node.getBaseURI(), configuration);
        return documentWrapper.wrap(node);
    }

    public NodeInfo copy(Node node, TreeModel treeModel, Configuration configuration) throws XPathException {
        PipelineConfiguration pipelineConfiguration = configuration.makePipelineConfiguration();
        Builder builder = treeModel.makeBuilder(pipelineConfiguration);
        Sender.send(new DOMSource(node), builder, null);
        return builder.getCurrentRoot();
    }

    @Override
    public NodeInfo unravel(Source source, Configuration configuration) {
        Node node;
        if (source instanceof DOMSource && !((node = ((DOMSource)source).getNode()) instanceof NodeOverNodeInfo)) {
            Document document = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
            DocumentWrapper documentWrapper = new DocumentWrapper((Node)document, source.getSystemId(), configuration);
            return documentWrapper.wrap(node);
        }
        return null;
    }

    private NodeInfo wrapOrUnwrapNode(Node node, Configuration configuration) throws XPathException {
        if (node instanceof NodeOverNodeInfo) {
            return ((NodeOverNodeInfo)node).getUnderlyingNodeInfo();
        }
        DocumentInfo documentInfo = this.wrapDocument(node, "", configuration);
        return this.wrapNode(documentInfo, node);
    }

    public static Object convertXPathValueToObject(ValueRepresentation valueRepresentation, Object object) throws XPathException {
        Item item;
        boolean bl;
        Class clazz = (Class)object;
        boolean bl2 = Node.class.isAssignableFrom(clazz) || clazz == NodeList.class || clazz.isArray() && Node.class.isAssignableFrom(clazz.getComponentType());
        boolean bl3 = bl = clazz == Object.class || clazz.isAssignableFrom(ArrayList.class) || clazz.isAssignableFrom(HashSet.class) || clazz.isArray() && clazz.getComponentType() == Object.class;
        if (!bl2 && !bl) {
            return null;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>(20);
        SequenceIterator sequenceIterator = Value.asIterator(valueRepresentation);
        while ((item = sequenceIterator.next()) != null) {
            if (item instanceof VirtualNode) {
                Object object2 = ((VirtualNode)item).getRealNode();
                if (object2 instanceof Node) {
                    arrayList.add((Node)object2);
                    continue;
                }
                if (!bl2) continue;
                throw new XPathException("Cannot convert XPath value to Java object: required class is " + clazz.getName() + "; supplied value has type " + Type.displayTypeName(item));
            }
            if (bl2) {
                if (item instanceof NodeInfo) {
                    arrayList.add(NodeOverNodeInfo.wrap((NodeInfo)item));
                    continue;
                }
                throw new XPathException("Cannot convert XPath value to Java object: required class is " + clazz.getName() + "; supplied value has type " + Type.displayTypeName(item));
            }
            return null;
        }
        if (arrayList.isEmpty() && !bl2) {
            return null;
        }
        if (Node.class.isAssignableFrom(clazz)) {
            if (arrayList.size() != 1) {
                throw new XPathException("Cannot convert XPath value to Java object: requires a single DOM Nodebut supplied value contains " + arrayList.size() + " nodes");
            }
            return arrayList.get(0);
        }
        if (clazz == NodeList.class) {
            return new DOMNodeList(arrayList);
        }
        if (clazz.isArray() && clazz.getComponentType() == Node.class) {
            return arrayList.toArray(new Node[arrayList.size()]);
        }
        if (clazz.isAssignableFrom(ArrayList.class)) {
            return arrayList;
        }
        if (clazz.isAssignableFrom(HashSet.class)) {
            return new HashSet<Node>(arrayList);
        }
        return null;
    }

    private DocumentInfo wrapDocument(Object object, String string, Configuration configuration) {
        if (object instanceof DocumentOverNodeInfo) {
            return (DocumentInfo)((DocumentOverNodeInfo)object).getUnderlyingNodeInfo();
        }
        if (object instanceof NodeOverNodeInfo) {
            return ((NodeOverNodeInfo)object).getUnderlyingNodeInfo().getDocumentRoot();
        }
        if (object instanceof Node) {
            if (((Node)object).getNodeType() == 9) {
                Document document = (Document)object;
                return new DocumentWrapper((Node)document, string, configuration);
            }
            if (((Node)object).getNodeType() == 11) {
                DocumentFragment documentFragment = (DocumentFragment)object;
                return new DocumentWrapper((Node)documentFragment, string, configuration);
            }
            Document document = ((Node)object).getOwnerDocument();
            return new DocumentWrapper((Node)document, string, configuration);
        }
        throw new IllegalArgumentException("Unknown node class " + object.getClass());
    }

    private NodeInfo wrapNode(DocumentInfo documentInfo, Object object) {
        return ((DocumentWrapper)documentInfo).wrap((Node)object);
    }

    static {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException("Couldn't create this shit, reason: " + parserConfigurationException.getMessage(), parserConfigurationException);
        }
    }
}

