/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.util.EnumSet;
import org.basex.util.ft.FTIterator;
import org.basex.util.ft.Language;
import org.basex.util.ft.StemDir;
import org.basex.util.ft.Stemmer;

final class DictStemmer
extends Stemmer {
    final StemDir dict;

    DictStemmer(StemDir d, FTIterator fti) {
        super(fti);
        this.dict = d;
    }

    @Override
    Stemmer get(Language l, FTIterator fti) {
        return new DictStemmer(this.dict, fti);
    }

    @Override
    int prec() {
        return 1001;
    }

    @Override
    byte[] stem(byte[] word) {
        return this.dict.stem(word);
    }

    @Override
    EnumSet<Language> languages() {
        return EnumSet.allOf(Language.class);
    }
}

