/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import org.basex.util.Array;
import org.basex.util.Token;

public final class Undo {
    private static final int MAX = 200;
    private final byte[][] hist = new byte[200][];
    private final int[] cur = new int[200];
    private int max;
    private int pos;

    public Undo() {
        this.hist[0] = Token.EMPTY;
    }

    public boolean first() {
        return this.pos == 0;
    }

    public boolean last() {
        return this.pos == this.max;
    }

    public byte[] prev() {
        return this.hist[this.pos == 0 ? this.pos : (this.pos = this.pos - 1)];
    }

    public byte[] next() {
        return this.hist[this.pos == this.max ? this.pos : (this.pos = this.pos + 1)];
    }

    public int cursor() {
        return this.cur[this.pos];
    }

    public void cursor(int c) {
        this.cur[this.pos] = Math.min(this.hist[this.pos].length, c);
    }

    public void store(byte[] str, int c) {
        if (Token.eq(str, this.hist[this.pos])) {
            return;
        }
        if (this.pos + 1 == 200) {
            Array.move(this.hist, 1, -1, this.pos);
            Array.move(this.cur, 1, -1, this.pos--);
        }
        this.hist[++this.pos] = str;
        this.cur[this.pos] = c;
        this.max = this.pos;
    }

    public void reset(byte[] text) {
        this.hist[0] = text;
        this.pos = 0;
        this.max = 0;
    }
}

