/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.pkg;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.Zip;
import org.basex.query.QueryException;
import org.basex.query.util.Err;
import org.basex.query.util.pkg.Package;
import org.basex.query.util.pkg.PkgParser;
import org.basex.query.util.pkg.PkgValidator;
import org.basex.query.util.pkg.Repo;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public final class RepoManager {
    private final Repo repo;

    public RepoManager(Repo r) {
        this.repo = r;
    }

    public void install(String path, InputInfo ii) throws QueryException {
        IO io = IO.get(path);
        IOContent cont = null;
        try {
            cont = new IOContent(io.content());
        }
        catch (IOException ex) {
            Util.debug(ex);
            Err.PKGNOTEXIST.thrw(ii, path);
        }
        try {
            Zip zip = new Zip(cont);
            byte[] dsc = zip.read("expath-pkg.xml");
            Package pkg = new PkgParser(this.repo, ii).parse(new IOContent(dsc));
            new PkgValidator(this.repo, ii).check(pkg);
            IOFile file = this.uniqueDir(Token.string(pkg.uniqueName()).replaceAll("[^\\w.-]+", "-"));
            zip.unzip(file);
            this.repo.add(pkg, file.name());
        }
        catch (FileNotFoundException ex) {
            Util.debug(ex);
            Err.PKGREADFNF.thrw(ii, io.name(), ex.getMessage());
        }
        catch (IOException ex) {
            Util.debug(ex);
            Err.PKGREADFAIL.thrw(ii, io.name(), ex.getMessage());
        }
    }

    private IOFile uniqueDir(String n) {
        String nm = n;
        int c = 0;
        IOFile io;
        while ((io = this.repo.path(nm)).exists()) {
            nm = String.valueOf(n) + '-' + ++c;
        }
        return io;
    }

    public void delete(String pkg, InputInfo ii) throws QueryException {
        boolean found = false;
        for (byte[] nextPkg : this.repo.pkgDict()) {
            if (nextPkg == null) continue;
            byte[] dir = this.repo.pkgDict().get(nextPkg);
            if (!Token.eq(Package.name(nextPkg), Token.token(pkg)) && !Token.eq(dir, Token.token(pkg))) continue;
            found = true;
            byte[] primPkg = this.primary(nextPkg, ii);
            if (primPkg != null) {
                Err.PKGDEP.thrw(ii, Token.string(primPkg), pkg);
            }
            IOFile f = this.repo.path(Token.string(dir));
            IOFile desc = new IOFile(f, "expath-pkg.xml");
            this.repo.remove(new PkgParser(this.repo, ii).parse(desc));
            if (f.delete()) continue;
            Err.CANNOTDELPKG.thrw(ii, new Object[0]);
        }
        if (!found) {
            Err.PKGNOTEXIST.thrw(ii, pkg);
        }
    }

    private byte[] primary(byte[] pkgName, InputInfo ii) throws QueryException {
        for (byte[] nextPkg : this.repo.pkgDict()) {
            if (nextPkg == null || Token.eq(nextPkg, pkgName)) continue;
            IOFile desc = new IOFile(this.repo.path(Token.string(this.repo.pkgDict().get(nextPkg))), "expath-pkg.xml");
            Package pkg = new PkgParser(this.repo, ii).parse(desc);
            byte[] name = Package.name(pkgName);
            for (Package.Dependency dep : pkg.dep) {
                if (dep.pkg == null || !Token.eq(dep.pkg, name)) continue;
                return Package.name(nextPkg);
            }
        }
        return null;
    }
}

