/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.path;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.item.ANode;
import org.basex.query.item.NodeType;
import org.basex.query.item.QNm;
import org.basex.query.path.KindTest;
import org.basex.util.Util;

public abstract class Test {
    public static final Test TXT = new KindTest(NodeType.TXT);
    public static final Test PI = new KindTest(NodeType.PI);
    public static final Test ELM = new KindTest(NodeType.ELM);
    public static final Test DOC = new KindTest(NodeType.DOC);
    public static final Test ATT = new KindTest(NodeType.ATT);
    public static final Test COM = new KindTest(NodeType.COM);
    public static final Test NOD = new Test(){

        @Override
        public boolean eval(ANode node) {
            return true;
        }

        public String toString() {
            return NodeType.NOD.toString();
        }
    };
    public NodeType type;
    public Name test;
    public QNm name;
    protected final QNm tmpq = new QNm();

    public static Test get(NodeType t) {
        switch (t) {
            case TXT: {
                return TXT;
            }
            case PI: {
                return PI;
            }
            case ELM: {
                return ELM;
            }
            case DOC: {
                return DOC;
            }
            case ATT: {
                return ATT;
            }
            case COM: {
                return COM;
            }
            case NOD: {
                return NOD;
            }
        }
        throw Util.notexpected(new Object[0]);
    }

    public boolean comp(QueryContext ctx) throws QueryException {
        return true;
    }

    public abstract boolean eval(ANode var1);

    public final boolean sameAs(Test t) {
        return this.test == t.test && this.type == t.type && (this.name == t.name || this.name.eq(t.name));
    }

    public static enum Name {
        ALL,
        NAME,
        NS,
        STD;

    }
}

