/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item.map;

import org.basex.query.QueryException;
import org.basex.query.item.AtomType;
import org.basex.query.item.Item;
import org.basex.query.item.SeqType;
import org.basex.query.item.Value;
import org.basex.query.item.map.Branch;
import org.basex.query.item.map.List;
import org.basex.query.item.map.TrieNode;
import org.basex.query.iter.ItemCache;
import org.basex.util.Array;
import org.basex.util.InputInfo;

final class Leaf
extends TrieNode {
    final int hash;
    final Item key;
    final Value value;

    Leaf(int h, Item k, Value v) {
        super(1);
        this.hash = h;
        this.key = k;
        this.value = v;
        assert (this.verify());
    }

    @Override
    TrieNode insert(int h, Item k, Value v, int l, InputInfo ii) throws QueryException {
        int used;
        int b;
        if (h == this.hash) {
            return Leaf.eq(k, this.key, ii) ? new Leaf(h, k, v) : new List(this.hash, this.key, this.value, k, v);
        }
        TrieNode[] ch = new TrieNode[32];
        int a = Leaf.key(h, l);
        if (a != (b = Leaf.key(this.hash, l))) {
            ch[a] = new Leaf(h, k, v);
            ch[b] = this;
            used = 1 << a | 1 << b;
        } else {
            ch[a] = this.insert(h, k, v, l + 1, ii);
            used = 1 << a;
        }
        return new Branch(ch, used, 2);
    }

    @Override
    TrieNode delete(int h, Item k, int l, InputInfo ii) throws QueryException {
        return h == this.hash && Leaf.eq(this.key, k, ii) ? null : this;
    }

    @Override
    Value get(int h, Item k, int l, InputInfo ii) throws QueryException {
        return h == this.hash && Leaf.eq(this.key, k, ii) ? this.value : null;
    }

    @Override
    boolean contains(int h, Item k, int l, InputInfo ii) throws QueryException {
        return h == this.hash && Leaf.eq(this.key, k, ii);
    }

    @Override
    StringBuilder toString(StringBuilder sb, String ind) {
        return sb.append(ind).append("`-- ").append(this.key).append(" => ").append(this.value).append('\n');
    }

    @Override
    TrieNode addAll(TrieNode o, int l, InputInfo ii) throws QueryException {
        return o.add(this, l, ii);
    }

    @Override
    TrieNode add(Leaf o, int l, InputInfo ii) throws QueryException {
        int nu;
        int ok;
        if (this.hash == o.hash) {
            return Leaf.eq(this.key, o.key, ii) ? this : new List(this.hash, this.key, this.value, o.key, o.value);
        }
        TrieNode[] ch = new TrieNode[32];
        int k = Leaf.key(this.hash, l);
        if (k == (ok = Leaf.key(o.hash, l))) {
            ch[k] = this.add(o, l + 1, ii);
            nu = 1 << k;
        } else {
            ch[k] = this;
            ch[ok] = o;
            nu = 1 << k | 1 << ok;
        }
        return new Branch(ch, nu, 2);
    }

    @Override
    TrieNode add(List o, int l, InputInfo ii) throws QueryException {
        int nu;
        int ok;
        if (this.hash == o.hash) {
            int i = 0;
            while (i < o.size) {
                if (Leaf.eq(this.key, o.keys[i], ii)) {
                    Item[] ks = (Item[])o.keys.clone();
                    Value[] vs = (Value[])o.values.clone();
                    ks[i] = this.key;
                    vs[i] = this.value;
                    return new List(this.hash, ks, vs);
                }
                ++i;
            }
            return new List(this.hash, Array.add(o.keys, this.key), Array.add(o.values, this.value));
        }
        TrieNode[] ch = new TrieNode[32];
        int k = Leaf.key(this.hash, l);
        if (k == (ok = Leaf.key(o.hash, l))) {
            ch[k] = this.add(o, l + 1, ii);
            nu = 1 << k;
        } else {
            ch[k] = this;
            ch[ok] = o;
            nu = 1 << k | 1 << ok;
        }
        return new Branch(ch, nu, o.size + 1);
    }

    @Override
    TrieNode add(Branch o, int l, InputInfo ii) throws QueryException {
        int k = Leaf.key(this.hash, l);
        TrieNode[] ch = o.copyKids();
        TrieNode old = ch[k];
        TrieNode trieNode = old == null ? this : old.addAll(this, l + 1, ii);
        ch[k] = trieNode;
        return new Branch(ch, o.used | 1 << k, o.size + ch[k].size - (old != null ? old.size : 0));
    }

    @Override
    boolean verify() {
        try {
            return this.key.hash(null) == this.hash;
        }
        catch (QueryException ex) {
            return false;
        }
    }

    @Override
    void keys(ItemCache ks) {
        ks.add(this.key);
    }

    @Override
    boolean hasType(AtomType kt, SeqType vt) {
        return !(kt != null && !this.key.type.instance(kt) || vt != null && !vt.instance(this.value));
    }

    @Override
    boolean deep(InputInfo ii, TrieNode o) throws QueryException {
        return o instanceof Leaf && Leaf.eq(this.key, ((Leaf)o).key, ii) && Leaf.deep(this.value, ((Leaf)o).value, ii);
    }

    @Override
    int hash(InputInfo ii) throws QueryException {
        return 31 * this.hash + this.value.hash(ii);
    }

    @Override
    StringBuilder toString(StringBuilder sb) {
        return sb.append(this.key).append(":=").append(this.value).append(", ");
    }
}

