/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.lang.reflect.InvocationTargetException;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.XMLSerializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.ANode;
import org.basex.query.item.DBNode;
import org.basex.query.item.Item;
import org.basex.query.item.QNm;
import org.basex.query.item.SeqType;
import org.basex.query.item.Uri;
import org.basex.query.item.map.Map;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.Xslt;
import org.basex.util.hash.TokenObjMap;

public final class FNXslt
extends FuncCall {
    private static final Uri U_XSLT = Uri.uri(QueryText.XSLTURI);
    private static final QNm E_PARAM = new QNm(Token.token("parameters"), U_XSLT);

    public FNXslt(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.def) {
            case TRANSFORM: {
                return this.xslt(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    private ANode xslt(QueryContext ctx) throws QueryException {
        try {
            IO in = this.read(this.expr[0], ctx);
            IO xsl = this.read(this.expr[1], ctx);
            TokenObjMap<Object> map = this.xsltParams(2, E_PARAM, ctx);
            byte[] result = new Xslt().transform(in, xsl, map);
            return new DBNode(new IOContent(result), ctx.context.prop);
        }
        catch (Exception ex) {
            Util.debug(ex);
            throw Err.NODOC.thrw(this.input, ex instanceof InvocationTargetException ? ex.getCause() : ex);
        }
    }

    private TokenObjMap<Object> xsltParams(int arg, QNm root, QueryContext ctx) throws QueryException {
        TokenObjMap<Object> tm = new TokenObjMap<Object>();
        if (arg >= this.expr.length) {
            return tm;
        }
        Item it = this.expr[arg].item(ctx, this.input);
        if (it == null) {
            return tm;
        }
        if (it instanceof Map) {
            return ((Map)it).tokenJavaMap(this.input);
        }
        if (!it.type().eq(SeqType.ELM)) {
            throw Err.NODFUNTYPE.thrw(this.input, this, it.type);
        }
        ANode node = (ANode)it;
        if (!node.qname().eq(root)) {
            Err.PARWHICH.thrw(this.input, node.qname());
        }
        AxisMoreIter ai = node.children();
        while ((node = ai.next()) != null) {
            QNm qn = node.qname();
            if (!qn.uri().eq(U_XSLT)) {
                Err.PARWHICH.thrw(this.input, qn);
            }
            tm.add(qn.ln(), node.children().next());
        }
        return tm;
    }

    private IO read(Expr e, QueryContext ctx) throws Exception {
        Item in = this.checkEmpty(e.item(ctx, this.input));
        if (in.node()) {
            ArrayOutput ao = new ArrayOutput();
            XMLSerializer xml = new XMLSerializer(ao);
            in.serialize(xml);
            xml.close();
            return new IOContent(ao.toArray());
        }
        if (in.str()) {
            return IO.get(Token.string(in.atom(this.input)));
        }
        throw Err.STRNODTYPE.thrw(this.input, this, in.type);
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.CTX && this.def == Function.TRANSFORM || super.uses(u);
    }
}

