/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.in.TextInput;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.SerializerException;
import org.basex.io.serial.SerializerProp;
import org.basex.io.serial.XMLSerializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.ANode;
import org.basex.query.item.AtomType;
import org.basex.query.item.Bln;
import org.basex.query.item.DBNode;
import org.basex.query.item.Item;
import org.basex.query.item.NodeType;
import org.basex.query.item.QNm;
import org.basex.query.item.SeqType;
import org.basex.query.item.Str;
import org.basex.query.item.Type;
import org.basex.query.item.Uri;
import org.basex.query.item.Value;
import org.basex.query.item.map.Map;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.iter.Iter;
import org.basex.query.iter.ValueIter;
import org.basex.query.up.primitives.Put;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.ByteList;

public final class FNGen
extends FuncCall {
    private static final Uri U_ZIP = Uri.uri(QueryText.OUTPUTURI);
    private static final QNm E_PARAM = new QNm(Token.token("serialization-parameters"), U_ZIP);

    public FNGen(InputInfo ii, Function f, Expr[] e) {
        super(ii, f, e);
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        switch (this.def) {
            case DATA: {
                return this.data(ctx);
            }
            case COLL: {
                return this.collection(ctx).iter();
            }
            case URICOLL: {
                return this.uriCollection(ctx);
            }
            case PARSETXTLIN: {
                return this.unparsedTextLines(ctx);
            }
        }
        return super.iter(ctx);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        switch (this.def) {
            case DOC: {
                return this.doc(ctx);
            }
            case DOCAVL: {
                return this.docAvailable(ctx);
            }
            case PARSETXT: {
                return this.unparsedText(ctx);
            }
            case PARSETXTAVL: {
                return this.unparsedTextAvailable(ctx);
            }
            case PUT: {
                return this.put(ctx);
            }
            case PARSEXML: {
                return this.parseXml(ctx);
            }
            case SERIALIZE: {
                return this.serialize(ctx);
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    public Value value(QueryContext ctx) throws QueryException {
        return this.def == Function.COLL ? this.collection(ctx) : super.value(ctx);
    }

    @Override
    public Expr cmp(QueryContext ctx) {
        if (this.def == Function.DATA && this.expr.length == 1) {
            SeqType t = this.expr[0].type();
            this.type = t.type.node() ? SeqType.get((Type)AtomType.ATM, t.occ) : t;
        }
        return this;
    }

    private Iter data(QueryContext ctx) throws QueryException {
        final Iter ir = ctx.iter(this.expr.length != 0 ? this.expr[0] : this.checkCtx(ctx));
        return new Iter(){

            @Override
            public Item next() throws QueryException {
                Item it = ir.next();
                if (it == null) {
                    return null;
                }
                if (it.func()) {
                    Err.FNATM.thrw(FNGen.this.input, FNGen.this);
                }
                return FNGen.this.atom(it);
            }
        };
    }

    private Value collection(QueryContext ctx) throws QueryException {
        Item it = this.expr.length != 0 ? this.expr[0].item(ctx, this.input) : null;
        return ctx.resource.collection(it != null ? this.checkEStr(it) : null, this.input);
    }

    private Iter uriCollection(QueryContext ctx) throws QueryException {
        final ValueIter coll = this.collection(ctx).iter();
        return new Iter(){

            @Override
            public Item next() throws QueryException {
                Item it = coll.next();
                return it == null ? null : Uri.uri(((ANode)it).base());
            }
        };
    }

    private Item put(QueryContext ctx) throws QueryException {
        Uri u;
        this.checkAdmin(ctx);
        byte[] file = this.checkEStr(this.expr[1], ctx);
        ANode nd = this.checkNode(this.checkEmpty(this.expr[0].item(ctx, this.input)));
        if (nd == null || nd.type != NodeType.DOC && nd.type != NodeType.ELM) {
            Err.UPFOTYPE.thrw(this.input, this.expr[0]);
        }
        if ((u = Uri.uri(file)) == Uri.EMPTY || !u.valid()) {
            Err.UPFOURI.thrw(this.input, new Object[]{file});
        }
        DBNode target = ctx.updates.determineDataRef(nd, ctx);
        ctx.updates.add(new Put(this.input, target.pre, target.data, u, ctx), ctx);
        return null;
    }

    private ANode doc(QueryContext ctx) throws QueryException {
        Data d;
        Item it = this.expr[0].item(ctx, this.input);
        if (it == null) {
            return null;
        }
        byte[] in = this.checkEStr(it);
        if (Token.contains(in, 60) || Token.contains(in, 62)) {
            Err.INVDOC.thrw(this.input, new Object[]{in});
        }
        if (!(d = ctx.resource.data(in, false, this.input)).single()) {
            Err.EXPSINGLE.thrw(this.input, new Object[]{in});
        }
        return new DBNode(d, 0, 0);
    }

    private Bln docAvailable(QueryContext ctx) throws QueryException {
        try {
            return Bln.get(this.doc(ctx) != null);
        }
        catch (QueryException ex) {
            Err err = ex.err();
            if (err != null && err.type == Err.ErrType.FODC && (err.num == 2 || err.num == 4)) {
                return Bln.FALSE;
            }
            throw ex;
        }
    }

    private Str unparsedText(QueryContext ctx) throws QueryException {
        IO io = this.checkIO(this.expr[0], ctx);
        String enc = this.expr.length < 2 ? null : Token.string(this.checkStr(this.expr[1], ctx));
        try {
            byte[] txt = TextInput.content(io, enc).finish();
            if (Token.contains(txt, 13)) {
                txt = Token.contains(txt, 10) ? Token.delete(txt, 13) : Token.replace(txt, 13, 10);
            }
            return Str.get(txt);
        }
        catch (IOException ex) {
            throw Err.WRONGINPUT.thrw(this.input, io, ex);
        }
    }

    Iter unparsedTextLines(QueryContext ctx) throws QueryException {
        return FNGen.textIter(this.unparsedText(ctx).atom());
    }

    public static Iter textIter(final byte[] str) {
        return new Iter(){
            int p = -1;

            @Override
            public Item next() {
                ByteList bl = new ByteList();
                while (++this.p < str.length && str[this.p] != 10) {
                    bl.add(str[this.p]);
                }
                return this.p + 1 < str.length || bl.size() != 0 ? Str.get(bl.toArray()) : null;
            }
        };
    }

    private Bln unparsedTextAvailable(QueryContext ctx) throws QueryException {
        IO io = this.checkIO(this.expr[0], ctx);
        String enc = this.expr.length < 2 ? null : Token.string(this.checkEStr(this.expr[1], ctx));
        try {
            TextInput.content(io, enc);
            return Bln.TRUE;
        }
        catch (IOException ex) {
            return Bln.FALSE;
        }
    }

    private ANode parseXml(QueryContext ctx) throws QueryException {
        byte[] cont = this.checkEStr(this.expr[0], ctx);
        Uri base = ctx.baseURI;
        if (this.expr.length == 2 && !(base = Uri.uri(this.checkEStr(this.expr[1], ctx))).valid()) {
            Err.DOCBASE.thrw(this.input, base);
        }
        IOContent io = new IOContent(cont, Token.string(base.atom()));
        try {
            return new DBNode(io, ctx.context.prop);
        }
        catch (IOException ex) {
            throw Err.SAXERR.thrw(this.input, ex);
        }
    }

    private Str serialize(QueryContext ctx) throws QueryException {
        ANode node = this.checkNode(this.checkItem(this.expr[0], ctx));
        ArrayOutput ao = new ArrayOutput();
        try {
            XMLSerializer xml = new XMLSerializer(ao, FNGen.serialPar(this, 1, ctx));
            node.serialize(xml);
            xml.close();
        }
        catch (SerializerException ex) {
            throw new QueryException(this.input, ex);
        }
        catch (IOException ex) {
            Err.SERANY.thrw(this.input, ex);
        }
        return Str.get(ao.toArray());
    }

    static SerializerProp serialPar(FuncCall fun, int arg, QueryContext ctx) throws SerializerException, QueryException {
        Item it;
        TokenObjMap<Object> tm = new TokenObjMap();
        if (arg < fun.expr.length && (it = fun.expr[arg].item(ctx, fun.input)) != null) {
            if (it instanceof Map) {
                tm = ((Map)it).tokenJavaMap(fun.input);
            } else {
                ANode n = (ANode)fun.checkType(it, NodeType.ELM);
                if (!n.qname().eq(E_PARAM)) {
                    Err.SERUNKNOWN.thrw(fun.input, n.qname());
                }
                AxisMoreIter ai = n.children();
                while ((n = ai.next()) != null) {
                    QNm qn = n.qname();
                    if (!qn.uri().eq(U_ZIP)) {
                        Err.SERUNKNOWN.thrw(fun.input, qn);
                    }
                    tm.add(qn.ln(), n.atom());
                }
            }
        }
        TokenBuilder tb = new TokenBuilder();
        for (byte[] key : tm) {
            if (tb.size() != 0) {
                tb.add(44);
            }
            tb.add(key).add(61).addExt(tm.get(key), new Object[0]);
        }
        return tb.size() == 0 ? ctx.serProp(true) : new SerializerProp(tb.toString());
    }

    @Override
    public boolean uses(Expr.Use u) {
        return u == Expr.Use.UPD && this.def == Function.PUT || u == Expr.Use.X30 && (this.def == Function.DATA && this.expr.length == 0 || this.def == Function.PARSETXT || this.def == Function.PARSETXTLIN || this.def == Function.PARSETXTAVL || this.def == Function.PARSEXML || this.def == Function.URICOLL || this.def == Function.SERIALIZE) || u == Expr.Use.CTX && (this.def == Function.DATA && this.expr.length == 0 || this.def == Function.PUT) && this.expr.length == 0 || super.uses(u);
    }

    @Override
    public boolean iterable() {
        return this.def == Function.COLL || super.iterable();
    }
}

