/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.DTd;
import org.basex.query.item.Dat;
import org.basex.query.item.Dtm;
import org.basex.query.item.Item;
import org.basex.query.item.Tim;
import org.basex.query.item.Uri;
import org.basex.query.iter.Iter;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FNContext
extends FuncCall {
    public FNContext(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Iter[] arg = new Iter[this.expr.length];
        int a = 0;
        while (a < this.expr.length) {
            arg[a] = ctx.iter(this.expr[a]);
            ++a;
        }
        switch (this.def) {
            case CURRDATE: {
                return this.currDate(ctx);
            }
            case CURRDTM: {
                return this.currDTM(ctx);
            }
            case CURRTIME: {
                return this.currTIM(ctx);
            }
            case IMPLZONE: {
                return this.implZone();
            }
            case COLLAT: {
                return ctx.baseURI.resolve(ctx.collation);
            }
            case STBASEURI: {
                return ctx.baseURI != Uri.EMPTY ? ctx.baseURI : null;
            }
        }
        return super.item(ctx, ii);
    }

    private Item currDate(QueryContext ctx) throws QueryException {
        if (ctx.date != null) {
            return ctx.date;
        }
        Date d = Calendar.getInstance().getTime();
        String zone = new SimpleDateFormat("Z").format(d);
        String form = new SimpleDateFormat("yyyy-MM-dd").format(d);
        ctx.date = new Dat(Token.token(String.valueOf(form) + zone.substring(0, 3) + ":" + zone.substring(3)), this.input);
        return ctx.date;
    }

    private Item currDTM(QueryContext ctx) throws QueryException {
        if (ctx.dtm != null) {
            return ctx.dtm;
        }
        Date d = Calendar.getInstance().getTime();
        String zone = new SimpleDateFormat("Z").format(d);
        String df1 = new SimpleDateFormat("yyyy-MM-dd").format(d);
        String df2 = new SimpleDateFormat("HH:mm:ss.S").format(d);
        ctx.dtm = new Dtm(Token.token(String.valueOf(df1) + "T" + df2 + zone.substring(0, 3) + ":" + zone.substring(3)), this.input);
        return ctx.dtm;
    }

    private Item currTIM(QueryContext ctx) throws QueryException {
        if (ctx.time != null) {
            return ctx.time;
        }
        Date dat = Calendar.getInstance().getTime();
        String zone = new SimpleDateFormat("Z").format(dat);
        String form = new SimpleDateFormat("HH:mm:ss.S").format(dat);
        ctx.time = new Tim(Token.token(String.valueOf(form) + zone.substring(0, 3) + ":" + zone.substring(3)), this.input);
        return ctx.time;
    }

    private Item implZone() {
        Date d = Calendar.getInstance().getTime();
        String zone = new SimpleDateFormat("Z").format(d);
        byte[] z = Token.token(zone);
        int cshift = Token.toInt(Token.substring(z, 0, 3)) * 60 + Token.toInt(Token.substring(z, 3));
        return new DTd(cshift);
    }
}

