/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Calc;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.func.FuncCall;
import org.basex.query.func.Function;
import org.basex.query.item.AtomType;
import org.basex.query.item.Dbl;
import org.basex.query.item.Item;
import org.basex.query.item.Itr;
import org.basex.query.item.Type;
import org.basex.query.iter.Iter;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;

public final class FNAggr
extends FuncCall {
    public FNAggr(InputInfo ii, Function f, Expr ... e) {
        super(ii, f, e);
    }

    @Override
    public Item item(QueryContext ctx, InputInfo ii) throws QueryException {
        Iter iter = ctx.iter(this.expr[0]);
        switch (this.def) {
            case COUNT: {
                long c = iter.size();
                if (c == -1L) {
                    do {
                        ++c;
                    } while (iter.next() != null);
                }
                return Itr.get(c);
            }
            case MIN: {
                return this.minmax(iter, CmpV.Op.GT, ctx);
            }
            case MAX: {
                return this.minmax(iter, CmpV.Op.LT, ctx);
            }
            case SUM: {
                Item it = iter.next();
                return it != null ? this.sum(iter, it, false) : (this.expr.length == 2 ? this.expr[1].item(ctx, this.input) : Itr.get(0L));
            }
            case AVG: {
                Item it = iter.next();
                return it == null ? null : this.sum(iter, it, true);
            }
        }
        return super.item(ctx, ii);
    }

    @Override
    public Expr cmp(QueryContext ctx) throws QueryException {
        Expr e = this.expr[0];
        long c = e.size();
        if (c < 0L || e.uses(Expr.Use.CTX)) {
            return this;
        }
        switch (this.def) {
            case COUNT: {
                return Itr.get(c);
            }
            case SUM: {
                return c == 0L ? (this.expr.length == 2 ? this.expr[1] : Itr.get(0L)) : this;
            }
        }
        return this;
    }

    private Item sum(Iter iter, Item it, boolean avg) throws QueryException {
        Item i;
        Item res;
        Item item = res = it.unt() ? Dbl.get(it.atom(this.input), this.input) : it;
        if (!(res.num() || res.dur() && res.type != AtomType.DUR)) {
            Err.SUMTYPE.thrw(this.input, this, res.type);
        }
        boolean n = res.num();
        int c = 1;
        while ((i = iter.next()) != null) {
            boolean un;
            boolean bl = un = i.unt() || i.num();
            if (n && !un) {
                Err.FUNNUM.thrw(this.input, this, i.type);
            }
            if (!n && un) {
                Err.FUNDUR.thrw(this.input, this, i.type);
            }
            res = Calc.PLUS.ev(this.input, res, i);
            ++c;
        }
        return avg ? Calc.DIV.ev(this.input, res, Itr.get(c)) : res;
    }

    private Item minmax(Iter iter, CmpV.Op cmp, QueryContext ctx) throws QueryException {
        Item it;
        Type t;
        Item res;
        if (this.expr.length == 2) {
            this.checkColl(this.expr[1], ctx);
        }
        if ((res = iter.next()) == null) {
            return null;
        }
        cmp.e(this.input, res, res);
        if (!res.unt() && res.str() || res.date()) {
            Item it2;
            while ((it2 = iter.next()) != null) {
                if (it2.type != res.type) {
                    Err.FUNCMP.thrw(this.input, this.desc(), res.type, it2.type);
                }
                if (!cmp.e(this.input, res, it2)) continue;
                res = it2;
            }
            return res;
        }
        Type type = t = res.unt() ? AtomType.DBL : res.type;
        if (res.type != t) {
            res = t.e(res, ctx, this.input);
        }
        while ((it = iter.next()) != null) {
            t = this.type(res, it);
            if (!it.dur() && Double.isNaN(it.dbl(this.input)) || cmp.e(this.input, res, it)) {
                res = it;
            }
            if (res.type == t) continue;
            res = t.e(res, ctx, this.input);
        }
        return res;
    }

    private Type type(Item a, Item b) throws QueryException {
        Type ta = a.type;
        Type tb = b.type;
        if (b.unt()) {
            if (!a.num()) {
                Err.FUNCMP.thrw(this.input, this, ta, tb);
            }
            return AtomType.DBL;
        }
        if (a.num() && !b.unt() && b.str()) {
            Err.FUNCMP.thrw(this.input, this, ta, tb);
        }
        if (ta == tb) {
            return ta;
        }
        if (ta == AtomType.DBL || tb == AtomType.DBL) {
            return AtomType.DBL;
        }
        if (ta == AtomType.FLT || tb == AtomType.FLT) {
            return AtomType.FLT;
        }
        if (ta == AtomType.DEC || tb == AtomType.DEC) {
            return AtomType.DEC;
        }
        if (ta == AtomType.BLN || a.num() && !b.num() || b.num() && !a.num()) {
            Err.FUNCMP.thrw(this.input, this, ta, tb);
        }
        return a.num() || b.num() ? AtomType.ITR : ta;
    }
}

