/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.io.IOException;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.TypeCase;
import org.basex.query.item.Value;
import org.basex.query.iter.Iter;
import org.basex.query.util.Var;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class TypeSwitch
extends ParseExpr {
    private final TypeCase[] cases;
    private Expr ts;

    public TypeSwitch(InputInfo ii, Expr t, TypeCase[] c) {
        super(ii);
        this.ts = t;
        this.cases = c;
    }

    @Override
    public Expr comp(QueryContext ctx) throws QueryException {
        int n;
        int n2;
        TypeCase[] typeCaseArray;
        this.ts = this.checkUp(this.ts, ctx).comp(ctx);
        Expr[] tmp = new Expr[this.cases.length];
        int i = 0;
        while (i < this.cases.length) {
            tmp[i] = this.cases[i].expr;
            ++i;
        }
        this.checkUp(ctx, tmp);
        if (this.ts.value()) {
            typeCaseArray = this.cases;
            n2 = this.cases.length;
            n = 0;
            while (n < n2) {
                TypeCase c = typeCaseArray[n];
                if (c.var.type == null || c.var.type.instance(this.ts.value(ctx))) {
                    return this.optPre(c.comp((QueryContext)ctx, (Value)((Value)this.ts)).expr, ctx);
                }
                ++n;
            }
        }
        typeCaseArray = this.cases;
        n2 = this.cases.length;
        n = 0;
        while (n < n2) {
            TypeCase c = typeCaseArray[n];
            c.comp(ctx);
            ++n;
        }
        boolean eq = true;
        int i2 = 1;
        while (i2 < this.cases.length) {
            eq &= this.cases[i2 - 1].expr.sameAs(this.cases[i2].expr);
            ++i2;
        }
        if (eq) {
            return this.optPre(null, ctx);
        }
        this.type = this.cases[0].type();
        int c = 1;
        while (c < this.cases.length) {
            this.type = this.type.intersect(this.cases[c].type());
            ++c;
        }
        return this;
    }

    @Override
    public Iter iter(QueryContext ctx) throws QueryException {
        Value seq = ctx.value(this.ts);
        TypeCase[] typeCaseArray = this.cases;
        int n = this.cases.length;
        int n2 = 0;
        while (n2 < n) {
            TypeCase c = typeCaseArray[n2];
            Iter iter = c.iter(ctx, seq);
            if (iter != null) {
                return iter;
            }
            ++n2;
        }
        throw Util.notexpected(new Object[0]);
    }

    @Override
    public boolean vacuous() {
        TypeCase[] typeCaseArray = this.cases;
        int n = this.cases.length;
        int n2 = 0;
        while (n2 < n) {
            TypeCase c = typeCaseArray[n2];
            if (!c.expr.vacuous()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean uses(Expr.Use u) {
        if (u == Expr.Use.VAR) {
            return true;
        }
        TypeCase[] typeCaseArray = this.cases;
        int n = this.cases.length;
        int n2 = 0;
        while (n2 < n) {
            TypeCase c = typeCaseArray[n2];
            if (c.uses(u)) {
                return true;
            }
            ++n2;
        }
        return this.ts.uses(u);
    }

    @Override
    public int count(Var v) {
        int c = 0;
        TypeCase[] typeCaseArray = this.cases;
        int n = this.cases.length;
        int n2 = 0;
        while (n2 < n) {
            TypeCase t = typeCaseArray[n2];
            c += t.count(v);
            ++n2;
        }
        return c + this.ts.count(v);
    }

    @Override
    public boolean removable(Var v) {
        TypeCase[] typeCaseArray = this.cases;
        int n = this.cases.length;
        int n2 = 0;
        while (n2 < n) {
            TypeCase c = typeCaseArray[n2];
            if (!c.removable(v)) {
                return false;
            }
            ++n2;
        }
        return this.ts.removable(v);
    }

    @Override
    public Expr remove(Var v) {
        int c = 0;
        while (c < this.cases.length) {
            this.cases[c].remove(v);
            ++c;
        }
        this.ts = this.ts.remove(v);
        return this;
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[0][]);
        TypeCase[] typeCaseArray = this.cases;
        int n = this.cases.length;
        int n2 = 0;
        while (n2 < n) {
            TypeCase c = typeCaseArray[n2];
            c.plan(ser);
            ++n2;
        }
        this.ts.plan(ser);
        ser.closeElement();
    }

    @Override
    public String toString() {
        return new TokenBuilder("typeswitch(" + this.ts + ")" + ' ').addSep(this.cases, ", ").toString();
    }

    @Override
    Expr markTailCalls() {
        int i = 0;
        while (i < this.cases.length) {
            this.cases[i] = this.cases[i].markTailCalls();
            ++i;
        }
        return this;
    }
}

