/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.out;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.basex.data.MetaData;
import org.basex.io.out.DataOutput;
import org.basex.util.list.IntList;

public final class TableOutput
extends OutputStream {
    private final byte[] buffer = new byte[4096];
    private final IntList firstPres = new IntList();
    private final IntList blocks = new IntList();
    private final OutputStream os;
    private final MetaData meta;
    private final String file;
    private int pos;
    private int bcount;
    private int fpre;

    public TableOutput(MetaData md, String fn) throws IOException {
        this.os = new FileOutputStream(md.dbfile(fn));
        this.meta = md;
        this.file = fn;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.pos == 4096) {
            this.flush();
        }
        this.buffer[this.pos++] = (byte)b;
    }

    @Override
    public void flush() throws IOException {
        if (this.pos == 0) {
            return;
        }
        this.os.write(this.buffer);
        this.firstPres.add(this.fpre);
        this.blocks.add(this.bcount++);
        this.fpre += this.pos >>> 4;
        this.pos = 0;
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.os.close();
        DataOutput dt = null;
        try {
            dt = new DataOutput(this.meta.dbfile(String.valueOf(this.file) + 'i'));
            dt.writeNum(this.bcount);
            dt.writeNum(this.bcount);
            dt.writeNums(this.firstPres.toArray());
            dt.writeNums(this.blocks.toArray());
        }
        finally {
            if (dt != null) {
                try {
                    dt.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

