/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.ft;

import java.io.IOException;
import java.util.Arrays;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.AInfo;
import org.basex.data.Data;
import org.basex.index.IndexIterator;
import org.basex.index.IndexStats;
import org.basex.index.IndexToken;
import org.basex.index.ft.FTIndex;
import org.basex.index.ft.FTIndexIterator;
import org.basex.io.random.DataAccess;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.ft.FTFlag;
import org.basex.util.ft.FTLexer;
import org.basex.util.list.IntList;

final class FTTrie
extends FTIndex {
    private final DataAccess inA;
    private final DataAccess inB;
    private final DataAccess inC;
    private long currID;
    private FTIndexIterator idata;
    private int[] counter;
    private byte[] valuesFound;

    protected FTTrie(Data d) throws IOException {
        super(d);
        this.inA = new DataAccess(d.meta.dbfile("ftxa"));
        this.inB = new DataAccess(d.meta.dbfile("ftxb"));
        this.inC = new DataAccess(d.meta.dbfile("ftxc"));
    }

    @Override
    public synchronized int nrIDs(IndexToken ind) {
        if (ind.get().length > 96) {
            return Integer.MAX_VALUE;
        }
        FTLexer lex = (FTLexer)ind;
        if (lex.ftOpt().is(FTFlag.FZ) || lex.ftOpt().is(FTFlag.WC)) {
            return Math.max(1, this.data.meta.size / 10);
        }
        byte[] token = lex.get();
        int id = this.cache.id(token);
        if (id > 0) {
            return this.cache.size(id);
        }
        int size = 0;
        long poi = 0L;
        int[] node = this.node(token, 0);
        if (node != null && node[node.length - 1] > 0) {
            size = node[node.length - 1];
            poi = this.currID;
        }
        this.cache.add(token, size, poi);
        return size;
    }

    @Override
    public synchronized IndexIterator ids(IndexToken ind) {
        int pw;
        byte[] token = ind.get();
        FTLexer lex = (FTLexer)ind;
        if (lex.ftOpt().is(FTFlag.FZ)) {
            int k = this.data.meta.prop.num(Prop.LSERROR);
            if (k == 0) {
                k = token.length >> 2;
            }
            return this.fuzzy(0, null, -1L, token, 0, 0, 0, k, false);
        }
        if (lex.ftOpt().is(FTFlag.WC) && (pw = Token.indexOf(token, 46)) != -1) {
            return this.wc(token, pw, false);
        }
        int id = this.cache.id(token);
        return id == 0 ? this.iter(0, token, false) : this.iter(this.cache.pointer(id), this.cache.size(id), this.inB, false);
    }

    @Override
    public synchronized void close() throws IOException {
        this.inB.close();
        this.inC.close();
        this.inA.close();
    }

    private FTIndexIterator iter(int id, byte[] token, boolean fast) {
        if (token == null || token.length == 0) {
            return FTIndexIterator.EMP;
        }
        int[] node = this.node(token, id);
        return node == null ? FTIndexIterator.EMP : this.iter(this.currID, node[node.length - 1], this.inB, fast);
    }

    private int[] node(byte[] token, int id) {
        int pos;
        byte[] tok = token;
        int[] node = this.entry(id);
        if (id != 0) {
            int t = 0;
            int tl = tok.length;
            while (t < tl && t < node[0] && node[t + 1] == tok[t]) {
                ++t;
            }
            if (t != node[0]) {
                return null;
            }
            if (t == tl) {
                return node;
            }
            byte[] tmp = new byte[tl - t];
            System.arraycopy(tok, t, tmp, 0, tmp.length);
            tok = tmp;
        }
        return (pos = this.pos(node, tok[0])) < 0 ? null : this.node(tok, node[pos]);
    }

    @Override
    public byte[] info() {
        TokenBuilder tb = new TokenBuilder();
        tb.add("- Structure: Trie" + Text.NL);
        tb.addExt("- %: %" + Text.NL, Text.CREATEST, AInfo.flag(this.data.meta.stemming));
        tb.addExt("- %: %" + Text.NL, Text.CREATECS, AInfo.flag(this.data.meta.casesens));
        tb.addExt("- %: %" + Text.NL, Text.CREATEDC, AInfo.flag(this.data.meta.diacritics));
        if (this.data.meta.language != null) {
            tb.addExt("- %: %" + Text.NL, new Object[]{Text.CREATELN, this.data.meta.language});
        }
        long l = this.inA.length() + this.inB.length() + this.inC.length();
        tb.add("- Size: " + Performance.format(l, true) + Text.NL);
        IndexStats stats = new IndexStats(this.data);
        this.addOccs(Token.EMPTY, 0, stats);
        stats.print(tb);
        return tb.finish();
    }

    private void addOccs(byte[] token, int id, IndexStats st) {
        int i;
        int[] ne = this.entry(id);
        byte[] nt = token;
        if (id > 0) {
            nt = Arrays.copyOf(token, token.length + ne[0]);
            i = 0;
            while (i < ne[0]) {
                nt[token.length + i] = (byte)ne[i + 1];
                ++i;
            }
            int size = ne[ne.length - 1];
            if (size > 0 && st.adding(size)) {
                st.add(nt);
            }
        }
        i = ne[0] + 1;
        while (i < ne.length - 1) {
            this.addOccs(nt, ne[i], st);
            i += 2;
        }
    }

    private int[] entry(long id) {
        int sp = this.inC.read4(id << 2);
        int ep = this.inC.read4();
        IntList il = new IntList();
        this.inA.cursor(sp++);
        int l = this.inA.read1();
        il.add(l);
        int j = 0;
        while (j < l) {
            il.add(this.inA.read1());
            ++j;
        }
        sp += l;
        while (sp + 9 < ep) {
            il.add(this.inA.read4());
            il.add(this.inA.read1());
            sp += 5;
        }
        il.add(this.inA.read4());
        this.currID = this.inA.read5();
        return il.toArray();
    }

    private boolean more(int[] node) {
        return node[0] + 1 < node.length - 1;
    }

    private int pos(int[] cne, byte ins) {
        int i = cne[0] + 1;
        int s = cne.length - 1;
        while (i < s && Token.diff((byte)cne[i + 1], ins) < 0) {
            i += 2;
        }
        return i < s && cne[i + 1] == ins ? i : -1;
    }

    /*
     * Unable to fully structure code
     */
    private void wc(int id, byte[] ending, boolean lst, int nod, int end, boolean fast) {
        j = end;
        i = nod;
        last = lst;
        node = this.entry(id);
        tdid = this.currID;
        if (ending != null && ending.length != 0) ** GOTO lbl16
        if (node[node.length - 1] > 0) {
            this.idata = FTIndexIterator.union(this.iter(tdid, node[node.length - 1], this.inB, fast), this.idata);
        }
        t = node[0] + 1;
        while (t < node.length - 1) {
            this.wc(node[t], null, last, 0, 0, fast);
            t += 2;
        }
        return;
lbl-1000:
        // 1 sources

        {
            ++i;
lbl16:
            // 2 sources

            ** while (!last && i < node[0] + 1 && node[i] != ending[j])
        }
lbl17:
        // 2 sources

        while (i + ending.length < node[0] + 1 && node[i + 1] == ending[0]) {
            ++i;
        }
        while (i < node[0] + 1 && j < ending.length && node[i] == ending[j]) {
            ++i;
            ++j;
            last = true;
        }
        if (id == 0 || j == ending.length && i < node[0] + 1) {
            if (!this.more(node)) {
                return;
            }
            t = node[0] + 1;
            while (t < node.length - 1) {
                this.wc(node[t], ending, false, 1, 0, fast);
                t += 2;
            }
            return;
        }
        if (j == ending.length && i == node[0] + 1) {
            this.idata = FTIndexIterator.union(this.iter(tdid, node[node.length - 1], this.inB, fast), this.idata);
            t = node[0] + 1;
            while (t < node.length - 1) {
                if (j == 1) {
                    this.wc(node[t], ending, false, 0, 0, fast);
                }
                this.wc(node[t], ending, last, 0, j, fast);
                t += 2;
            }
            return;
        }
        if (j < ending.length && i < node[0] + 1) {
            if (!this.more(node)) {
                return;
            }
            this.wc(id, ending, false, i + 1, 0, fast);
            return;
        }
        if (j < ending.length && i == node[0] + 1) {
            if (!this.more(node)) {
                return;
            }
            t = node[0] + 1;
            while (t < node.length - 1) {
                if (j == 1) {
                    this.wc(node[t], ending, last, 1, 0, fast);
                }
                this.wc(node[t], ending, last, 1, j, fast);
                t += 2;
            }
        }
    }

    private FTIndexIterator wc(byte[] token, int pos, boolean f) {
        this.counter = new int[2];
        return this.wc(0, token, pos, false, f);
    }

    private FTIndexIterator wc(int id, byte[] token, int posw, boolean first, boolean fast) {
        int wildcard;
        int resultNode;
        byte[] vsn = token;
        byte[] aw = null;
        byte[] bw = null;
        boolean currentLength = false;
        FTIndexIterator d = FTIndexIterator.EMP;
        if (posw > 0) {
            bw = new byte[posw];
            System.arraycopy(vsn, 0, bw, 0, posw);
            resultNode = this.wc(id, bw);
            if (resultNode == -1) {
                return FTIndexIterator.EMP;
            }
        } else {
            resultNode = 0;
        }
        int n = wildcard = posw + 1 >= vsn.length ? 46 : vsn[posw + 1];
        if (wildcard == 63) {
            byte[] sc = new byte[vsn.length - 2 - 0];
            if (bw != null) {
                System.arraycopy(bw, 0, sc, 0, bw.length);
            }
            if (bw == null) {
                System.arraycopy(vsn, posw + 2, sc, 0, sc.length);
            } else {
                System.arraycopy(vsn, posw + 2, sc, bw.length, sc.length - bw.length);
            }
            d = this.iter(0, sc, fast);
            sc = new byte[vsn.length - 1];
            if (bw != null) {
                System.arraycopy(bw, 0, sc, 0, bw.length);
                sc[bw.length] = 46;
                System.arraycopy(vsn, posw + 2, sc, bw.length + 1, sc.length - bw.length - 1);
            } else {
                sc[0] = 46;
                System.arraycopy(vsn, posw + 2, sc, 1, sc.length - 1);
            }
            d = FTIndexIterator.union(this.wc(0, sc, posw, false, fast), d);
            return d;
        }
        if (wildcard == 42) {
            if (posw != 0 || vsn.length != 2) {
                byte[] searchChar = new byte[vsn.length - 2 - 0];
                if (bw != null) {
                    System.arraycopy(bw, 0, searchChar, 0, bw.length);
                }
                if (bw == null) {
                    aw = new byte[searchChar.length];
                    System.arraycopy(vsn, posw + 2, searchChar, 0, searchChar.length);
                    System.arraycopy(vsn, posw + 2, aw, 0, searchChar.length);
                } else {
                    aw = new byte[searchChar.length - bw.length];
                    System.arraycopy(vsn, posw + 2, searchChar, bw.length, searchChar.length - bw.length);
                    System.arraycopy(vsn, posw + 2, aw, 0, searchChar.length - bw.length);
                }
                d = this.iter(0, searchChar, fast);
                if (bw != null && this.counter[1] != bw.length) {
                    return d;
                }
            }
            this.idata = FTIndexIterator.EMP;
            this.wc(resultNode, aw, false, this.counter[0], 0, fast);
            return FTIndexIterator.union(d, this.idata);
        }
        if (wildcard == 43) {
            int[] rne = this.entry(resultNode);
            byte[] nvsn = new byte[vsn.length + 1];
            int l = 0;
            if (bw != null) {
                System.arraycopy(bw, 0, nvsn, 0, bw.length);
                l = bw.length;
            }
            if (vsn.length - posw - 2 > 0) {
                System.arraycopy(vsn, posw + 2, nvsn, posw + 3, vsn.length - posw - 2);
            }
            nvsn[l + 1] = 46;
            nvsn[l + 2] = 42;
            FTIndexIterator tmpres = FTIndexIterator.EMP;
            if (rne[0] > this.counter[0] && resultNode > 0) {
                nvsn[l] = (byte)rne[this.counter[0] + 1];
                tmpres = this.wc(nvsn, l + 1, fast);
            } else if (rne[0] == this.counter[0] || resultNode == 0) {
                if (!this.more(rne)) {
                    return FTIndexIterator.EMP;
                }
                int t = rne[0] + 1;
                while (t < rne.length - 1) {
                    nvsn[l] = (byte)rne[t + 1];
                    tmpres = FTIndexIterator.union(this.wc(nvsn, l + 1, fast), tmpres);
                    t += 2;
                }
            }
            return tmpres;
        }
        int[] rne = this.entry(resultNode);
        if (rne[0] > this.counter[0] && resultNode > 0) {
            vsn[posw] = (byte)rne[this.counter[0] + 1];
            FTIndexIterator resultData = this.iter(0, vsn, fast);
            if (resultData.size != 0 && first) {
                this.valuesFound = new byte[]{(byte)rne[this.counter[0] + 1]};
            }
            return resultData;
        }
        if (rne[0] == this.counter[0] || resultNode == 0) {
            if (!this.more(rne)) {
                return FTIndexIterator.EMP;
            }
            FTIndexIterator tmpNode = FTIndexIterator.EMP;
            aw = new byte[vsn.length - posw];
            System.arraycopy(vsn, posw + 1, aw, 1, aw.length - 1);
            if (!first) {
                int t = rne[0] + 1;
                while (t < rne.length - 1) {
                    aw[0] = (byte)rne[t + 1];
                    tmpNode = FTIndexIterator.union(this.iter(rne[t], aw, fast), tmpNode);
                    t += 2;
                }
                return tmpNode;
            }
            this.valuesFound = new byte[rne.length - 1 - rne[0] - 1];
            int t = rne[0] + 1;
            while (t < rne.length - 1) {
                aw[0] = (byte)rne[t + 1];
                this.valuesFound[t - rne[0] - 1] = (byte)rne[t + 1];
                tmpNode = FTIndexIterator.union(this.iter(rne[t], aw, fast), tmpNode);
                t += 2;
            }
        }
        return FTIndexIterator.EMP;
    }

    private int wc(int id, byte[] token) {
        byte[] vsn = token;
        int[] cne = this.entry(id);
        if (id != 0) {
            this.counter[1] = this.counter[1] + cne[0];
            int i = 0;
            while (i < vsn.length && i < cne[0] && cne[i + 1] == vsn[i]) {
                ++i;
            }
            if (cne[0] == i) {
                if (vsn.length == i) {
                    this.counter[0] = i;
                    return id;
                }
                byte[] tmp = new byte[vsn.length - i];
                System.arraycopy(vsn, i, tmp, 0, tmp.length);
                vsn = tmp;
                int pos = this.pos(cne, vsn[0]);
                if (pos >= 0) {
                    return this.wc(cne[pos], vsn);
                }
            }
            this.counter[0] = i;
            this.counter[1] = this.counter[1] - cne[0] + i;
            return id;
        }
        int pos = this.pos(cne, vsn[0]);
        if (pos >= 0) {
            return this.wc(cne[pos], vsn);
        }
        this.counter[0] = -1;
        this.counter[1] = -1;
        return -1;
    }

    private FTIndexIterator fuzzy(int id, int[] crne, long crdid, byte[] token, int d, int p, int r, int c, boolean f) {
        byte[] vsn = token;
        int[] cne = crne;
        long cdid = crdid;
        if (cne == null) {
            cne = this.entry(id);
            cdid = this.currID;
        }
        if (id != 0) {
            int i = 0;
            while (i < vsn.length && i < cne[0] && cne[i + 1] == vsn[i]) {
                ++i;
            }
            if (cne[0] == i) {
                byte[] b;
                if (vsn.length == i) {
                    if (c < d + p + r) {
                        return FTIndexIterator.EMP;
                    }
                    FTIndexIterator ld = FTIndexIterator.EMP;
                    ld = this.iter(cdid, cne[cne.length - 1], this.inB, f);
                    int t = cne[0] + 1;
                    while (t < cne.length - 1) {
                        ld = FTIndexIterator.union(this.fuzzy(cne[t], null, -1L, new byte[]{(byte)cne[t + 1]}, d, p + 1, r, c, f), ld);
                        t += 2;
                    }
                    return ld;
                }
                FTIndexIterator ld = FTIndexIterator.EMP;
                if (c > d + p + r) {
                    b = new byte[vsn.length - 1];
                    System.arraycopy(vsn, 0, b, 0, i);
                    ld = FTIndexIterator.union(this.fuzzy(id, cne, cdid, b, d + 1, p, r, c, f), ld);
                }
                byte[] tmp = new byte[vsn.length - i];
                System.arraycopy(vsn, i, tmp, 0, tmp.length);
                vsn = tmp;
                int[] ne = null;
                long tdid = -1L;
                int k = cne[0] + 1;
                while (k < cne.length - 1) {
                    if (cne[k + 1] == vsn[0]) {
                        ne = this.entry(cne[k]);
                        tdid = this.currID;
                        b = new byte[vsn.length];
                        System.arraycopy(vsn, 0, b, 0, vsn.length);
                        ld = FTIndexIterator.union(this.fuzzy(cne[k], ne, tdid, b, d, p, r, c, f), ld);
                    }
                    if (c > d + p + r) {
                        if (ne == null) {
                            ne = this.entry(cne[k]);
                            tdid = this.currID;
                        }
                        b = new byte[vsn.length + 1];
                        b[0] = (byte)cne[k + 1];
                        System.arraycopy(vsn, 0, b, 1, vsn.length);
                        ld = FTIndexIterator.union(this.fuzzy(cne[k], ne, tdid, b, d, p + 1, r, c, f), ld);
                        if (vsn.length > 0) {
                            b = new byte[vsn.length - 1];
                            System.arraycopy(vsn, 1, b, 0, b.length);
                            ld = FTIndexIterator.union(this.fuzzy(cne[k], ne, tdid, b, d + 1, p, r, c, f), ld);
                            b = new byte[vsn.length];
                            System.arraycopy(vsn, 1, b, 1, vsn.length - 1);
                            b[0] = (byte)ne[1];
                            ld = FTIndexIterator.union(this.fuzzy(cne[k], ne, tdid, b, d, p, r + 1, c, f), ld);
                        }
                    }
                    k += 2;
                }
                return ld;
            }
            FTIndexIterator ld = FTIndexIterator.EMP;
            if (c > d + p + r) {
                byte[] b = new byte[vsn.length + 1];
                System.arraycopy(vsn, 0, b, 0, i);
                b[i] = (byte)cne[i + 1];
                System.arraycopy(vsn, i, b, i + 1, vsn.length - i);
                ld = this.fuzzy(id, cne, cdid, b, d, p + 1, r, c, f);
                if (vsn.length > 0 && i < vsn.length) {
                    b = new byte[vsn.length];
                    System.arraycopy(vsn, 0, b, 0, vsn.length);
                    b[i] = (byte)cne[i + 1];
                    ld = FTIndexIterator.union(this.fuzzy(id, cne, cdid, b, d, p, r + 1, c, f), ld);
                    if (vsn.length > 1) {
                        b = new byte[vsn.length - 1];
                        System.arraycopy(vsn, 0, b, 0, i);
                        System.arraycopy(vsn, i + 1, b, i, vsn.length - i - 1);
                        ld = FTIndexIterator.union(this.fuzzy(id, cne, cdid, b, d + 1, p, r, c, f), ld);
                    }
                }
            }
            return ld;
        }
        int[] ne = null;
        long tdid = -1L;
        FTIndexIterator ld = FTIndexIterator.EMP;
        int k = cne[0] + 1;
        while (k < cne.length - 1) {
            byte[] b;
            if (cne[k + 1] == vsn[0]) {
                ne = this.entry(cne[k]);
                tdid = this.currID;
                b = new byte[vsn.length];
                System.arraycopy(vsn, 0, b, 0, vsn.length);
                ld = FTIndexIterator.union(this.fuzzy(cne[k], ne, tdid, b, d, p, r, c, f), ld);
            }
            if (c > d + p + r) {
                if (ne == null) {
                    ne = this.entry(cne[k]);
                    tdid = this.currID;
                }
                b = new byte[vsn.length + 1];
                b[0] = (byte)ne[1];
                System.arraycopy(vsn, 0, b, 1, vsn.length);
                ld = FTIndexIterator.union(this.fuzzy(cne[k], ne, tdid, b, d, p + 1, r, c, f), ld);
                if (vsn.length > 0) {
                    b = new byte[vsn.length - 1];
                    System.arraycopy(vsn, 1, b, 0, b.length);
                    ld = FTIndexIterator.union(this.fuzzy(cne[k], ne, tdid, b, d + 1, p, r, c, f), ld);
                    b = new byte[vsn.length];
                    System.arraycopy(vsn, 1, b, 1, vsn.length - 1);
                    b[0] = (byte)ne[1];
                    ld = FTIndexIterator.union(this.fuzzy(cne[k], ne, tdid, b, d, p, r + 1, c, f), ld);
                }
            }
            k += 2;
        }
        return ld;
    }
}

